/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm23.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm23.events.EventManager;
import com.ibm.j9ddr.vm23.j9.gc.GCIterator;
import com.ibm.j9ddr.vm23.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9VMThreadPointer;
import java.util.NoSuchElementException;

public class GCVMThreadListIterator
extends GCIterator {
    protected J9VMThreadPointer initialVMThread;
    protected J9VMThreadPointer currentVMThread;
    protected boolean consumedInitial;

    protected GCVMThreadListIterator(J9JavaVMPointer vm) throws CorruptDataException {
        this.currentVMThread = this.initialVMThread = vm.mainThread();
    }

    public static GCVMThreadListIterator fromJ9JavaVM(J9JavaVMPointer vm) throws CorruptDataException {
        return new GCVMThreadListIterator(vm);
    }

    public boolean hasNext() {
        return this.currentVMThread.notNull();
    }

    public J9VMThreadPointer next() {
        try {
            if (this.hasNext()) {
                J9VMThreadPointer next = this.currentVMThread;
                this.currentVMThread = this.currentVMThread.linkNext();
                if (this.currentVMThread.equals(this.initialVMThread)) {
                    this.currentVMThread = J9VMThreadPointer.NULL;
                }
                return next;
            }
            throw new NoSuchElementException("There are no more items available through this iterator");
        }
        catch (CorruptDataException cde) {
            this.currentVMThread = J9VMThreadPointer.NULL;
            EventManager.raiseCorruptDataEvent("Error getting next item", cde, false);
            return null;
        }
    }
}

