/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm23.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm23.j9.AlgorithmVersion;
import com.ibm.j9ddr.vm23.j9.gc.GCArrayObjectModel;
import com.ibm.j9ddr.vm23.j9.gc.GCMixedObjectModel;
import com.ibm.j9ddr.vm23.j9.gc.GCObjectModel_V1;
import com.ibm.j9ddr.vm23.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm23.types.U32;
import com.ibm.j9ddr.vm23.types.UDATA;

public abstract class GCObjectModel {
    protected J9JavaVMPointer vm;
    protected GCMixedObjectModel mixedObjectModel;
    protected GCArrayObjectModel indexableObjectModel;

    protected GCObjectModel(J9JavaVMPointer vm) throws CorruptDataException {
        this.vm = vm;
        this.mixedObjectModel = GCMixedObjectModel.fromJ9JavaVM(vm);
        this.indexableObjectModel = GCArrayObjectModel.fromJ9JavaVM(vm);
    }

    public static GCObjectModel fromJ9JavaVM(J9JavaVMPointer vm) throws CorruptDataException {
        AlgorithmVersion version = AlgorithmVersion.getVersionOf("ALG_GC_OBJECT_MODEL_VERSION");
        switch (version.getAlgorithmVersion()) {
            default: 
        }
        return new GCObjectModel_V1(vm);
    }

    public abstract UDATA adjustSizeInBytes(UDATA var1);

    public abstract UDATA adjustSizeInSlots(UDATA var1);

    public abstract U32 getObjectShape(J9ObjectPointer var1) throws CorruptDataException;

    public abstract boolean isIndexable(J9ObjectPointer var1) throws CorruptDataException;

    public abstract boolean isDeadObject(J9ObjectPointer var1) throws CorruptDataException;

    public abstract boolean isSingleSlotDeadObject(J9ObjectPointer var1) throws CorruptDataException;

    public abstract UDATA getSizeInBytesMultiSlotDeadObject(J9ObjectPointer var1) throws CorruptDataException;

    public abstract UDATA getSizeInBytesSingleSlotDeadObject(J9ObjectPointer var1);

    public abstract UDATA getSizeInBytesDeadObject(J9ObjectPointer var1) throws CorruptDataException;

    public abstract UDATA getSizeInBytesWithoutHeader(J9ObjectPointer var1) throws CorruptDataException;

    public abstract UDATA getSizeInBytesWithHeader(J9ObjectPointer var1) throws CorruptDataException;

    public abstract UDATA getConsumedSizeInBytesWithHeader(J9ObjectPointer var1) throws CorruptDataException;

    public abstract UDATA getSizeInSlotsWithoutHeader(J9ObjectPointer var1) throws CorruptDataException;

    public abstract UDATA getSizeInSlotsWithHeader(J9ObjectPointer var1) throws CorruptDataException;

    public abstract UDATA getConsumedSizeInSlotsWithHeader(J9ObjectPointer var1) throws CorruptDataException;

    public abstract U32 getAge(J9ObjectPointer var1) throws CorruptDataException;

    public abstract boolean isRemembered(J9ObjectPointer var1) throws CorruptDataException;

    public abstract boolean isOld(J9ObjectPointer var1) throws CorruptDataException;

    public abstract UDATA getSizeInElements(J9ObjectPointer var1) throws IllegalArgumentException, CorruptDataException;

    public abstract int getObjectHashCode(J9ObjectPointer var1) throws CorruptDataException;
}

