/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm23.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm23.j9.AlgorithmVersion;
import com.ibm.j9ddr.vm23.j9.DataType;
import com.ibm.j9ddr.vm23.j9.Pool_23_V0;
import com.ibm.j9ddr.vm23.pointer.generated.J9PoolPointer;
import java.util.Iterator;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Pool<StructType extends DataType> {
    protected J9PoolPointer pool;
    protected Class<StructType> structType;
    protected long elementSize;
    protected static final Logger logger = Logger.getLogger("j9ddr.walkers.pool");

    protected <T extends DataType> Pool(J9PoolPointer structure, Class<T> structType) throws CorruptDataException {
        this.pool = structure;
        this.structType = structType;
        if (this.pool.notNull()) {
            this.elementSize = structure.elementSize().longValue();
        }
    }

    public static <T extends DataType> Pool<T> fromJ9Pool(J9PoolPointer structure, Class<T> structType) throws CorruptDataException {
        return Pool.fromJ9Pool(structure, structType, true);
    }

    public static <T extends DataType> Pool<T> fromJ9Pool(J9PoolPointer structure, Class<T> structType, boolean isInline) throws CorruptDataException {
        switch (AlgorithmVersion.getVMMinorVersion()) {
            default: 
        }
        logger.fine("Creating version 2.3.0 pool walker");
        return new Pool_23_V0(structure, structType, isInline);
    }

    public abstract long numElements();

    public abstract boolean includesElement(StructType var1);

    public abstract Iterator<StructType> iterator();
}

