/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm23.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm23.j9.AlgorithmVersion;
import com.ibm.j9ddr.vm23.j9.HashTable_V1;
import com.ibm.j9ddr.vm23.j9.HashTable_V2;
import com.ibm.j9ddr.vm23.j9.IHashTable;
import com.ibm.j9ddr.vm23.pointer.AbstractPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9HashTablePointer;
import com.ibm.j9ddr.vm23.types.UDATA;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HashTable<StructType extends AbstractPointer>
implements IHashTable<StructType> {
    protected J9HashTablePointer _table;
    protected Class<StructType> _structType;
    protected HashEqualFunction<StructType> _equalFn;
    protected HashFunction<StructType> _hashFn;
    protected HashComparatorFunction<StructType> _comparatorFn;

    protected <T extends AbstractPointer> HashTable(J9HashTablePointer structure, Class<T> structType, HashEqualFunction<T> equalFn, HashFunction<T> hashFn, HashComparatorFunction<T> comparatorFn) throws CorruptDataException {
        this._table = structure;
        this._comparatorFn = comparatorFn;
        this._structType = structType;
        this._equalFn = equalFn;
        this._hashFn = hashFn;
    }

    public static <T extends AbstractPointer> HashTable<T> fromJ9HashTable(J9HashTablePointer structure, Class<T> structType, HashEqualFunction<T> equalFn, HashFunction<T> hashFn) throws CorruptDataException {
        AlgorithmVersion version = AlgorithmVersion.getVersionOf("VM_HASHTABLE_VERSION");
        switch (version.getAlgorithmVersion()) {
            case 0: {
                return new HashTable_V1(structure, structType, equalFn, hashFn);
            }
        }
        return new HashTable_V2<T>(structure, true, structType, equalFn, hashFn);
    }

    public static <T extends AbstractPointer> HashTable<T> fromJ9HashTable(J9HashTablePointer structure, boolean isInline, Class<T> structType, HashEqualFunction<T> equalFn, HashFunction<T> hashFn) throws CorruptDataException {
        AlgorithmVersion version = AlgorithmVersion.getVersionOf("VM_HASHTABLE_VERSION");
        switch (version.getAlgorithmVersion()) {
            case 0: {
                if (!isInline) {
                    throw new UnsupportedOperationException("Hashtable V1 does not support non-inline");
                }
                return new HashTable_V1(structure, structType, equalFn, hashFn);
            }
        }
        return new HashTable_V2<T>(structure, isInline, structType, equalFn, hashFn);
    }

    public static <T extends AbstractPointer> HashTable<T> fromJ9HashTable(J9HashTablePointer structure, boolean isInline, Class<T> structType, HashFunction<T> hashFn, HashComparatorFunction<T> comparatorFn) throws CorruptDataException {
        AlgorithmVersion version = AlgorithmVersion.getVersionOf("VM_HASHTABLE_VERSION");
        switch (version.getAlgorithmVersion()) {
            case 0: {
                throw new UnsupportedOperationException("Hashtable V1 requires HashEqualFunction");
            }
        }
        return new HashTable_V2<T>(structure, isInline, structType, hashFn, comparatorFn);
    }

    @Override
    public abstract String getTableName();

    @Override
    public abstract long getCount();

    public abstract StructType find(StructType var1) throws CorruptDataException;

    @Override
    public abstract Iterator<StructType> iterator();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface HashComparatorFunction<StructType extends AbstractPointer> {
        public int compare(StructType var1, StructType var2) throws CorruptDataException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface HashEqualFunction<StructType> {
        public boolean equal(StructType var1, StructType var2) throws CorruptDataException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface HashFunction<StructType> {
        public UDATA hash(StructType var1) throws CorruptDataException;
    }
}

