/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.DataUnavailableException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import java.io.PrintStream;

public class LookupSymbolCommand
extends Command {
    protected String hexformat = null;

    public LookupSymbolCommand() {
        this.addCommand("sym", "<address>", "Display the symbol, or closest symbol to <address>");
    }

    public void run(String cmd, String[] args, Context ctx, PrintStream out) throws DDRInteractiveCommandException {
        if (args.length != 1) {
            out.println("Please supply a function pointer to lookup.");
            return;
        }
        boolean is64BitPlatform = ctx.process.bytesPerPointer() == 8;
        long address = CommandUtils.parsePointer(args[0], is64BitPlatform);
        try {
            String symbol = ctx.process.getProcedureNameForAddress(address);
            out.println("Closest match:");
            out.println(symbol);
        }
        catch (DataUnavailableException e) {
            throw new DDRInteractiveCommandException(e);
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
    }
}

