/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.libraries;

import com.ibm.j9ddr.libraries.DDRLibraryAdapter;
import com.ibm.j9ddr.libraries.DTFJLibraryAdapter;
import com.ibm.j9ddr.libraries.Footer;
import com.ibm.j9ddr.libraries.LibraryAdapter;
import com.ibm.j9ddr.libraries.MonitoredFileOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibraryCollector {
    static final String LOGGER_NAME = "com.ibm.j9ddr.libraries";
    public static final String PUBLIC_LOGGER_NAME = "com.ibm.j9ddr.libraries.public";
    private static final Logger logger = Logger.getLogger("com.ibm.j9ddr.libraries");
    private static final Logger publicLogger = Logger.getLogger("com.ibm.j9ddr.libraries.public");
    private static final byte[] FOOTER_MAGIC_BYTES = new byte[]{30, -81, 16, -83};
    private Footer footer = null;
    private static final int BUFFER_SIZE = 4096;
    private final byte[] buffer = new byte[4096];
    private long start = 0L;
    private final ArrayList<File> searchPath = new ArrayList();

    public static void main(String[] args) {
        LibraryCollector collector = new LibraryCollector();
        ConsoleHandler handler = new ConsoleHandler();
        handler.setLevel(Level.FINEST);
        SimpleFormatter formatter = new SimpleFormatter();
        handler.setFormatter(formatter);
        Logger log = Logger.getLogger(PUBLIC_LOGGER_NAME);
        log.addHandler(handler);
        log.setLevel(Level.FINEST);
        CollectorResult result = collector.collectLibrariesFor(args[0], args[1]);
        System.out.println("Collection completed with result : " + result.name());
    }

    public CollectorResult collectLibrariesFor(String coreFilePath, String type) {
        CollectorResult result = null;
        result = CollectionType.DTFJ.name().equals(type) ? this.collectLibrariesFor(coreFilePath, CollectionType.DTFJ) : this.collectLibrariesFor(coreFilePath, CollectionType.DDR);
        return result;
    }

    public CollectorResult collectLibrariesFor(String coreFilePath, CollectionType type) {
        File coreFile = new File(coreFilePath);
        if (coreFile.exists()) {
            if (this.areLibrariesPresent(coreFile)) {
                return CollectorResult.COMPLETE_ALREADY_PRESENT;
            }
            return this.collectLibrariesFor(coreFile, type);
        }
        throw new IllegalArgumentException("The core file specified at " + coreFilePath + " does not exist");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean areLibrariesPresent(File coreFile) {
        logger.fine("Checking to see if the libraries have already been collected");
        RandomAccessFile stream = null;
        try {
            stream = new RandomAccessFile(coreFile, "r");
            stream.seek(stream.length() - 4L);
            byte[] data = new byte[FOOTER_MAGIC_BYTES.length];
            stream.read(data);
            for (int i = 0; i < data.length; ++i) {
                if (data[i] == FOOTER_MAGIC_BYTES[i]) continue;
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception e) {
            publicLogger.log(Level.FINE, "Could not check core file library collection status", e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception e) {
                    publicLogger.log(Level.FINE, "Could not close core file", e);
                }
            }
        }
        return true;
    }

    private void writeFooter(File coreFile) {
        try {
            MonitoredFileOutputStream out = new MonitoredFileOutputStream(coreFile, true);
            ObjectOutputStream stream = new ObjectOutputStream(out);
            stream.writeObject(this.footer);
            stream.flush();
            logger.fine("Footer size : " + out.getBytesWritten());
            out.write(out.getBytesWrittenAsArray());
            out.write(FOOTER_MAGIC_BYTES);
            out.flush();
            out.close();
            if (logger.isLoggable(Level.FINEST)) {
                FileOutputStream fos = new FileOutputStream("footer.ser");
                ObjectOutputStream oos = new ObjectOutputStream(fos);
                oos.writeObject(this.footer);
                oos.close();
            }
        }
        catch (IOException e) {
            publicLogger.log(Level.FINE, "Could not write out collection footer", e);
        }
        logger.finer(this.footer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CollectorResult collectLibrariesFor(File coreFile, CollectionType type) {
        LibraryAdapter adapter = this.getAdapterForCollectionType(type);
        if (adapter.isLibraryCollectionRequired(coreFile)) {
            ArrayList<String> modules = adapter.getLibraryList(coreFile);
            this.createSearchPathForLibraries(modules);
            this.footer = new Footer(modules.size());
            for (String msg : adapter.getErrorMessages()) {
                this.footer.addErrorMessage(msg);
            }
            RandomAccessFile out = null;
            try {
                out = new RandomAccessFile(coreFile, "rw");
                this.start = out.length();
                out.seek(this.start);
                for (String module : modules) {
                    int bytesAppended = this.appendLibraryToCoreFile(module, out);
                    if (bytesAppended != 0) {
                        this.footer.addEntry(module, bytesAppended, this.start);
                    }
                    this.start += (long)bytesAppended;
                }
                out.close();
                this.writeFooter(coreFile);
            }
            catch (FileNotFoundException e) {
                publicLogger.log(Level.FINE, "Could not find core file", e);
            }
            catch (IOException e) {
                publicLogger.log(Level.FINE, "Error writing libraries", e);
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        logger.log(Level.FINE, "Could not close core file output stream", e);
                    }
                }
            }
            if (this.footer.getErrorMessages().length == 0) {
                return CollectorResult.COMPLETE;
            }
            return CollectorResult.COMPLETE_ERRORS;
        }
        publicLogger.fine("This core file is not identified as requiring library collection");
        return CollectorResult.COMPLETE_NOT_REQUIRED;
    }

    private LibraryAdapter getAdapterForCollectionType(CollectionType type) {
        switch (type) {
            case DTFJ: {
                logger.fine("Using DTFJ library adaptor");
                return new DTFJLibraryAdapter();
            }
            case DDR: {
                logger.fine("Using DDR library adaptor");
                return new DDRLibraryAdapter();
            }
        }
        logger.fine("Using DDR library adaptor (default)");
        return new DDRLibraryAdapter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int appendLibraryToCoreFile(String name, RandomAccessFile out) {
        int bytesAppended = 0;
        File file = this.locateLibrary(name);
        FileInputStream in = null;
        if (file.exists()) {
            publicLogger.fine("Collecting library: " + name);
            try {
                in = new FileInputStream(file);
                int bytesRead = in.read(this.buffer);
                while (bytesRead != -1) {
                    bytesAppended += bytesRead;
                    out.write(this.buffer, 0, bytesRead);
                    bytesRead = in.read(this.buffer);
                }
                return bytesAppended;
            }
            catch (FileNotFoundException e) {
                if (name.startsWith("linux-vdso.so.1") || name.startsWith("linux-gate") || name.equals("lib.so")) return bytesAppended;
                String msg = "Could not add library [" + name + "] as the file does not exist";
                publicLogger.fine(msg);
                this.footer.addErrorMessage(msg);
                return bytesAppended;
            }
            catch (IOException e) {
                this.footer.addErrorMessage("Could not append library : " + e.getMessage());
                publicLogger.log(Level.FINE, "Could not collect library", e);
                return bytesAppended;
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        logger.log(Level.FINE, "Could not close library input stream", e);
                    }
                }
            }
        }
        if (name.startsWith("linux-vdso.so.1") || name.startsWith("linux-gate") || name.equals("lib.so")) return bytesAppended;
        String msg = "Could not add library [" + name + "] as the file does not exist";
        publicLogger.fine(msg);
        this.footer.addErrorMessage(msg);
        return bytesAppended;
    }

    private File locateLibrary(String name) {
        File module = new File(name);
        if (module.exists()) {
            return module;
        }
        for (File dir : this.searchPath) {
            module = new File(dir, name);
            logger.finer("Searching " + module.getAbsolutePath());
            if (!module.exists()) continue;
            return module;
        }
        return new File(name);
    }

    private void createSearchPathForLibraries(ArrayList<String> modules) {
        String jre_bin = System.getProperty("java.home") + File.separator + "bin";
        File javaPath = new File(jre_bin);
        logger.fine("Adding search path " + javaPath.getAbsolutePath());
        this.searchPath.add(javaPath);
        this.searchPath.add(new File("/lib"));
        this.searchPath.add(new File("/lib64"));
        this.searchPath.add(new File("/usr/lib"));
        this.searchPath.add(new File("/usr/lib64"));
        this.searchPath.add(new File("/usr/local/lib"));
        this.searchPath.add(new File("/usr/local/lib64"));
        File file = null;
        for (String module : modules) {
            file = new File(module);
            File parent = file.getParentFile();
            if (parent == null || !parent.isDirectory() || this.searchPath.contains(parent)) continue;
            logger.fine("Adding search path " + parent.getAbsolutePath());
            this.searchPath.add(parent);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CollectionType {
        DTFJ,
        DDR;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CollectorResult {
        COMPLETE_NOT_REQUIRED,
        COMPLETE_ALREADY_PRESENT,
        COMPLETE_ERRORS,
        COMPLETE;

    }
}

