/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.memory;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.DataUnavailableException;
import com.ibm.j9ddr.corereaders.ICore;
import com.ibm.j9ddr.corereaders.memory.AbstractMemory;
import com.ibm.j9ddr.corereaders.memory.IAddressSpace;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import com.ibm.j9ddr.corereaders.memory.MemoryFault;
import com.ibm.j9ddr.corereaders.memory.SymbolUtil;
import java.nio.ByteOrder;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProcessAddressSpace
extends AbstractMemory
implements IProcess,
IAddressSpace {
    private final int bytesPerPointer;
    private static final int addressSpaceID = 0;
    private final String id;

    public ProcessAddressSpace(int pointerSizeBytes, ByteOrder byteOrder, ICore core) {
        super(byteOrder);
        this.bytesPerPointer = pointerSizeBytes;
        this.id = core.getDumpFormat() + " : 0";
    }

    @Override
    public int bytesPerPointer() {
        return this.bytesPerPointer;
    }

    @Override
    public long getPointerAt(long address) throws MemoryFault {
        if (this.bytesPerPointer() == 8) {
            return this.getLongAt(address);
        }
        return 0xFFFFFFFFL & (long)this.getIntAt(address);
    }

    @Override
    public int getAddressSpaceId() {
        return 0;
    }

    @Override
    public IAddressSpace getAddressSpace() {
        return this;
    }

    public List<IProcess> getProcesses() {
        LinkedList<IProcess> toReturn = new LinkedList<IProcess>();
        toReturn.add(this);
        return toReturn;
    }

    public String toString() {
        return this.id;
    }

    @Override
    public final String getProcedureNameForAddress(long address) throws CorruptDataException {
        return this.getProcedureNameForAddress(address, false);
    }

    @Override
    public String getProcedureNameForAddress(long address, boolean dtfjFormat) throws CorruptDataException {
        try {
            return SymbolUtil.getProcedureNameForAddress(this, address, dtfjFormat);
        }
        catch (DataUnavailableException e) {
            return "<unknown: " + e.getMessage() + ">";
        }
    }
}

