/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.debugger;

import com.ibm.j9ddr.corereaders.Platform;
import com.ibm.j9ddr.corereaders.debugger.JniNatives;
import com.ibm.j9ddr.corereaders.memory.IMemory;
import com.ibm.j9ddr.corereaders.memory.IMemoryRange;
import com.ibm.j9ddr.corereaders.memory.MemoryFault;
import com.ibm.j9ddr.corereaders.memory.MemoryRange;
import java.nio.ByteOrder;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JniMemory
implements IMemory {
    private long searchSize = Integer.MAX_VALUE;

    @Override
    public native byte getByteAt(long var1) throws MemoryFault;

    @Override
    public native ByteOrder getByteOrder();

    @Override
    public native int getBytesAt(long var1, byte[] var3) throws MemoryFault;

    @Override
    public native int getBytesAt(long var1, byte[] var3, int var4, int var5) throws MemoryFault;

    @Override
    public native int getIntAt(long var1) throws MemoryFault;

    @Override
    public native long getLongAt(long var1) throws MemoryFault;

    @Override
    public native short getShortAt(long var1) throws MemoryFault;

    @Override
    public Properties getProperties(long address) {
        return new Properties();
    }

    @Override
    public Platform getPlatform() {
        return JniNatives.getPlatform();
    }

    @Override
    public native boolean isExecutable(long var1);

    @Override
    public native boolean isReadOnly(long var1);

    @Override
    public native boolean isShared(long var1);

    public long getPointerAt(long address, int bytesPerPointer) throws MemoryFault {
        if (bytesPerPointer == 8) {
            return this.getLongAt(address);
        }
        return this.getIntAt(address);
    }

    public native long readAddress(long var1);

    @Override
    public Collection<? extends IMemoryRange> getMemoryRanges() {
        LinkedList<MemoryRange> ranges = new LinkedList<MemoryRange>();
        MemoryRange region = JniMemory.getValidRegionVirtual(0L, this.searchSize);
        while (region != null) {
            ranges.add(region);
            region = JniMemory.getValidRegionVirtual(region.getBaseAddress() + region.getSize(), this.searchSize);
        }
        return ranges;
    }

    private static native MemoryRange getValidRegionVirtual(long var0, long var2);
}

