/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr;

import com.ibm.j9ddr.IVMData;
import com.ibm.j9ddr.StructureHeader;
import com.ibm.j9ddr.StructureReader;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.SecureClassLoader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class J9DDRClassLoader
extends SecureClassLoader {
    private HashMap<String, Class<?>> cache = new HashMap();
    private StructureReader reader;
    private final String packageDotName;
    private final String packageBaseDotName;
    private IVMData vmData = null;

    public J9DDRClassLoader(StructureReader reader, ClassLoader parent) {
        super(parent);
        this.reader = reader;
        this.packageDotName = reader.getPackageName(StructureReader.PackageNameType.STRUCTURE_PACKAGE_DOT_NAME);
        String baseName = reader.getPackageName(StructureReader.PackageNameType.PACKAGE_DOT_BASE_NAME);
        this.packageBaseDotName = baseName.endsWith(".") ? baseName : baseName + ".";
    }

    public StructureHeader getHeader() {
        return this.reader.getHeader();
    }

    @Override
    protected Class<?> findClass(String binaryName) throws ClassNotFoundException {
        if (this.cache.containsKey(binaryName)) {
            return this.cache.get(binaryName);
        }
        if (binaryName.startsWith(this.packageDotName)) {
            byte[] data = this.getClazz(binaryName);
            Class<?> clazz = this.defineClass(binaryName, data, 0, data.length);
            this.cache.put(binaryName, clazz);
            return clazz;
        }
        return this.duplicateClass(binaryName);
    }

    private Class<?> duplicateClass(String binaryName) throws ClassNotFoundException {
        String resourceName = binaryName.replace('.', '/');
        resourceName = resourceName + ".class";
        InputStream stream = this.getParent().getResourceAsStream(resourceName);
        if (stream == null) {
            throw new ClassNotFoundException("Couldn't duplicate class " + binaryName + ". Couldn't load resource " + resourceName + ", parent classloader " + this.getParent());
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] localBuffer = new byte[1024];
        try {
            int read;
            while ((read = stream.read(localBuffer)) != -1) {
                baos.write(localBuffer, 0, read);
            }
        }
        catch (IOException ex) {
            throw new ClassNotFoundException("IOException reading resource " + resourceName + " for class " + binaryName, ex);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {}
        }
        byte[] classBuffer = baos.toByteArray();
        return this.defineClass(binaryName, classBuffer, 0, classBuffer.length);
    }

    private void definePackage(String name) {
        int finalSeparator = name.lastIndexOf(".");
        if (finalSeparator != -1) {
            String packageName = name.substring(0, finalSeparator);
            if (this.getPackage(packageName) != null) {
                return;
            }
            this.definePackage(packageName, "J9DDR", "0.1", "IBM", "J9DDR", "0.1", "IBM", null);
        }
    }

    public Class<?> loadClassRelativeToStream(String name, boolean resolve) throws ClassNotFoundException {
        return this.loadClass(this.packageBaseDotName + name, resolve);
    }

    @Override
    public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (name.startsWith(this.packageBaseDotName)) {
            Class<?> clazz = this.findLoadedClass(name);
            if (null == clazz) {
                clazz = this.findClass(name);
                this.definePackage(name);
                if (resolve) {
                    this.resolveClass(clazz);
                }
            }
            return clazz;
        }
        if (name.startsWith(this.reader.getBasePackage())) {
            throw new ClassNotFoundException("Cannot load " + name + ". J9DDRClassLoader is configured to load " + this.packageBaseDotName + " DDR classes only.");
        }
        return this.getParent().loadClass(name);
    }

    private byte[] getClazz(String binaryName) throws ClassNotFoundException {
        if (this.reader == null) {
            throw new IllegalStateException("The structure reader has not been initialised");
        }
        int pos = binaryName.lastIndexOf(46);
        String name = binaryName.substring(pos + 1);
        try {
            return this.reader.getClassBytes(binaryName);
        }
        catch (IllegalArgumentException e) {
            throw new ClassNotFoundException(binaryName);
        }
    }

    public Collection<StructureReader.StructureDescriptor> getStructures() {
        return Collections.unmodifiableCollection(this.reader.getStructures());
    }

    public IVMData getIVMData(IProcess process, long address) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        if (this.vmData != null) {
            return this.vmData;
        }
        Class<?> vmDataClazz = this.loadClassRelativeToStream("j9.VMData", false);
        this.vmData = (IVMData)vmDataClazz.newInstance();
        return this.vmData;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("J9DDRClassloader for ");
        builder.append(this.packageBaseDotName);
        return builder.toString();
    }

    public StructureReader getReader() {
        return this.reader;
    }
}

