/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.jcae;

import com.certicom.ecc.interfaces.ECKey;
import com.certicom.ecc.interfaces.ECParams;
import com.certicom.ecc.interfaces.PointParams;
import com.certicom.ecc.jcae.CurveList;
import com.certicom.ecc.jcae.ECPrivateKey;
import com.certicom.ecc.jcae.ECPublicKey;
import com.certicom.ecc.scheme.CryptoTransform;
import com.certicom.ecc.system.CryptoManager;
import com.certicom.ecc.system.SystemConfig;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.security.spec.ECParameterSpec;
import javax.security.spec.ECPrivateKeySpec;
import javax.security.spec.ECPublicKeySpec;
import javax.security.spec.ECRawPublicKeySpec;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class ECKeyFactorySpi
extends KeyFactorySpi {
    private AlgorithmParameterSpec for;
    private CryptoTransform try;
    private int case;
    private int do;
    private static final Class new = class$com$certicom$ecc$interfaces$ECPrivateKey != null ? class$com$certicom$ecc$interfaces$ECPrivateKey : (class$com$certicom$ecc$interfaces$ECPrivateKey = ECKeyFactorySpi.class$("com.certicom.ecc.interfaces.ECPrivateKey"));
    private static final Class a = class$com$certicom$ecc$interfaces$ECPublicKey != null ? class$com$certicom$ecc$interfaces$ECPublicKey : (class$com$certicom$ecc$interfaces$ECPublicKey = ECKeyFactorySpi.class$("com.certicom.ecc.interfaces.ECPublicKey"));
    private static final Class byte = class$java$security$spec$X509EncodedKeySpec != null ? class$java$security$spec$X509EncodedKeySpec : (class$java$security$spec$X509EncodedKeySpec = ECKeyFactorySpi.class$("java.security.spec.X509EncodedKeySpec"));
    private static final Class int = class$java$security$spec$PKCS8EncodedKeySpec != null ? class$java$security$spec$PKCS8EncodedKeySpec : (class$java$security$spec$PKCS8EncodedKeySpec = ECKeyFactorySpi.class$("java.security.spec.PKCS8EncodedKeySpec"));
    private static final Class if = class$javax$security$spec$ECRawPublicKeySpec != null ? class$javax$security$spec$ECRawPublicKeySpec : (class$javax$security$spec$ECRawPublicKeySpec = ECKeyFactorySpi.class$("javax.security.spec.ECRawPublicKeySpec"));
    static /* synthetic */ Class class$com$certicom$ecc$interfaces$ECPrivateKey;
    static /* synthetic */ Class class$com$certicom$ecc$interfaces$ECPublicKey;
    static /* synthetic */ Class class$java$security$spec$X509EncodedKeySpec;
    static /* synthetic */ Class class$java$security$spec$PKCS8EncodedKeySpec;
    static /* synthetic */ Class class$javax$security$spec$ECRawPublicKeySpec;

    public ECKeyFactorySpi() {
        SystemConfig systemConfig = SystemConfig.getConfig();
        this.for = CurveList.byName("ImplicitlyCA");
        this.case = systemConfig.getFormat();
        this.do = systemConfig.getPtCompression();
        this.try = (CryptoTransform)CryptoManager.getInstance(CryptoTransform.TYPE, "KEYFAC");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof ECPrivateKeySpec) {
            ECPrivateKeySpec eCPrivateKeySpec = (ECPrivateKeySpec)keySpec;
            ECParameterSpec eCParameterSpec = eCPrivateKeySpec.getParams();
            ECParams eCParams = (ECParams)((Object)CurveList.a(eCParameterSpec));
            return new ECPrivateKey(this.case, eCPrivateKeySpec.getExp(), eCParams);
        }
        if (keySpec instanceof PKCS8EncodedKeySpec) {
            byte[] byArray = ((PKCS8EncodedKeySpec)keySpec).getEncoded();
            this.try.init(5, new Object[]{new, this.for}, null);
            return new ECPrivateKey(this.case, (com.certicom.ecc.interfaces.ECPrivateKey)this.try.transformToObject(byArray, 0, byArray.length, true));
        }
        throw new InvalidKeySpecException("does not support " + keySpec.getClass().getName());
    }

    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof ECPublicKeySpec) {
            ECPublicKeySpec eCPublicKeySpec = (ECPublicKeySpec)keySpec;
            ECParameterSpec eCParameterSpec = eCPublicKeySpec.getParams();
            return new ECPublicKey(this.case, this.do, eCPublicKeySpec.getX(), eCPublicKeySpec.getY(), (ECParams)((Object)CurveList.a(eCParameterSpec)));
        }
        if (keySpec instanceof X509EncodedKeySpec) {
            byte[] byArray = ((X509EncodedKeySpec)keySpec).getEncoded();
            this.try.init(5, new Object[]{a, this.for}, null);
            return new ECPublicKey(this.case, this.do, (com.certicom.ecc.interfaces.ECPublicKey)this.try.transformToObject(byArray, 0, byArray.length, true));
        }
        if (keySpec instanceof ECRawPublicKeySpec) {
            ECRawPublicKeySpec eCRawPublicKeySpec = (ECRawPublicKeySpec)keySpec;
            ECParameterSpec eCParameterSpec = eCRawPublicKeySpec.getParams();
            byte[] byArray = eCRawPublicKeySpec.getPt();
            ECParams eCParams = (ECParams)((Object)CurveList.a(eCParameterSpec));
            PointParams pointParams = eCParams.getPoint();
            PointParams pointParams2 = pointParams.getDecoded(byArray, 0, byArray.length);
            return new ECPublicKey(this.case, this.do, pointParams2.getX(), pointParams2.getY(), eCParams);
        }
        throw new InvalidKeySpecException("does not support " + keySpec.getClass().getName());
    }

    protected KeySpec engineGetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
        if (key instanceof ECKey) {
            KeySpec keySpec = null;
            if (byte.isAssignableFrom(clazz)) {
                ECKey eCKey = (ECKey)((Object)key);
                if (key instanceof com.certicom.ecc.interfaces.ECPublicKey && key.getFormat().equals("X.509")) {
                    keySpec = new X509EncodedKeySpec(eCKey.getEncoded());
                }
            } else if (int.isAssignableFrom(clazz)) {
                ECKey eCKey = (ECKey)((Object)key);
                if (key instanceof com.certicom.ecc.interfaces.ECPrivateKey && key.getFormat().equals("PKCS#8")) {
                    keySpec = new PKCS8EncodedKeySpec(eCKey.getEncoded());
                }
            } else if (if.isAssignableFrom(clazz)) {
                if (key instanceof com.certicom.ecc.interfaces.ECPublicKey) {
                    com.certicom.ecc.interfaces.ECPublicKey eCPublicKey = (com.certicom.ecc.interfaces.ECPublicKey)((Object)key);
                    byte[] byArray = eCPublicKey.getPoint().getEncoded(this.do);
                    ECParameterSpec eCParameterSpec = (ECParameterSpec)CurveList.a(eCPublicKey.getECParams(), true);
                    keySpec = new ECRawPublicKeySpec(byArray, eCParameterSpec);
                }
            } else {
                ECParams eCParams = ((ECKey)((Object)key)).getECParams();
                ECParameterSpec eCParameterSpec = (ECParameterSpec)CurveList.a(eCParams, true);
                if (key instanceof com.certicom.ecc.interfaces.ECPrivateKey) {
                    byte[] byArray = ((com.certicom.ecc.interfaces.ECPrivateKey)((Object)key)).getExp();
                    keySpec = new ECPrivateKeySpec(byArray, eCParameterSpec);
                } else {
                    com.certicom.ecc.interfaces.ECPublicKey eCPublicKey = (com.certicom.ecc.interfaces.ECPublicKey)((Object)key);
                    keySpec = new ECPublicKeySpec(eCPublicKey.getX(), eCPublicKey.getY(), eCParameterSpec);
                }
                if (!clazz.isInstance(keySpec)) {
                    keySpec = null;
                }
            }
            if (keySpec == null) {
                throw new InvalidKeySpecException("does not support " + clazz.getName());
            }
            return keySpec;
        }
        throw new InvalidKeySpecException("do not support " + key.getClass().getName());
    }

    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        if (key instanceof ECKey) {
            return key;
        }
        if (key instanceof javax.security.interfaces.ECKey) {
            javax.security.interfaces.ECParams eCParams = ((javax.security.interfaces.ECKey)key).getParams();
            ECParams eCParams2 = (ECParams)((Object)CurveList.a(eCParams));
            if (key instanceof javax.security.interfaces.ECPrivateKey) {
                byte[] byArray = ((javax.security.interfaces.ECPrivateKey)key).getExp();
                return new ECPrivateKey(this.case, byArray, eCParams2);
            }
            javax.security.interfaces.ECPublicKey eCPublicKey = (javax.security.interfaces.ECPublicKey)key;
            return new ECPublicKey(this.case, this.do, eCPublicKey.getX(), eCPublicKey.getY(), eCParams2);
        }
        throw new InvalidKeyException("invalid key" + key.getClass().getName());
    }
}

