/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.core.p2;

import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.InstallContext;
import com.ibm.cic.agent.core.InstallContextTree;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.internal.core.p2.P2Engine;
import com.ibm.cic.agent.internal.core.p2.Utils;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IFixApplicableOffering;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.IInstallableUnitContainer;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.IShareableUnit;
import com.ibm.cic.common.core.model.InstallableUnitPair;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.logging.Logger;
import com.ibm.cic.common.p2EclipseAdapterData.IP2ReferenceData;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class P2EclipseQualificationOperation {
    private static final Logger log = Logger.getLogger(P2EclipseQualificationOperation.class);
    private final AgentJob[] jobs;
    private final Profile profile;
    private final String contextId;
    private final InstallContextTree contextTree;
    private final InstallableUnitPair.List pairList;
    private HashSet jreSuIdsToFilter;

    public P2EclipseQualificationOperation(AgentJob[] jobs, Profile profile, String contextId, InstallContextTree contextTree) {
        this.jobs = jobs;
        this.profile = profile;
        this.contextId = contextId;
        this.contextTree = contextTree;
        this.pairList = contextTree.getPairs();
    }

    public IStatus qualify(IProgressMonitor monitor) {
        InstallContext context = this.profile.findInstallContext(this.contextId);
        InstallableUnitPair[] pairs = this.pairList.getPairs();
        HashMap additions = new HashMap(pairs.length);
        HashMap removals = new HashMap(pairs.length);
        IStatus status = P2Engine.getInstance().getPlanAdditionsAndRemovals(pairs, context, this.jobs, additions, removals, monitor);
        if (StatusUtil.isErrorOrCancel((IStatus)status)) {
            return status;
        }
        if (log.isDebugLoggable()) {
            log.debug("pairs before qualification:\n" + this.pairList);
        }
        this.getJreSusToFilter();
        InstallableUnitPair[] installableUnitPairArray = pairs;
        int n = pairs.length;
        int n2 = 0;
        while (n2 < n) {
            IInstallableUnit to;
            InstallableUnitPair pair = installableUnitPairArray[n2];
            IInstallableUnit from = pair.getFrom();
            if (this.shouldFilterUnit(removals, from)) {
                this.pairList.removeFrom(from);
            }
            if (this.shouldFilterUnit(additions, to = pair.getTo())) {
                this.pairList.removeTo(to);
            }
            ++n2;
        }
        if (log.isDebugLoggable()) {
            log.debug("pairs after qualification:\n" + this.pairList);
        }
        this.contextTree.setPairs(this.pairList);
        return Status.OK_STATUS;
    }

    private boolean shouldFilterUnit(HashMap map, IInstallableUnit unit) {
        List<IP2ReferenceData> refs;
        if (unit == null) {
            return false;
        }
        IInstallableUnitContainer parent = unit.getParent();
        if (parent instanceof IShareableUnit) {
            String suId = parent.getIdentity().getId();
            if (this.jreSuIdsToFilter.contains(suId)) {
                return true;
            }
            String adapterId = unit.getAdapterId();
            String unitId = unit.getIdentity().getId();
            if (!adapterId.equals("p2Eclipse")) {
                if (unitId.startsWith("org.eclipse.executable")) {
                    return true;
                }
                if (unitId.startsWith("org.eclipse.equinox.p2.bootstrap")) {
                    return true;
                }
                return suId.equals("org.eclipse.rcp.feature") && unitId.startsWith("org.eclipse.configuration");
            }
        }
        if ((refs = Utils.getP2ReferencesList(unit)).isEmpty()) {
            return false;
        }
        for (IP2ReferenceData element : refs) {
            IP2ReferenceData ref = element;
            String versionedUnitId = this.getVersionedUnitId(ref);
            if (map.containsKey(versionedUnitId)) continue;
            return true;
        }
        return false;
    }

    private String getVersionedUnitId(IP2ReferenceData ref) {
        String id = ref.getId();
        return String.valueOf(id) + '_' + ref.getVersionStr();
    }

    private void getJreSusToFilter() {
        this.jreSuIdsToFilter = new HashSet();
        String installPackagedJre = this.profile.getData("install.packaged.jre.for.eclipse.ide");
        if (Boolean.valueOf(installPackagedJre).booleanValue()) {
            return;
        }
        AgentJob[] agentJobArray = this.jobs;
        int n = this.jobs.length;
        int n2 = 0;
        while (n2 < n) {
            AgentJob job = agentJobArray[n2];
            IOfferingOrFix offeringOrFix = job.getOfferingOrFix();
            this.getJreSuToFilter(offeringOrFix);
            ++n2;
        }
    }

    private void getJreSuToFilter(IOfferingOrFix offeringOrFix) {
        String jreSuId = offeringOrFix.getProperties().getProperty("packaged.jre.for.eclipse.ide");
        if (jreSuId == null && offeringOrFix instanceof IFix) {
            IFix fix = (IFix)offeringOrFix;
            for (IFixApplicableOffering applicableOffering : fix.getApplicableOfferings()) {
                IOffering baseOffering = this.profile.findOffering(applicableOffering.getIdentity().getId());
                if (baseOffering != null && applicableOffering.getTolerance().isIncluded(baseOffering.getVersion()) && (jreSuId = baseOffering.getProperties().getProperty("packaged.jre.for.eclipse.ide")) != null) break;
            }
        }
        if (jreSuId == null) {
            jreSuId = "com.ibm.java.jre";
        }
        this.jreSuIdsToFilter.add(jreSuId);
    }
}

