/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cert.ldap;

import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.cert.MemoryCache;
import com.ibm.security.cert.X509CertificatePair;
import com.ibm.security.util.Cache;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X509CRLImpl;
import com.ibm.security.x509.X509CertImpl;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.URI;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.PublicKey;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CRLSelector;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.CertStoreParameters;
import java.security.cert.CertStoreSpi;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.LDAPCertStoreParameters;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLSelector;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.naming.CommunicationException;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.ldap.LdapName;
import javax.security.auth.x500.X500Principal;

public class LDAPCertStoreImpl
extends CertStoreSpi {
    private static final String USER_CERT = "userCertificate";
    private static final String CA_CERT = "cACertificate";
    private static final String CROSS_CERT = "crossCertificatePair";
    private static final String CRL = "certificateRevocationList";
    private static final String ARL = "authorityRevocationList";
    private static final String USER_CERT_BIN = "userCertificate;binary";
    private static final String CA_CERT_BIN = "cACertificate;binary";
    private static final String CROSS_CERT_BIN = "crossCertificatePair;binary";
    private static final String CRL_BIN = "certificateRevocationList;binary";
    private static final String ARL_BIN = "authorityRevocationList;binary";
    private static final byte[][] EMPTY_VALUES = new byte[0][];
    private static final int DEFAULT_CACHE_SIZE = 3000;
    private static final int DEFAULT_CACHE_LIFETIME = 600;
    private static int LIFETIME;
    private static final String PROP_LIFETIME = "ibm.security.certpath.ldap.cache.lifetime";
    private DirContext ctx;
    private static final int MAXIMUM_CONSECUTIVE_FAILED_GETATTRIBUTE_ATTEMPTS = 2;
    private int consecutiveFailedGetAttributeAttemptsCounter = 0;
    LDAPCertStoreParameters savedLDAPCertStoreParameters = null;
    private boolean prefetchCRLs = false;
    private final MemoryCache valueCache;
    private static final Debug debug;
    private static final Cache certStoreCache;

    public LDAPCertStoreImpl(CertStoreParameters params) throws InvalidAlgorithmParameterException {
        super(params);
        if (!(params instanceof LDAPCertStoreParameters)) {
            throw new InvalidAlgorithmParameterException("parameters must be LDAPCertStoreParameters");
        }
        this.init((LDAPCertStoreParameters)params);
        this.valueCache = LIFETIME <= 0 ? new MemoryCache(3000, 0) : new MemoryCache(3000, LIFETIME);
    }

    public void init(LDAPCertStoreParameters params) throws InvalidAlgorithmParameterException {
        Properties env = new Properties();
        String myHost = null;
        String stringLDAP = new String("ldap://");
        int myPort = -1;
        this.savedLDAPCertStoreParameters = params;
        if (debug != null) {
            System.out.println("CERTPATH: LDAPCertStoreImpl.java:  init():  Saving the LDAPCertStoreParameters used to initialize.");
            System.out.println("                                            consecutiveFailedGetAttributeAttemptsCounter     = " + this.consecutiveFailedGetAttributeAttemptsCounter);
            System.out.println("                                            MAXIMUM_CONSECUTIVE_FAILED_GETATTRIBUTE_ATTEMPTS = 2");
        }
        try {
            env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            env.put("java.naming.factory.url.pkgs", "com.sun.jndi.ldap");
            if (!(params instanceof LDAPCertStoreParameters)) {
                throw new InvalidAlgorithmParameterException();
            }
            myHost = params.getServerName();
            myPort = params.getPort();
            if (myHost == null || myPort < 0) {
                throw new InvalidAlgorithmParameterException();
            }
            String stringHostPort = stringLDAP + myHost + ":" + myPort;
            env.put("java.naming.provider.url", stringHostPort);
            this.ctx = new InitialDirContext(env);
        }
        catch (NamingException ne) {
            InvalidAlgorithmParameterException iaex = new InvalidAlgorithmParameterException(ne.getMessage());
            iaex.initCause(ne);
            throw iaex;
        }
        catch (InvalidAlgorithmParameterException iape) {
            InvalidAlgorithmParameterException iaex = new InvalidAlgorithmParameterException(iape.getMessage());
            iaex.initCause(iape);
            throw iaex;
        }
    }

    private List<X509CertImpl> getCertificates(LDAPRequest request, String id, CertSelector sel) throws CertStoreException {
        byte[][] encodedCert;
        try {
            encodedCert = request.getValues(id);
        }
        catch (NamingException namingEx) {
            throw new CertStoreException(namingEx);
        }
        int n = encodedCert.length;
        if (n == 0) {
            return Collections.emptyList();
        }
        ArrayList<X509CertImpl> certs = new ArrayList<X509CertImpl>(n);
        for (int i = 0; i < n; ++i) {
            ByteArrayInputStream bais = new ByteArrayInputStream(encodedCert[i]);
            try {
                X509CertImpl cert = new X509CertImpl((InputStream)bais);
                if (!sel.match((Certificate)cert)) continue;
                if (debug != null) {
                    System.out.println("CERTPATH: found a matched cert");
                }
                certs.add(cert);
                continue;
            }
            catch (CertificateException e) {
                if (debug == null) continue;
                System.out.println("CERTPATH: receive bad cert data ");
                HexDumpEncoder encoder = new HexDumpEncoder();
                System.out.println("[ " + encoder.encodeBuffer(encodedCert[i]) + " ]");
            }
        }
        return certs;
    }

    private Collection<X509CertificatePair> getCertPairs(LDAPRequest request, String id) throws CertStoreException {
        byte[][] encodedCertPair;
        try {
            encodedCertPair = request.getValues(id);
        }
        catch (NamingException namingEx) {
            throw new CertStoreException(namingEx);
        }
        int n = encodedCertPair.length;
        if (n == 0) {
            return Collections.emptyList();
        }
        ArrayList<X509CertificatePair> certPairs = new ArrayList<X509CertificatePair>(n);
        for (int i = 0; i < n; ++i) {
            try {
                X509CertificatePair certPair = new X509CertificatePair(encodedCertPair[i]);
                certPairs.add(certPair);
                continue;
            }
            catch (CertificateException e) {
                if (debug == null) continue;
                System.out.println("CERTPATH: receive bad certificate pair data ");
                HexDumpEncoder encoder = new HexDumpEncoder();
                System.out.println("[ " + encoder.encodeBuffer(encodedCertPair[i]) + " ]");
            }
        }
        return certPairs;
    }

    private Collection<X509Certificate> getMatchingCrossCerts(LDAPRequest request, CertSelector forward, CertSelector reverse) throws CertStoreException {
        Collection<X509CertificatePair> certPairs = this.getCertPairs(request, CROSS_CERT);
        ArrayList<X509Certificate> matchingCerts = new ArrayList<X509Certificate>();
        for (X509CertificatePair certPair : certPairs) {
            X509Certificate cert;
            if (forward != null && (cert = certPair.getForward()) != null && forward.match(cert)) {
                matchingCerts.add(cert);
            }
            if (reverse == null || (cert = certPair.getReverse()) == null || !reverse.match(cert)) continue;
            matchingCerts.add(cert);
        }
        return matchingCerts;
    }

    public synchronized Collection<X509Certificate> engineGetCertificates(CertSelector selector) throws CertStoreException {
        LDAPRequest request;
        X509CertSelector xsel = null;
        if (selector == null) {
            xsel = new X509CertSelector();
        }
        if (!(selector instanceof X509CertSelector)) {
            throw new CertStoreException("LDAPCertStore needs an X509CertSelector to find certs");
        }
        xsel = (X509CertSelector)selector;
        HashSet<X509Certificate> certs = new HashSet<X509Certificate>();
        X500Principal subjectName = xsel.getSubject();
        X500Principal issuerName = xsel.getIssuer();
        String subject = null;
        if (subjectName != null) {
            subject = subjectName.getName("RFC1779");
            subject = this.removeOIDStringsFromDN(subject);
        }
        String issuer = null;
        if (issuerName != null) {
            issuer = issuerName.getName("RFC1779");
            issuer = this.removeOIDStringsFromDN(issuer);
        }
        int basicConst = xsel.getBasicConstraints();
        if (subject != null) {
            request = new LDAPRequest(subject);
            if (basicConst > -2) {
                request.addRequestedAttribute(CROSS_CERT);
                request.addRequestedAttribute(CROSS_CERT_BIN);
                request.addRequestedAttribute(CA_CERT);
                request.addRequestedAttribute(CA_CERT_BIN);
                request.addRequestedAttribute(ARL);
                request.addRequestedAttribute(ARL_BIN);
                if (this.prefetchCRLs) {
                    request.addRequestedAttribute(CRL);
                    request.addRequestedAttribute(CRL_BIN);
                }
            }
            if (basicConst < 0) {
                request.addRequestedAttribute(USER_CERT);
                request.addRequestedAttribute(USER_CERT_BIN);
            }
            if (basicConst > -2) {
                certs.addAll(this.getMatchingCrossCerts(request, xsel, null));
                certs.addAll(this.getCertificates(request, CA_CERT, xsel));
                certs.addAll(this.getCertificates(request, CA_CERT_BIN, xsel));
            }
            if (basicConst < 0) {
                certs.addAll(this.getCertificates(request, USER_CERT, xsel));
                certs.addAll(this.getCertificates(request, USER_CERT_BIN, xsel));
            }
        } else {
            if (debug != null) {
                System.out.println("CERTPATH: LDAP type certstore, subject is null");
            }
            if (basicConst == -2) {
                throw new CertStoreException("need subject to find EE certs");
            }
            if (issuer == null) {
                throw new CertStoreException("need subject or issuer to find certs");
            }
        }
        if (issuer != null && basicConst > -2) {
            request = new LDAPRequest(issuer);
            request.addRequestedAttribute(CROSS_CERT);
            request.addRequestedAttribute(CROSS_CERT_BIN);
            request.addRequestedAttribute(CA_CERT);
            request.addRequestedAttribute(CA_CERT_BIN);
            request.addRequestedAttribute(ARL);
            request.addRequestedAttribute(ARL_BIN);
            if (this.prefetchCRLs) {
                request.addRequestedAttribute(CRL);
                request.addRequestedAttribute(CRL_BIN);
            }
            certs.addAll(this.getMatchingCrossCerts(request, null, xsel));
            certs.addAll(this.getCertificates(request, CA_CERT, xsel));
            certs.addAll(this.getCertificates(request, CA_CERT_BIN, xsel));
        }
        if (debug != null) {
            System.out.println("CERTPATH: LDAP type certstore returning certs size=" + certs.size());
        }
        return certs;
    }

    private Collection<X509CRLImpl> getCRLs(LDAPRequest request, String id, CRLSelector sel) throws CertStoreException {
        byte[][] encodedCRL;
        try {
            encodedCRL = request.getValues(id);
        }
        catch (NamingException namingEx) {
            throw new CertStoreException(namingEx);
        }
        int n = encodedCRL.length;
        if (n == 0) {
            return Collections.emptyList();
        }
        ArrayList<X509CRLImpl> crls = new ArrayList<X509CRLImpl>(n);
        for (int i = 0; i < n; ++i) {
            try {
                X509CRLImpl crl = new X509CRLImpl((InputStream)new ByteArrayInputStream(encodedCRL[i]));
                if (!sel.match((CRL)crl)) continue;
                crls.add(crl);
                continue;
            }
            catch (CRLException e) {
                if (debug == null) continue;
                System.out.println("CERTPATH: receive bad CRL data ");
                HexDumpEncoder encoder = new HexDumpEncoder();
                System.out.println("[ " + encoder.encodeBuffer(encodedCRL[i]) + " ]");
            }
        }
        return crls;
    }

    public synchronized Collection<X509CRL> engineGetCRLs(CRLSelector selector) throws CertStoreException {
        if (debug != null) {
            System.out.println("CERTPATH: selector used to retrieve CRLs from LDAP CertStore: " + selector);
        }
        if (selector == null) {
            selector = new X509CRLSelector();
        }
        if (!(selector instanceof X509CRLSelector)) {
            throw new CertStoreException("need X509CRLSelector to find CRLs");
        }
        X509CRLSelector xsel = (X509CRLSelector)selector;
        HashSet<X509CRL> crls = new HashSet<X509CRL>();
        Collection<Object> issuerNames = new HashSet();
        X509Certificate certChecking = xsel.getCertificateChecking();
        if (certChecking != null) {
            if (certChecking instanceof X509CertImpl) {
                issuerNames.add(((X500Name)certChecking.getIssuerDN()).getName());
            } else {
                X500Principal issuer = certChecking.getIssuerX500Principal();
                issuerNames.add(issuer.getName("RFC2253"));
            }
        } else {
            issuerNames = xsel.getIssuerNames();
            if (issuerNames == null) {
                throw new CertStoreException("need issuerNames or certChecking to find CRLs");
            }
        }
        for (Object nameObject : issuerNames) {
            LDAPRequest request;
            boolean empty;
            String issuerName;
            block20: {
                block19: {
                    if (nameObject instanceof byte[]) {
                        try {
                            X500Name issuer = new X500Name((byte[])nameObject);
                            issuerName = issuer.getName();
                            break block19;
                        }
                        catch (IOException e) {
                            if (debug == null) continue;
                            System.out.println("CERTPATH: non fatal error happens while getting CRLs from LDAP CertStore " + e);
                            continue;
                        }
                    }
                    issuerName = (String)nameObject;
                }
                Collection<Object> entryCRLs = Collections.EMPTY_LIST;
                empty = true;
                if (certChecking == null || certChecking.getBasicConstraints() != -1) {
                    request = new LDAPRequest(issuerName);
                    request.addRequestedAttribute(CROSS_CERT);
                    request.addRequestedAttribute(CROSS_CERT_BIN);
                    request.addRequestedAttribute(CA_CERT);
                    request.addRequestedAttribute(CA_CERT_BIN);
                    request.addRequestedAttribute(ARL);
                    request.addRequestedAttribute(ARL_BIN);
                    if (this.prefetchCRLs) {
                        request.addRequestedAttribute(CRL);
                        request.addRequestedAttribute(CRL_BIN);
                    }
                    try {
                        entryCRLs = this.getCRLs(request, ARL, xsel);
                        if (!entryCRLs.isEmpty()) {
                            crls.addAll(entryCRLs);
                            empty = false;
                        }
                        if (!(entryCRLs = this.getCRLs(request, ARL_BIN, xsel)).isEmpty()) {
                            crls.addAll(entryCRLs);
                            empty = false;
                        }
                        if (empty) {
                            this.prefetchCRLs = true;
                        }
                    }
                    catch (CertStoreException e) {
                        if (debug == null) break block20;
                        System.out.println("CERTPATH: error getting CRLs from LDAP CertStore " + e);
                        e.printStackTrace();
                    }
                }
            }
            if (!empty && certChecking != null) continue;
            request = new LDAPRequest(issuerName);
            request.addRequestedAttribute(CRL);
            request.addRequestedAttribute(CRL_BIN);
            request.addRequestedAttribute(ARL);
            request.addRequestedAttribute(ARL_BIN);
            crls.addAll(this.getCRLs(request, CRL, xsel));
            crls.addAll(this.getCRLs(request, CRL_BIN, xsel));
        }
        return crls;
    }

    static LDAPCertStoreParameters getParameters(URI uri) {
        String host = uri.getHost();
        if (host == null) {
            return new IBMLDAPCertStoreParameters();
        }
        int port = uri.getPort();
        return port == -1 ? new IBMLDAPCertStoreParameters(host) : new IBMLDAPCertStoreParameters(host, port);
    }

    private String removeOIDStringsFromDN(String inputDN) {
        if (inputDN.length() == 0) {
            return inputDN;
        }
        while (inputDN.length() != 0 && inputDN.charAt(0) == ' ') {
            inputDN = inputDN.substring(1);
        }
        if (inputDN.length() == 0) {
            return inputDN;
        }
        if (inputDN.indexOf("OID.") == 0) {
            inputDN = inputDN.substring(4);
        }
        int indexOfNextOID = 0;
        while ((indexOfNextOID = inputDN.indexOf("OID.", indexOfNextOID + 1)) != -1) {
            int tempIndex = indexOfNextOID - 1;
            while (inputDN.charAt(tempIndex) == ' ') {
                --tempIndex;
            }
            if (inputDN.charAt(tempIndex) != ',') continue;
            StringBuffer myStringBuffer = new StringBuffer(inputDN);
            myStringBuffer.delete(indexOfNextOID, indexOfNextOID + 4);
            inputDN = new String(myStringBuffer);
        }
        return inputDN;
    }

    static synchronized CertStore getInstance(LDAPCertStoreParameters params) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        CertStore lcs = (CertStore)certStoreCache.get((Object)params);
        if (lcs == null) {
            lcs = CertStore.getInstance("LDAP", params);
            certStoreCache.put((Object)params, (Object)lcs);
        } else if (debug != null) {
            System.out.println("LDAPCertStore.getInstance: cache hit");
        }
        return lcs;
    }

    static LDAPCertStoreParameters getParameters(String hostName, int port) {
        if (hostName == null) {
            return new IBMLDAPCertStoreParameters();
        }
        if (port < 0) {
            return new IBMLDAPCertStoreParameters(hostName);
        }
        return new IBMLDAPCertStoreParameters(hostName, port);
    }

    static {
        String lifetime = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(LDAPCertStoreImpl.PROP_LIFETIME);
            }
        });
        if (lifetime != null) {
            try {
                LIFETIME = Integer.parseInt(lifetime);
            }
            catch (NumberFormatException ex) {
                LIFETIME = 600;
            }
        } else {
            LIFETIME = 600;
        }
        debug = Debug.getInstance((String)"certpath");
        certStoreCache = Cache.newSoftMemoryCache((int)185);
    }

    static class LDAPCRLSelector
    extends X509CRLSelector {
        private X509CRLSelector selector;
        private Collection<X500Principal> certIssuers;
        private Collection<X500Principal> issuers;
        private HashSet<Object> issuerNames;

        LDAPCRLSelector(X509CRLSelector selector, Collection<X500Principal> certIssuers, String ldapDN) throws IOException {
            this.selector = selector == null ? new X509CRLSelector() : selector;
            this.certIssuers = certIssuers;
            this.issuerNames = new HashSet();
            this.issuerNames.add(ldapDN);
            this.issuers = new HashSet<X500Principal>();
            this.issuers.add(new X500Principal(ldapDN));
        }

        @Override
        public Collection<X500Principal> getIssuers() {
            return Collections.unmodifiableCollection(this.issuers);
        }

        @Override
        public Collection<Object> getIssuerNames() {
            return Collections.unmodifiableCollection(this.issuerNames);
        }

        @Override
        public BigInteger getMinCRL() {
            return this.selector.getMinCRL();
        }

        @Override
        public BigInteger getMaxCRL() {
            return this.selector.getMaxCRL();
        }

        @Override
        public Date getDateAndTime() {
            return this.selector.getDateAndTime();
        }

        @Override
        public X509Certificate getCertificateChecking() {
            return this.selector.getCertificateChecking();
        }

        @Override
        public boolean match(CRL crl) {
            this.selector.setIssuers(this.certIssuers);
            boolean match = this.selector.match(crl);
            this.selector.setIssuers(this.issuers);
            return match;
        }
    }

    static class LDAPCertSelector
    extends X509CertSelector {
        private X500Principal certSubject;
        private X509CertSelector selector;
        private X500Principal subject;

        LDAPCertSelector(X509CertSelector selector, X500Principal certSubject, String ldapDN) throws IOException {
            this.selector = selector == null ? new X509CertSelector() : selector;
            this.certSubject = certSubject;
            this.subject = new X500Principal(ldapDN);
        }

        @Override
        public X509Certificate getCertificate() {
            return this.selector.getCertificate();
        }

        @Override
        public BigInteger getSerialNumber() {
            return this.selector.getSerialNumber();
        }

        @Override
        public X500Principal getIssuer() {
            return this.selector.getIssuer();
        }

        @Override
        public String getIssuerAsString() {
            return this.selector.getIssuerAsString();
        }

        @Override
        public byte[] getIssuerAsBytes() throws IOException {
            return this.selector.getIssuerAsBytes();
        }

        @Override
        public X500Principal getSubject() {
            return this.subject;
        }

        @Override
        public String getSubjectAsString() {
            return this.subject.getName();
        }

        @Override
        public byte[] getSubjectAsBytes() throws IOException {
            return this.subject.getEncoded();
        }

        @Override
        public byte[] getSubjectKeyIdentifier() {
            return this.selector.getSubjectKeyIdentifier();
        }

        @Override
        public byte[] getAuthorityKeyIdentifier() {
            return this.selector.getAuthorityKeyIdentifier();
        }

        @Override
        public Date getCertificateValid() {
            return this.selector.getCertificateValid();
        }

        @Override
        public Date getPrivateKeyValid() {
            return this.selector.getPrivateKeyValid();
        }

        @Override
        public String getSubjectPublicKeyAlgID() {
            return this.selector.getSubjectPublicKeyAlgID();
        }

        @Override
        public PublicKey getSubjectPublicKey() {
            return this.selector.getSubjectPublicKey();
        }

        @Override
        public boolean[] getKeyUsage() {
            return this.selector.getKeyUsage();
        }

        @Override
        public Set<String> getExtendedKeyUsage() {
            return this.selector.getExtendedKeyUsage();
        }

        @Override
        public boolean getMatchAllSubjectAltNames() {
            return this.selector.getMatchAllSubjectAltNames();
        }

        @Override
        public Collection<List<?>> getSubjectAlternativeNames() {
            return this.selector.getSubjectAlternativeNames();
        }

        @Override
        public byte[] getNameConstraints() {
            return this.selector.getNameConstraints();
        }

        @Override
        public int getBasicConstraints() {
            return this.selector.getBasicConstraints();
        }

        @Override
        public Set<String> getPolicy() {
            return this.selector.getPolicy();
        }

        @Override
        public Collection<List<?>> getPathToNames() {
            return this.selector.getPathToNames();
        }

        @Override
        public boolean match(Certificate cert) {
            this.selector.setSubject(this.certSubject);
            boolean match = this.selector.match(cert);
            this.selector.setSubject(this.subject);
            return match;
        }
    }

    static class IBMLDAPCertStoreParameters
    extends LDAPCertStoreParameters {
        private volatile int hashCode = 0;

        IBMLDAPCertStoreParameters(String serverName, int port) {
            super(serverName, port);
        }

        IBMLDAPCertStoreParameters(String serverName) {
            super(serverName);
        }

        IBMLDAPCertStoreParameters() {
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof LDAPCertStoreParameters)) {
                return false;
            }
            LDAPCertStoreParameters params = (LDAPCertStoreParameters)obj;
            return this.getPort() == params.getPort() && this.getServerName().equalsIgnoreCase(params.getServerName());
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                int result = 17;
                result = 37 * result + this.getPort();
                this.hashCode = result = 37 * result + this.getServerName().toLowerCase().hashCode();
            }
            return this.hashCode;
        }
    }

    private class LDAPRequest {
        private final String name;
        private Map<String, byte[][]> valueMap;
        private final List<String> requestedAttributes;
        private Attributes attrs;

        LDAPRequest(String name) {
            this.name = name;
            this.requestedAttributes = new ArrayList<String>(5);
        }

        String getName() {
            return this.name;
        }

        void addRequestedAttribute(String attrId) {
            if (this.valueMap != null) {
                throw new IllegalStateException("Request already sent");
            }
            this.requestedAttributes.add(attrId);
        }

        byte[][] getValues(String attrId) throws NamingException {
            String key = this.name + attrId;
            Object values = null;
            if (debug != null) {
                System.out.println("CERTPATH:  LDAPRequest:  getValues():  METHOD ENTRY. ");
                System.out.println("CERTPATH:  LDAPRequest:  getValues():  The LDAP object associated with this LDAPRequest is:  " + this.name);
                System.out.println("                                       Seeking the value of the following attribute:         " + attrId);
            }
            if ((values = (byte[][])LDAPCertStoreImpl.this.valueCache.get(key)) != null) {
                if (debug != null) {
                    System.out.println("CERTPATH:  LDAPRequest:  getValues():  Returning the value found for the requested attribute within the LDAPCertStore cache, key=" + key);
                    System.out.println("CERTPATH:  LDAPRequest:  getValues():  METHOD EXIT. ");
                }
                return values;
            }
            if (this.valueMap != null) {
                values = this.valueMap.get(attrId);
            } else {
                this.valueMap = new HashMap<String, byte[][]>(5);
            }
            if (values != null) {
                if (debug != null) {
                    System.out.println("CERTPATH:  LDAPRequest:  getValues():  Returning the value found for the requested attribute within the LDAPRequest cache, key=" + attrId);
                    System.out.println("CERTPATH:  LDAPRequest:  getValues():  METHOD EXIT. ");
                }
                return values;
            }
            if (debug != null) {
                System.out.println("CERTPATH:  LDAPRequest:  getValues():  The requested attribute was not located within either cache.");
                System.out.println("                                       Issuing request to LDAP server to locate the object:  " + this.name);
                System.out.println("                                       All attributes within the list of requestedAttributes will also be requested.");
            }
            if (debug != null) {
                System.out.println("CERTPATH:  LDAPRequest:  getValues():  The list of requestedAttributes is:");
            }
            Boolean foundIt = false;
            for (String id : this.requestedAttributes) {
                if (attrId.equals(id)) {
                    foundIt = true;
                }
                if (debug == null) continue;
                System.out.println(id);
            }
            if (!foundIt.booleanValue() && debug != null) {
                System.out.println("CERTPATH:  LDAPRequest:  getValues():  ERROR.  Caller failed to add attrId to the list of requestedAttributes.");
            }
            if (this.attrs == null) {
                String[] attrIds = new String[this.requestedAttributes.size()];
                this.requestedAttributes.toArray(attrIds);
                boolean communicationExceptionOccurred = true;
                while (communicationExceptionOccurred) {
                    if (debug != null) {
                        System.out.println("CERTPATH: LDAPCertStoreImpl.java:  getValues():  Entering getAttributes() retry loop");
                    }
                    try {
                        LdapName ldapName = new LdapName(this.name);
                        this.attrs = LDAPCertStoreImpl.this.ctx.getAttributes(ldapName, attrIds);
                        communicationExceptionOccurred = false;
                        LDAPCertStoreImpl.this.consecutiveFailedGetAttributeAttemptsCounter = 0;
                        if (debug == null) continue;
                        System.out.println("CERTPATH: LDAPCertStoreImpl.java:  getValues():  The getAttributes() call succeeded.");
                        System.out.println("                                                 Setting consecutiveFailedGetAttributeAttemptsCounter = 0");
                        System.out.println("                                                 Setting communicationExceptionOccurred = false");
                    }
                    catch (CommunicationException commEx) {
                        if (debug != null) {
                            System.out.println("CERTPATH: LDAPCertStoreImpl.java:  getValues():  The getAttributes() call failed with the following CommunicationException.");
                            System.out.println("          This may be due to the LDAP server dropping the connection due to inactivity.");
                            System.out.println(commEx.toString());
                            commEx.printStackTrace();
                        }
                        communicationExceptionOccurred = true;
                        LDAPCertStoreImpl.this.consecutiveFailedGetAttributeAttemptsCounter++;
                        if (debug != null) {
                            System.out.println("CERTPATH: LDAPCertStoreImpl.java:  getValues():  Setting consecutiveFailedGetAttributeAttemptsCounter = " + LDAPCertStoreImpl.this.consecutiveFailedGetAttributeAttemptsCounter);
                            System.out.println("CERTPATH: LDAPCertStoreImpl.java:  getValues():  Setting communicationExceptionOccurred = true");
                        }
                        if (LDAPCertStoreImpl.this.consecutiveFailedGetAttributeAttemptsCounter < 2) {
                            if (debug != null) {
                                System.out.println("CERTPATH: LDAPCertStoreImpl.java:  getValues():  We have not yet exceeded the MAXIMUM_CONSECUTIVE_FAILED_GETATTRIBUTE_ATTEMPTS ");
                            }
                            try {
                                if (debug != null) {
                                    System.out.println("CERTPATH: LDAPCertStoreImpl.java:  getValues():  Attempting to re-initialize this LDAPCertStore object (and the DirContext).");
                                }
                                LDAPCertStoreImpl.this.init(LDAPCertStoreImpl.this.savedLDAPCertStoreParameters);
                                if (debug == null) continue;
                                System.out.println("CERTPATH: LDAPCertStoreImpl.java:  getValues():  Re-initialization succeeded following the CommunicationException");
                            }
                            catch (Exception unexpectedException) {
                                if (debug == null) continue;
                                System.out.println("CERTPATH: LDAPCertStoreImpl.java:  getValues():  Re-initialization failed.  The following exception was thrown:");
                                System.out.println(unexpectedException.toString());
                                unexpectedException.printStackTrace();
                            }
                            continue;
                        }
                        if (debug != null) {
                            System.out.println("CERTPATH: LDAPCertStoreImpl.java:  getValues():  We have exceeded the MAXIMUM_CONSECUTIVE_FAILED_GETATTRIBUTE_ATTEMPTS!!");
                            System.out.println("                                                 Giving up and returning null attributes (same as original implementation)");
                        }
                        this.attrs = null;
                        return EMPTY_VALUES;
                    }
                    catch (NamingException nex) {
                        if (debug != null) {
                            System.out.println("CERTPATH:  LDAPRequest:  getValues():  The LDAP server request failed with a NamingException.");
                            System.out.println("CERTPATH:  LDAPRequest:  getValues():  Returning an empty value for the requested attribute: " + attrId);
                            System.out.println("CERTPATH:  LDAPRequest:  getValues():  METHOD EXIT. ");
                            nex.printStackTrace();
                        }
                        this.attrs = null;
                        return EMPTY_VALUES;
                    }
                }
                if (debug != null) {
                    System.out.println("CERTPATH: LDAPCertStoreImpl.java:  getValues():  Exiting getAttributes() retry loop");
                }
            }
            for (String id : this.requestedAttributes) {
                Attribute attr = this.attrs.get(id);
                if (attr != null) {
                    if (debug != null) {
                        System.out.println("CERTPATH:  LDAPRequest:  getValues():  Successfully retrieved one of the requestedAttribute's with id " + id);
                        System.out.println("                                       That attribute is: ");
                        System.out.println(attr.toString());
                    }
                    byte[][] temp = new byte[attr.size()][];
                    for (int j = 0; j < attr.size(); ++j) {
                        Object obj = attr.get(j);
                        if (obj instanceof byte[]) {
                            temp[j] = (byte[])obj;
                            if (debug == null) continue;
                            System.out.println("CERTPATH:  LDAPRequest:  getValues():  The retrieved requestedAttribute with id " + id + " has at least one value");
                            continue;
                        }
                        if (debug == null) continue;
                        System.out.println("CERTPATH:  LDAPRequest:  getValues():  The retrieved requestedAttribute with id " + id + " has a non byte[] value");
                    }
                    this.valueMap.put(id, temp);
                    LDAPCertStoreImpl.this.valueCache.put(this.name + id, temp);
                    if (debug != null) {
                        System.out.println("CERTPATH:  LDAPRequest:  getValues():  Store the retrieved requestedAttribute value into both caches.");
                        System.out.println("                                       Into the LDAPCertStore cache using the key:  " + this.name + id);
                        System.out.println("                                       Into the LDAPRequest   cache using the key:  " + id);
                    }
                    if (!id.equals(attrId)) continue;
                    if (debug != null) {
                        System.out.println("CERTPATH:  LDAPRequest:  getValues():  Returning the value found for the requested attribute on the LDAP server.  attrId = " + attrId);
                    }
                    values = temp;
                    continue;
                }
                this.valueMap.put(id, EMPTY_VALUES);
                LDAPCertStoreImpl.this.valueCache.put(this.name + id, EMPTY_VALUES);
                if (debug == null) continue;
                System.out.println("CERTPATH:  LDAPRequest:  getValues():  Store an empty attribute value into both caches for the non-found attribute.");
                System.out.println("                                       Into the LDAPCertStore cache using the key:  " + this.name + id);
                System.out.println("                                       Into the LDAPRequest   cache using the key:  " + id);
            }
            if (values == null) {
                if (debug != null) {
                    System.out.println("CERTPATH:  LDAPRequest:  getValues():  Returning an empty value for the requested attribute: " + attrId);
                    System.out.println("CERTPATH:  LDAPRequest:  getValues():  METHOD EXIT");
                }
                return EMPTY_VALUES;
            }
            if (debug != null) {
                System.out.println("CERTPATH:  LDAPRequest:  getValues():  METHOD EXIT");
            }
            return values;
        }
    }
}

