/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.licensing.policy.ui.viewers;

import com.ibm.cic.licensing.common.util.LicensePolicyData;
import com.ibm.cic.licensing.common.util.ProductInformation;
import com.ibm.cic.licensing.policy.ui.Messages;
import com.ibm.cic.licensing.policy.ui.dialogs.FlexServerDialog;
import com.ibm.cic.licensing.policy.ui.dialogs.TableItemEditDialog;
import com.ibm.cic.licensing.policy.ui.viewers.EditableTableViewer;
import com.ibm.cic.licensing.policy.ui.viewers.LicensePolicyViewer;
import java.util.StringTokenizer;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class FlexViewer
extends LicensePolicyViewer {
    private Button enableFlexButton;
    private Button disableFlexButton;
    private ProductInformation pi;

    public FlexViewer(Composite parent, EditableTableViewer.IFormAdapter formAdapter) {
        super(parent, formAdapter);
    }

    public FlexViewer(Composite parent) {
        this(parent, null);
    }

    public void setInput(Object input) {
        super.setInput(input);
        LicensePolicyData.FlexData flexData = this.getFlexData();
        boolean enabled = flexData.isEnabled();
        this.enableFlexButton.setSelection(enabled);
        this.disableFlexButton.setSelection(!enabled);
        boolean readonly = flexData.isReadonly();
        if (!readonly) {
            this.setEnabled(enabled);
        }
        if (this.formAdapter.isPreferencePage()) {
            this.enableFlexButton.setEnabled(!readonly);
            this.disableFlexButton.setEnabled(!readonly);
        }
    }

    public void refresh() {
        super.refresh();
        LicensePolicyData.FlexData flexData = this.getFlexData();
        boolean enabled = flexData.isEnabled();
        this.enableFlexButton.setSelection(enabled);
        this.disableFlexButton.setSelection(!enabled);
        if (!flexData.isReadonly()) {
            this.setEnabled(enabled);
        }
    }

    protected Control createControl(Composite parent) {
        Composite outerContainer = (Composite)super.createControl(parent);
        this.setReadonlyCheckButtonText(Messages.flexReadonlyCheckButtonText);
        Composite buttonComp = new Composite(outerContainer, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 5;
        layout.numColumns = 2;
        buttonComp.setLayout((Layout)layout);
        buttonComp.setFont(parent.getFont());
        buttonComp.setBackground(parent.getBackground());
        this.enableFlexButton = new Button(buttonComp, 0x10 | this.formAdapter.getButtonStyle());
        this.enableFlexButton.setText(Messages.flexEnabledCheckButtonText);
        this.enableFlexButton.setFont(parent.getFont());
        this.enableFlexButton.setBackground(parent.getBackground());
        this.disableFlexButton = new Button(buttonComp, 0x10 | this.formAdapter.getButtonStyle());
        this.disableFlexButton.setText(Messages.flexDisableButtonText);
        this.disableFlexButton.setFont(parent.getFont());
        this.disableFlexButton.setBackground(parent.getBackground());
        this.createTable(outerContainer);
        this.enableFlexButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = FlexViewer.this.enableFlexButton.getSelection();
                FlexViewer.this.disableFlexButton.setSelection(!enabled);
                FlexViewer.this.getFlexData().setEnabled(enabled);
                FlexViewer.this.setEnabled(enabled);
            }
        });
        return outerContainer;
    }

    public Object getValue(Object element, String property) {
        LicensePolicyData.ServerData server = (LicensePolicyData.ServerData)element;
        if (property.equals(Messages.flexServerNameColumnTitleText)) {
            return server.getName();
        }
        if (property.equals(Messages.flexServerPortColumnTitleText)) {
            return server.getPort();
        }
        return null;
    }

    public void modify(Object element, String property, Object value) {
        TableItem item = (TableItem)element;
        LicensePolicyData.ServerData server = (LicensePolicyData.ServerData)item.getData();
        if (property.equals(Messages.flexServerNameColumnTitleText)) {
            String serverName = (String)value;
            if (serverName == null || serverName.length() == 0) {
                MessageDialog.openError((Shell)item.getParent().getShell(), (String)Messages.serverNameErrorDlgTitle, (String)Messages.serverNameEmptyErrorDlgMsg);
            } else if (!this.isValidServerName(serverName)) {
                MessageDialog.openError((Shell)item.getParent().getShell(), (String)Messages.serverNameErrorDlgTitle, (String)Messages.serverNameFormatErrorDlgMsg);
            } else if (serverName.indexOf(",") != -1) {
                if (!this.isValidRedundantPortNumber(server.getPort())) {
                    MessageDialog.openError((Shell)item.getParent().getShell(), (String)Messages.portNumberErrorDlgTitle, (String)Messages.portNumberFormatErrorDlgMsg);
                } else {
                    server.setName(serverName);
                }
            } else {
                server.setName(serverName);
            }
        } else if (property.equals(Messages.flexServerPortColumnTitleText)) {
            if (server.isCluster() && !this.isValidRedundantPortNumber((String)value)) {
                MessageDialog.openError((Shell)item.getParent().getShell(), (String)Messages.portNumberErrorDlgTitle, (String)Messages.portNumberFormatErrorDlgMsg);
            }
            server.setPort((String)value);
        }
        this.tableViewer.update((Object)server, null);
    }

    /*
     * Unable to fully structure code
     */
    private boolean isValidServerName(String serverName) {
        if (serverName.indexOf(",") == -1) {
            return true;
        }
        tokenizer = new StringTokenizer(serverName, ",");
        if (tokenizer.countTokens() == 3) ** GOTO lbl9
        return false;
lbl-1000:
        // 1 sources

        {
            token = tokenizer.nextToken();
            if (token.trim().length() != 0) continue;
            return false;
lbl9:
            // 2 sources

            ** while (tokenizer.hasMoreTokens())
        }
lbl10:
        // 1 sources

        return true;
    }

    /*
     * Unable to fully structure code
     */
    private boolean isValidRedundantPortNumber(String portNumber) {
        tokenizer = new StringTokenizer(portNumber, ",");
        if (tokenizer.countTokens() == 3) ** GOTO lbl7
        return false;
lbl-1000:
        // 1 sources

        {
            token = tokenizer.nextToken();
            if (token.trim().length() != 0) continue;
            return false;
lbl7:
            // 2 sources

            ** while (tokenizer.hasMoreTokens())
        }
lbl8:
        // 1 sources

        return true;
    }

    protected void handleAdd() {
        Table table = this.tableViewer.getTable();
        FlexServerDialog d = new FlexServerDialog(this.getControl().getShell(), Messages.newFlexServer, null, this.pi);
        int status = d.open();
        if (status != 0) {
            return;
        }
        String[] itemValues = d.getItemValues();
        Object newData = this.createNewData(itemValues);
        if (newData != null) {
            this.tableViewer.add(newData);
            this.tableViewer.setSelection((ISelection)new StructuredSelection(newData), true);
            table.notifyListeners(13, null);
        }
    }

    protected void handleEdit() {
        Table table = this.tableViewer.getTable();
        TableItem[] items = table.getSelection();
        if (items.length != 1) {
            return;
        }
        TableItem item = items[0];
        FlexServerDialog d = new FlexServerDialog(this.getControl().getShell(), Messages.editFlexServer, this.getText(table, item), this.pi);
        int status = d.open();
        if (status != 0) {
            return;
        }
        String[] itemValues = d.getItemValues();
        Object itemData = item.getData();
        this.setDataValues(itemData, itemValues);
        this.tableViewer.update(itemData, null);
    }

    protected Object createNewData(String[] values) {
        LicensePolicyData.ServerData serverData = new LicensePolicyData.ServerData(values[0], values[1]);
        this.getFlexData().addServer(serverData);
        return serverData;
    }

    protected void setDataValues(Object data, String[] values) {
        LicensePolicyData.ServerData server = (LicensePolicyData.ServerData)data;
        server.setName(values[0]);
        server.setPort(values[1]);
    }

    private LicensePolicyData.FlexData getFlexData() {
        return (LicensePolicyData.FlexData)this.data;
    }

    private void createTable(Composite parent) {
        this.createTable(parent, Messages.flexServersLabelText, 4);
        final Table table = this.tableViewer.getTable();
        TableColumn nameColumn = new TableColumn(table, 0);
        nameColumn.setWidth(150);
        nameColumn.setText(Messages.flexServerNameColumnTitleText);
        TableColumn portColumn = new TableColumn(table, 16384);
        portColumn.setWidth(this.fontMetrics.getAverageCharWidth() * Math.max(2 * Messages.flexServerPortColumnTitleText.length(), 30));
        portColumn.setText(Messages.flexServerPortColumnTitleText);
        TableColumn typeColumn = new TableColumn(table, 131072);
        int maxChars = Math.max(Messages.flexSingleServer.length(), Messages.flexRedundantServer.length());
        maxChars = Math.max(maxChars, Messages.flexServerTypeColumn.length());
        typeColumn.setWidth(this.fontMetrics.getAverageCharWidth() * Math.max(2 * maxChars, 10));
        typeColumn.setText(Messages.flexServerTypeColumn);
        this.initializeCellEditors();
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new EditableTableViewer.AbstractTableLabelProvider(){

            public String getColumnText(Object element, int columnIndex) {
                if (element instanceof LicensePolicyData.ServerData) {
                    LicensePolicyData.ServerData serverData = (LicensePolicyData.ServerData)element;
                    switch (columnIndex) {
                        case 0: {
                            return serverData.getName();
                        }
                        case 1: {
                            return serverData.getPort();
                        }
                        case 2: {
                            if (serverData.isCluster()) {
                                return Messages.flexRedundantServer;
                            }
                            return Messages.flexSingleServer;
                        }
                    }
                }
                return null;
            }
        });
        table.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                int tableWidth = table.getClientArea().width;
                TableColumn nameCol = table.getColumn(0);
                TableColumn portCol = table.getColumn(1);
                TableColumn typeCol = table.getColumn(2);
                nameCol.setWidth(tableWidth - portCol.getWidth() - typeCol.getWidth());
            }
        });
    }

    protected void initializeCellEditors() {
        Table table = this.tableViewer.getTable();
        TableColumn[] columns = table.getColumns();
        String[] props = new String[columns.length - 1];
        CellEditor[] cellEditors = new CellEditor[columns.length - 1];
        int i = 0;
        while (i < columns.length - 1) {
            TableColumn column = columns[i];
            props[i] = column.getText();
            Object columnData = column.getData();
            cellEditors[i] = columnData != null ? (CellEditor)columnData : new TextCellEditor((Composite)table);
            ++i;
        }
        this.tableViewer.setCellEditors(cellEditors);
        this.tableViewer.setColumnProperties(props);
        this.tableViewer.setCellModifier((ICellModifier)this);
    }

    public ProductInformation getPi() {
        return this.pi;
    }

    public void setPi(ProductInformation pi) {
        this.pi = pi;
    }

    protected TableItemEditDialog createEditDialog(String[] initialValues) {
        return null;
    }

    protected TableItemEditDialog createNewDialog() {
        return null;
    }

    public TableViewer getTableViewer() {
        return this.tableViewer;
    }
}

