/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.adapters.pakAdapter;

import com.ibm.cic.agent.core.IInstallAdaptor;
import com.ibm.cic.agent.core.InstallContext;
import com.ibm.cic.agent.core.InstallTransaction;
import com.ibm.cic.agent.core.commonNativeInstallAdapter.ICommonNativeInstallAdapter;
import com.ibm.cic.agent.core.commonNativeInstallAdapter.Util;
import com.ibm.cic.agent.internal.adapters.pakAdapter.PakInstallOperation;
import com.ibm.cic.common.commonNativeAdapterData.ICommonNativeData;
import com.ibm.cic.common.commonNativeAdapterData.PerformCommonNativeData;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.InstallableUnitPair;
import com.ibm.cic.common.logging.Logger;
import com.ibm.cic.common.pakAdapterData.PakCommonAdapterData;
import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;

public class PakInstallAdapter
extends ICommonNativeInstallAdapter
implements IInstallAdaptor {
    public static final String ID = "pak";
    private final Logger log = Logger.getLogger(PakInstallAdapter.class);

    protected Logger getLog() {
        return this.log;
    }

    public String getId() {
        return ID;
    }

    public IStatus install(InstallableUnitPair pair, InstallContext context, IProgressMonitor monitor) {
        return this.perform(21, 51, pair, context, monitor);
    }

    public IStatus postInstallConfigure(InstallableUnitPair pair, InstallContext context, IProgressMonitor monitor) {
        return this.perform(30, 60, pair, context, monitor);
    }

    public IStatus preInstallConfigure(InstallableUnitPair pair, InstallContext context, IProgressMonitor monitor) {
        return this.perform(10, 40, pair, context, monitor);
    }

    protected void dispatcher(int phase, IInstallableUnit unit, InstallContext context, ICommonNativeData data, IProgressMonitor monitor) throws CoreException {
        this.processCommonOperation(phase, unit, context, data, monitor);
    }

    protected void customOperation(int phase, IInstallableUnit unit, InstallContext context, ICommonNativeData data, PerformCommonNativeData performData, IProgressMonitor monitor) throws CoreException {
        this.processPakPerformOperation(phase, unit, context, data, performData, monitor);
    }

    private boolean processPakPerformOperation(int phase, IInstallableUnit unit, InstallContext context, ICommonNativeData data, PerformCommonNativeData performData, IProgressMonitor monitor) throws CoreException {
        boolean processed = true;
        ICommonNativeInstallAdapter.SupplementaryLogWriter writer = ICommonNativeInstallAdapter.SupplementaryLogWriter.create();
        try {
            PakInstallOperation op = null;
            if (data instanceof PakCommonAdapterData) {
                op = new PakInstallOperation(phase, unit, context, (PakCommonAdapterData)data, performData, writer);
            }
            if (op != null) {
                IStatus status = op.perform(InstallTransaction.NULL, monitor);
                if (!status.isOK()) {
                    throw new CoreException(status);
                }
            } else {
                processed = false;
            }
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    throw Util.coreException((Throwable)e, null, (Object[])new Object[0]);
                }
            }
        }
        return processed;
    }
}

