/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.commonNativeAdapterData;

import com.ibm.cic.common.commonNativeAdapterData.AgentLocationCommonNativeData;
import com.ibm.cic.common.commonNativeAdapterData.ArgCommonNativeData;
import com.ibm.cic.common.commonNativeAdapterData.ChmodCommonNativeData;
import com.ibm.cic.common.commonNativeAdapterData.CommonNativeAdapterUtils;
import com.ibm.cic.common.commonNativeAdapterData.CreateFileNativeData;
import com.ibm.cic.common.commonNativeAdapterData.CreateSymLinkCommonNativeData;
import com.ibm.cic.common.commonNativeAdapterData.DuringPhases;
import com.ibm.cic.common.commonNativeAdapterData.ExecCommonNativeData;
import com.ibm.cic.common.commonNativeAdapterData.FileCommonNativeData;
import com.ibm.cic.common.commonNativeAdapterData.ICommonNativeData;
import com.ibm.cic.common.commonNativeAdapterData.IDuringPhasesCommonNativeData;
import com.ibm.cic.common.commonNativeAdapterData.IXMLConstants;
import com.ibm.cic.common.commonNativeAdapterData.InvokeCommonNativeData;
import com.ibm.cic.common.commonNativeAdapterData.LineNativeData;
import com.ibm.cic.common.commonNativeAdapterData.LogCommonNativeData;
import com.ibm.cic.common.commonNativeAdapterData.MsgCommonNativeData;
import com.ibm.cic.common.commonNativeAdapterData.NativeAdapterData;
import com.ibm.cic.common.commonNativeAdapterData.NativeFileArtifactCommonNativeData;
import com.ibm.cic.common.commonNativeAdapterData.PerformCommonNativeData;
import com.ibm.cic.common.commonNativeAdapterData.RebootCommonNativeData;
import com.ibm.cic.common.commonNativeAdapterData.SizeInfoCommonNativeData;
import com.ibm.cic.common.commonNativeAdapterData.SymLinkCommonNativeData;
import com.ibm.cic.common.commonNativeAdapterData.ZipCommonNativeData;
import com.ibm.cic.common.commonNativeAdapterData.fileUtils.CopyCommonNativeData;
import com.ibm.cic.common.commonNativeAdapterData.fileUtils.DeleteCommonNativeData;
import com.ibm.cic.common.commonNativeAdapterData.fileUtils.MkdirCommonNativeData;
import com.ibm.cic.common.commonNativeAdapterData.fileUtils.MoveCommonNativeData;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.SimpleIdentity;
import com.ibm.cic.common.core.model.adapterdata.ArtifactCommonAttributes;
import com.ibm.cic.common.core.model.adapterdata.IAdapterDataParser;
import com.ibm.cic.common.core.model.adapterdata.IArtifact;
import com.ibm.cic.common.core.model.adapterdata.IErrorReporter;
import com.ibm.cic.common.core.model.adapterdata.IInstallSizeInfo;
import com.ibm.cic.common.core.model.adapterdata.SizeInfoParserHelper;
import com.ibm.cic.common.core.model.utils.InstallableUnitUtil;
import com.ibm.cic.common.core.utils.XMLUtil;
import java.util.Stack;
import org.osgi.framework.Version;
import org.xml.sax.Attributes;

public abstract class ICommonNativeAdapterDataParser
implements IAdapterDataParser,
IXMLConstants {
    private IInstallableUnit iu;
    private NativeAdapterData nativeData;
    private IErrorReporter reporter;
    private SizeInfoParserHelper commonParser;
    private ElemStack elemStack;
    private int performIndex;

    public void initialize(IInstallableUnit iu_local, NativeAdapterData nativeData_local, ElemStack elemStack_local, IErrorReporter errorReporter) {
        this.iu = iu_local;
        this.nativeData = nativeData_local;
        this.reporter = errorReporter;
        this.commonParser = new SizeInfoParserHelper(this.reporter);
        this.elemStack = elemStack_local;
        this.performIndex = 0;
    }

    protected boolean processCommonElement(String name, Attributes attributes) {
        boolean processed = true;
        if (name.equals("perform")) {
            this.handlePerformAttributes(attributes);
        } else if (name.equals("exec")) {
            this.handleExecAttributes(attributes);
        } else if (name.equals("invoke")) {
            this.handleInvokeAttributes(attributes);
        } else if (name.equals("arg") && (this.isExecSubElement() || this.isInvokeSubElement())) {
            this.handleExecArgAttributes(attributes);
        } else if (name.equals("log")) {
            this.handleLogAttributes(attributes);
        } else if (name.equals("message") && this.isLogSubElement()) {
            this.handleLogMsgAttributes(attributes);
        } else if (name.equals("chmod")) {
            this.handleChmodAttributes(attributes);
        } else if (name.equals("file") && this.isChmodSubElement()) {
            this.handleChmodFileAttributes(attributes);
        } else if (name.equals("createFile")) {
            this.handleCreateFileAttributes(attributes);
        } else if (name.equals("line") && this.isCreateFileSubElement()) {
            this.handleCreateFileLineAttributes(attributes);
        } else if (name.equals("createSymLink")) {
            this.handleCreateSymLink(attributes);
        } else if (name.equals("symLink")) {
            this.handleSymLink(attributes);
        } else if (name.equals("reboot")) {
            this.handleReboot(attributes);
        } else if (name.equals("mkdir")) {
            this.handleMkdirAttributes(attributes);
        } else if (name.equals("delete")) {
            this.handleDeleteAttributes(attributes);
        } else if (name.equals("copy")) {
            this.handleCopyAttributes(attributes);
        } else if (name.equals("move")) {
            this.handleMoveAttributes(attributes);
        } else if (name.equals("agent-location")) {
            this.handleAgentPropertyAttributes(attributes);
        } else if (name.equals("sizeInfo")) {
            IInstallSizeInfo installSizeInfo = this.commonParser.parseSizeInfoElement(name, name, attributes);
            if (installSizeInfo != null) {
                this.addSizeInfo(installSizeInfo);
            }
        } else {
            processed = false;
        }
        if (processed && this.isPerformSubElement()) {
            ElemStackEntry entry = this.elemStack.top();
            if (entry.data != null) {
                entry.data.setLineNumber(this.reporter.getLastCharactersLineNumber());
            }
        }
        return processed;
    }

    public void characters(String chars) {
        String name = this.elemStack.top().name;
        boolean processed = this.processCommonCharacters(name, chars);
        if (!processed) {
            this.reporter.unexpectedCharacterData(chars);
        }
    }

    protected boolean processCommonCharacters(String name, String chars) {
        boolean processed = true;
        if (name.equals("arg") && (this.isExecSubElement() || this.isInvokeSubElement())) {
            this.handleExecArgText(chars);
        } else if (name.equals("file") && this.isChmodSubElement()) {
            this.handleChmodFileText(chars);
        } else if (name.equals("message") && this.isLogSubElement()) {
            this.handleLogMsgText(chars);
        } else if (name.equals("line") && this.isCreateFileSubElement()) {
            this.handleCreateFileLineText(chars);
        } else {
            processed = false;
        }
        return processed;
    }

    private void handleCreateFileLineText(String text) {
        LineNativeData data = (LineNativeData)this.elemStack.top().data;
        if (data != null) {
            data.addLineText(text);
        }
    }

    private void handleCreateFileAttributes(Attributes attributes) {
        String file;
        boolean hasErrors = false;
        if (!this.isTopLevelElement()) {
            this.reporter.unexpectedElement("createFile", attributes);
            hasErrors = true;
        }
        if (this.hasUnexpectedAttributes(attributes, "createFile", new String[]{"file", "resolveString"})) {
            hasErrors = true;
        }
        if ((file = attributes.getValue("file")) == null) {
            this.reporter.checkRequiredAttribute("createFile", "file", null);
            hasErrors = true;
        }
        String resolveStringStr = attributes.getValue("resolveString");
        boolean resolveString = false;
        if (resolveStringStr != null) {
            resolveString = this.isAttributeTrue(resolveStringStr);
        }
        if (!hasErrors) {
            CreateFileNativeData data = new CreateFileNativeData(file, resolveString);
            this.nativeData.addData(data);
            this.elemStack.top().data = data;
        }
    }

    private void handleCreateFileLineAttributes(Attributes attributes) {
        boolean hasErrors = false;
        if (!"createFile".equals(this.getParentElementName())) {
            this.reporter.unexpectedElement("line", attributes);
            hasErrors = true;
        }
        if (this.hasUnexpectedAttributes(attributes, "line", new String[0])) {
            hasErrors = true;
        }
        if (!hasErrors) {
            LineNativeData data = new LineNativeData();
            ICommonNativeData parent = this.elemStack.top((int)-1).data;
            if (parent != null) {
                parent.addChild(data);
            }
            this.elemStack.top().data = data;
        }
    }

    public void addSizeInfo(IInstallSizeInfo installSizeInfo) {
        boolean topLevelElement = this.isTopLevelElement();
        SizeInfoCommonNativeData data = new SizeInfoCommonNativeData(installSizeInfo);
        boolean hasErrors = false;
        if (!topLevelElement && !this.isPerformSubElement()) {
            this.reporter.unexpectedElement("sizeInfo", null);
            hasErrors = true;
        }
        if (!hasErrors) {
            if (topLevelElement) {
                this.nativeData.addData(data);
            } else {
                ICommonNativeData parent = this.elemStack.top((int)-1).data;
                if (parent != null) {
                    parent.addChild(data);
                }
            }
            boolean isActive = false;
            this.nativeData.addInstallSizeInfo(installSizeInfo, isActive);
        }
    }

    public IArtifact startArtifact(ElemStack estack, IErrorReporter errorReporter, String uri, String name, String qName, Attributes attributes, String key) {
        estack.push(new ElemStackEntry(name));
        String type = attributes.getValue("", "type");
        if (type == null || type.equals("zip")) {
            return this.handleZipAttributes(key, attributes);
        }
        errorReporter.invalidAttributeValue(name, "type", type);
        return null;
    }

    public IArtifact startArtifactNoKey(ElemStack estack, IErrorReporter errorReporter, String uri, String name, String qName, Attributes attributes, ArtifactCommonAttributes aca) {
        estack.push(new ElemStackEntry(name));
        if ("file".equals(aca.getType())) {
            return this.handleFileAttributes(name, aca, attributes);
        }
        if ("zip".equals(aca.getType())) {
            return this.handleZipAttributes(aca, attributes);
        }
        errorReporter.invalidAttributeValue(name, "type", aca.getType());
        return null;
    }

    protected IArtifact handleZipAttributes(String key, Attributes attributes) {
        DuringPhases phases;
        String perm;
        String destination;
        boolean hasErrors = false;
        boolean topLevelElement = this.isTopLevelElement();
        if (!topLevelElement && !this.isPerformSubElement()) {
            this.reporter.unexpectedElement("zip", attributes);
            hasErrors = true;
        }
        if (this.hasUnexpectedAttributes(attributes, "zip", new String[]{"type", "destination", "duringPhases", "overwrite", "perm"})) {
            hasErrors = true;
        }
        if ((destination = attributes.getValue("destination")) == null) {
            destination = ".";
        }
        if ("".equals(perm = attributes.getValue("perm"))) {
            perm = null;
        }
        String overwriteString = attributes.getValue("overwrite");
        boolean overwrite = false;
        if (overwriteString != null && overwriteString.equalsIgnoreCase("true")) {
            overwrite = true;
        }
        if ((phases = this.parsePhases(attributes.getValue("duringPhases"), "artifact", "duringPhases")) != null && phases.equals(-1L)) {
            hasErrors = true;
        }
        PerformCommonNativeData performData = null;
        if (this.isPerformSubElement()) {
            performData = this.getPerformElement();
        }
        if (hasErrors) {
            return null;
        }
        ZipCommonNativeData data = new ZipCommonNativeData((IDuringPhasesCommonNativeData)performData, this.iu, destination, key, phases, perm, overwrite);
        if (topLevelElement) {
            this.nativeData.addData(data);
        } else {
            ICommonNativeData parent = this.elemStack.top((int)-1).data;
            if (parent != null) {
                parent.addChild(data);
            }
        }
        this.elemStack.top().data = data;
        boolean isActive = this.isActiveArtifact(this.iu, data);
        this.nativeData.addArtifact(data.getArtifact(), isActive);
        return data.getArtifact();
    }

    protected IArtifact handleZipAttributes(ArtifactCommonAttributes aca, Attributes attributes) {
        String phasesString;
        DuringPhases phases;
        String perm;
        String destination;
        boolean hasErrors = false;
        boolean topLevelElement = this.isTopLevelElement();
        if (!topLevelElement && !this.isPerformSubElement()) {
            this.reporter.unexpectedElement("zip", attributes);
            hasErrors = true;
        }
        if (this.hasUnexpectedAttributes(attributes, "zip", new String[]{"type", "destination", "duringPhases", "overwrite", "perm"})) {
            hasErrors = true;
        }
        if ((destination = attributes.getValue("destination")) == null) {
            destination = ".";
        }
        if ("".equals(perm = attributes.getValue("perm"))) {
            perm = null;
        }
        String overwriteString = attributes.getValue("overwrite");
        boolean overwrite = false;
        if (overwriteString != null && overwriteString.equalsIgnoreCase("true")) {
            overwrite = true;
        }
        if ((phases = this.parsePhases(phasesString = attributes.getValue("duringPhases"), "zip", "duringPhases")) != null && phases.equals(-1L)) {
            hasErrors = true;
        }
        PerformCommonNativeData performData = null;
        if (this.isPerformSubElement()) {
            performData = this.getPerformElement();
        }
        if (hasErrors) {
            return null;
        }
        ZipCommonNativeData data = new ZipCommonNativeData((IDuringPhasesCommonNativeData)performData, this.iu, destination, aca, phases, perm, overwrite);
        if (topLevelElement) {
            this.nativeData.addData(data);
        } else {
            ICommonNativeData parent = this.elemStack.top((int)-1).data;
            if (parent != null) {
                parent.addChild(data);
            }
        }
        this.elemStack.top().data = data;
        boolean isActive = this.isActiveArtifact(this.iu, data);
        this.nativeData.addArtifact(data.getArtifact(), isActive);
        return data.getArtifact();
    }

    private boolean isActiveArtifact(IInstallableUnit unit, IDuringPhasesCommonNativeData data) {
        return this.areArtifactsNeededForUpdates(unit) || this.areArtifactsNeededForUninstall(data);
    }

    private boolean areArtifactsNeededForUpdates(IInstallableUnit unit) {
        return InstallableUnitUtil.getOrderDependencies((IInstallableUnit)unit).size() > 0;
    }

    private boolean areArtifactsNeededForUninstall(IDuringPhasesCommonNativeData data) {
        return data.getDuringPhases().getInstallPhases() == 0L && data.getDuringPhases().getUninstallPhases() != 0L;
    }

    private DuringPhases parsePhases(String phasesStr, String elementName, String phasesName) {
        if (phasesStr == null) {
            return null;
        }
        long phases = CommonNativeAdapterUtils.parsePhases(phasesStr);
        if (phases == -1L) {
            this.reporter.invalidAttributeValue(elementName, phasesName, phasesStr);
        }
        return new DuringPhases(phases);
    }

    protected IArtifact handleFileAttributes(String elementName, ArtifactCommonAttributes aca, Attributes attributes) {
        DuringPhases phases;
        boolean hasErrors = false;
        boolean topLevelElement = this.isTopLevelElement();
        if (!topLevelElement && !this.isPerformSubElement()) {
            this.reporter.unexpectedElement(elementName, attributes);
            hasErrors = true;
        }
        if (this.hasUnexpectedAttributes(attributes, elementName, new String[]{"duringPhases", "type", "ext", "perm"})) {
            hasErrors = true;
        }
        SimpleIdentity id = new SimpleIdentity(aca.getId());
        Version version = aca.getVersion();
        String extension = attributes.getValue("ext");
        if (extension == null || extension.length() == 0) {
            extension = "file";
        }
        if ((phases = this.parsePhases(attributes.getValue("duringPhases"), "artifact", "duringPhases")) != null && phases.equals(-1L)) {
            hasErrors = true;
        }
        PerformCommonNativeData performData = null;
        if (this.isPerformSubElement()) {
            performData = this.getPerformElement();
        }
        if (hasErrors) {
            return null;
        }
        NativeFileArtifactCommonNativeData data = new NativeFileArtifactCommonNativeData(performData, (IIdentity)id, version, extension, aca.isActive(), phases);
        if (topLevelElement) {
            this.nativeData.addData(data);
        } else {
            ICommonNativeData parent = this.elemStack.top((int)-1).data;
            if (parent != null) {
                parent.addChild(data);
            }
        }
        this.elemStack.top().data = data;
        boolean isActive = aca.isActive();
        if (!isActive) {
            isActive = this.isActiveArtifact(this.iu, data);
        }
        this.nativeData.addArtifact(data.getArtifact(), isActive);
        return data.getArtifact();
    }

    protected void handlePerformAttributes(Attributes attributes) {
        boolean hasErrors = false;
        if (!this.isTopLevelElement()) {
            this.reporter.unexpectedElement("perform", attributes);
            hasErrors = true;
        }
        if (this.hasUnexpectedAttributes(attributes, "perform", new String[]{"duringPhases"})) {
            hasErrors = true;
        }
        String phasesStr = attributes.getValue("duringPhases");
        DuringPhases phases = null;
        if (phasesStr == null) {
            this.reporter.checkRequiredAttribute("perform", "duringPhases", null);
            hasErrors = true;
        } else {
            long lphases = PerformCommonNativeData.parsePhases(phasesStr);
            if (lphases == -1L) {
                this.reporter.invalidAttributeValue("perform", "duringPhases", phasesStr);
                hasErrors = true;
            } else {
                phases = new DuringPhases(lphases);
            }
        }
        if (!hasErrors) {
            PerformCommonNativeData data = new PerformCommonNativeData(phases, this.performIndex++);
            this.nativeData.addData(data);
            this.elemStack.top().data = data;
        }
    }

    protected void handleLogAttributes(Attributes attributes) {
        boolean hasErrors = false;
        if (this.hasUnexpectedAttributes(attributes, "log", new String[]{"duringPhases", "level"})) {
            hasErrors = true;
        }
        String phasesStr = attributes.getValue("duringPhases");
        DuringPhases phases = null;
        if (phasesStr != null) {
            long lphases = LogCommonNativeData.parsePhases(phasesStr);
            if (lphases == -1L) {
                this.reporter.invalidAttributeValue("log", "duringPhases", phasesStr);
                hasErrors = true;
            } else {
                phases = new DuringPhases(lphases);
            }
        }
        String levelStr = attributes.getValue("level");
        int level = -1;
        if (levelStr == null) {
            this.reporter.checkRequiredAttribute("log", "level", null);
            hasErrors = true;
        } else {
            level = LogCommonNativeData.parseLevel(levelStr);
            if (level == -1) {
                this.reporter.invalidAttributeValue("log", "level", levelStr);
                hasErrors = true;
            }
        }
        if (!hasErrors) {
            PerformCommonNativeData performData = null;
            if (this.isPerformSubElement()) {
                performData = this.getPerformElement();
            }
            LogCommonNativeData data = new LogCommonNativeData(performData, phases, level);
            if (this.isTopLevelElement()) {
                this.nativeData.addData(data);
            } else {
                ICommonNativeData parent = this.elemStack.top((int)-1).data;
                if (parent != null) {
                    parent.addChild(data);
                }
            }
            this.elemStack.top().data = data;
        }
    }

    protected void handleExecAttributes(Attributes attributes) {
        int approximateTime;
        String workingDirectory;
        String command;
        boolean hasErrors = false;
        if (!this.isPerformSubElement()) {
            this.reporter.unexpectedElement("exec", attributes);
            hasErrors = true;
        }
        if (this.hasUnexpectedAttributes(attributes, "exec", new String[]{"failOnError", "command", "workingDirectory", "approximateTime", "description"})) {
            hasErrors = true;
        }
        String failOnErrorValue = attributes.getValue("failOnError");
        boolean failOnError = true;
        if (failOnErrorValue != null) {
            boolean bl = failOnError = !this.isAttributeFalse(failOnErrorValue);
        }
        if ((command = attributes.getValue("command")) == null) {
            this.reporter.checkRequiredAttribute("exec", "command", null);
            hasErrors = true;
        }
        if ((workingDirectory = attributes.getValue("workingDirectory")) == null || workingDirectory.length() == 0) {
            workingDirectory = ".";
        }
        if ((approximateTime = this.getApproximateTime("exec", attributes)) == -1) {
            hasErrors = true;
        }
        String description = attributes.getValue("description");
        if (!hasErrors) {
            ExecCommonNativeData data = new ExecCommonNativeData(failOnError, command, workingDirectory, approximateTime, description);
            ICommonNativeData parent = this.elemStack.top((int)-1).data;
            if (parent != null) {
                parent.addChild(data);
            }
            this.elemStack.top().data = data;
        }
    }

    private void handleInvokeAttributes(Attributes attributes) {
        int approximateTime;
        String classpath;
        String classname;
        boolean hasErrors = false;
        if (!this.isPerformSubElement()) {
            this.reporter.unexpectedElement("invoke", attributes);
            hasErrors = true;
        }
        if (this.hasUnexpectedAttributes(attributes, "invoke", new String[]{"class", "classpath", "approximateTime", "description"})) {
            hasErrors = true;
        }
        if ((classname = attributes.getValue("class")) == null) {
            this.reporter.checkRequiredAttribute("invoke", "class", null);
            hasErrors = true;
        }
        if ((classpath = attributes.getValue("classpath")) == null) {
            this.reporter.checkRequiredAttribute("invoke", "classpath", null);
            hasErrors = true;
        }
        if ((approximateTime = this.getApproximateTime("invoke", attributes)) == -1) {
            hasErrors = true;
        }
        String description = attributes.getValue("description");
        if (!hasErrors) {
            InvokeCommonNativeData data = new InvokeCommonNativeData(classname, classpath, approximateTime, description);
            ICommonNativeData parent = this.elemStack.top((int)-1).data;
            if (parent != null) {
                parent.addChild(data);
            }
            this.elemStack.top().data = data;
        }
    }

    protected int getApproximateTime(String elemName, Attributes attributes) {
        String approximateTimeStr = attributes.getValue("approximateTime");
        int approximateTime = 0;
        if (approximateTimeStr != null && (approximateTime = CommonNativeAdapterUtils.parseTime(approximateTimeStr)) == -1) {
            this.reporter.invalidAttributeValue(elemName, "approximateTime", approximateTimeStr);
        }
        return approximateTime;
    }

    protected void handleExecArgAttributes(Attributes attributes) {
        boolean hasErrors = false;
        if (!this.isExecSubElement() && !this.isInvokeSubElement()) {
            this.reporter.unexpectedElement("arg", attributes);
            hasErrors = true;
        }
        if (this.hasUnexpectedAttributes(attributes, "arg", new String[0])) {
            hasErrors = true;
        }
        if (!hasErrors) {
            ArgCommonNativeData data = new ArgCommonNativeData();
            ICommonNativeData parent = this.elemStack.top((int)-1).data;
            if (parent != null) {
                parent.addChild(data);
            }
            this.elemStack.top().data = data;
        }
    }

    protected void handleLogMsgAttributes(Attributes attributes) {
        boolean hasErrors = false;
        if (!this.isLogSubElement()) {
            this.reporter.unexpectedElement("message", attributes);
            hasErrors = true;
        }
        if (this.hasUnexpectedAttributes(attributes, "message", new String[]{"href"})) {
            hasErrors = true;
        }
        String href = attributes.getValue("href");
        if (!hasErrors) {
            MsgCommonNativeData data = new MsgCommonNativeData(href);
            ICommonNativeData parent = this.elemStack.top((int)-1).data;
            if (parent != null) {
                parent.addChild(data);
            }
            this.elemStack.top().data = data;
        }
    }

    protected void handleExecArgText(String text) {
        ArgCommonNativeData data = (ArgCommonNativeData)this.elemStack.top().data;
        if (data != null) {
            data.addArgText(text);
        }
    }

    protected void handleLogMsgText(String text) {
        MsgCommonNativeData data = (MsgCommonNativeData)this.elemStack.top().data;
        if (data != null) {
            data.setMsgText(text);
        }
    }

    protected void handleChmodAttributes(Attributes attributes) {
        String recursiveString;
        String perm;
        boolean hasErrors = false;
        if (!this.isPerformSubElement()) {
            this.reporter.unexpectedElement("chmod", attributes);
            hasErrors = true;
        }
        if (this.hasUnexpectedAttributes(attributes, "chmod", new String[]{"perm", "recursive"})) {
            hasErrors = true;
        }
        if ((perm = attributes.getValue("perm")) == null) {
            this.reporter.checkRequiredAttribute("chmod", "perm", null);
            hasErrors = true;
        }
        if ((recursiveString = attributes.getValue("recursive")) == null) {
            this.reporter.checkRequiredAttribute("chmod", "recursive", null);
            hasErrors = true;
        }
        boolean recursive = true;
        if (recursiveString != null) {
            recursive = this.isAttributeTrue(recursiveString);
        }
        if (!hasErrors) {
            ChmodCommonNativeData data = new ChmodCommonNativeData(perm, recursive);
            ICommonNativeData parent = this.elemStack.top((int)-1).data;
            if (parent != null) {
                parent.addChild(data);
            }
            this.elemStack.top().data = data;
        }
    }

    protected void handleCreateSymLink(Attributes attributes) {
        String target;
        String link;
        boolean hasErrors = false;
        if (!this.isPerformSubElement()) {
            this.reporter.unexpectedElement("createSymLink", attributes);
            hasErrors = true;
        }
        if (this.hasUnexpectedAttributes(attributes, "createSymLink", new String[]{"link", "target"})) {
            hasErrors = true;
        }
        if ((link = attributes.getValue("link")) == null) {
            this.reporter.checkRequiredAttribute("createSymLink", "link", null);
            hasErrors = true;
        }
        if ((target = attributes.getValue("target")) == null) {
            this.reporter.checkRequiredAttribute("createSymLink", "target", null);
            hasErrors = true;
        }
        if (!hasErrors) {
            CreateSymLinkCommonNativeData data = new CreateSymLinkCommonNativeData(link, target);
            ICommonNativeData parent = this.elemStack.top((int)-1).data;
            if (parent != null) {
                parent.addChild(data);
            }
            this.elemStack.top().data = data;
        }
    }

    protected void handleSymLink(Attributes attributes) {
        DuringPhases phases;
        String target;
        String link;
        boolean hasErrors = false;
        if (!this.isTopLevelElement()) {
            this.reporter.unexpectedElement("symLink", attributes);
            hasErrors = true;
        }
        if (this.hasUnexpectedAttributes(attributes, "symLink", new String[]{"link", "target", "duringPhases"})) {
            hasErrors = true;
        }
        if ((link = attributes.getValue("link")) == null) {
            this.reporter.checkRequiredAttribute("symLink", "link", null);
            hasErrors = true;
        }
        if ((target = attributes.getValue("target")) == null) {
            this.reporter.checkRequiredAttribute("symLink", "target", null);
            hasErrors = true;
        }
        if ((phases = this.parsePhases(attributes.getValue("duringPhases"), "symLink", "duringPhases")) != null && phases.equals(-1L)) {
            hasErrors = true;
        }
        if (!hasErrors) {
            SymLinkCommonNativeData data = new SymLinkCommonNativeData(link, target, phases);
            this.nativeData.addData(data);
        }
    }

    protected void handleReboot(Attributes attributes) {
        boolean hasErrors = false;
        if (!this.isPerformSubElement()) {
            this.reporter.unexpectedElement("reboot", attributes);
            hasErrors = true;
        }
        if (this.hasUnexpectedAttributes(attributes, "reboot", new String[0])) {
            hasErrors = true;
        }
        if (!hasErrors) {
            RebootCommonNativeData data = new RebootCommonNativeData();
            ICommonNativeData parent = this.elemStack.top((int)-1).data;
            if (parent != null) {
                parent.addChild(data);
            }
            this.elemStack.top().data = data;
        }
    }

    protected void handleChmodFileAttributes(Attributes attributes) {
        boolean hasErrors = false;
        if (!this.isChmodSubElement()) {
            this.reporter.unexpectedElement("file", attributes);
            hasErrors = true;
        }
        if (this.hasUnexpectedAttributes(attributes, "file", new String[0])) {
            hasErrors = true;
        }
        if (!hasErrors) {
            FileCommonNativeData data = new FileCommonNativeData();
            ICommonNativeData parent = this.elemStack.top((int)-1).data;
            if (parent != null) {
                parent.addChild(data);
            }
            this.elemStack.top().data = data;
        }
    }

    protected void handleChmodFileText(String text) {
        FileCommonNativeData data = (FileCommonNativeData)this.elemStack.top().data;
        if (data != null) {
            data.addFileText(text);
        }
    }

    protected void handleMkdirAttributes(Attributes attributes) {
        String dir;
        boolean hasErrors = false;
        if (!this.isPerformSubElement()) {
            this.reporter.unexpectedElement("mkdir", attributes);
            hasErrors = true;
        }
        if (this.hasUnexpectedAttributes(attributes, "mkdir", new String[]{"dir"})) {
            hasErrors = true;
        }
        if ((dir = attributes.getValue("dir")) == null) {
            this.reporter.checkRequiredAttribute("mkdir", "dir", null);
            hasErrors = true;
        }
        if (!hasErrors) {
            MkdirCommonNativeData data = new MkdirCommonNativeData(dir);
            ICommonNativeData parent = this.elemStack.top((int)-1).data;
            if (parent != null) {
                parent.addChild(data);
            }
            this.elemStack.top().data = data;
        }
    }

    protected void handleDeleteAttributes(Attributes attributes) {
        String file;
        boolean hasErrors = false;
        if (!this.isPerformSubElement()) {
            this.reporter.unexpectedElement("delete", attributes);
            hasErrors = true;
        }
        if (this.hasUnexpectedAttributes(attributes, "delete", new String[]{"file", "deleteDirIfEmpty"})) {
            hasErrors = true;
        }
        if ((file = attributes.getValue("file")) == null) {
            this.reporter.checkRequiredAttribute("delete", "file", null);
            hasErrors = true;
        }
        String deleteDirIfEmptyString = attributes.getValue("deleteDirIfEmpty");
        boolean deleteDirIfEmpty = true;
        if (deleteDirIfEmptyString != null) {
            deleteDirIfEmpty = !this.isAttributeFalse(deleteDirIfEmptyString);
        }
        if (!hasErrors) {
            DeleteCommonNativeData data = new DeleteCommonNativeData(file, deleteDirIfEmpty);
            ICommonNativeData parent = this.elemStack.top((int)-1).data;
            if (parent != null) {
                parent.addChild(data);
            }
            this.elemStack.top().data = data;
        }
    }

    protected void handleCopyAttributes(Attributes attributes) {
        String perm;
        String target;
        String src;
        boolean hasErrors = false;
        if (!this.isPerformSubElement()) {
            this.reporter.unexpectedElement("copy", attributes);
            hasErrors = true;
        }
        if (this.hasUnexpectedAttributes(attributes, "copy", new String[]{"src", "target", "rename", "perm"})) {
            hasErrors = true;
        }
        if ((src = attributes.getValue("src")) == null) {
            this.reporter.checkRequiredAttribute("copy", "src", null);
            hasErrors = true;
        }
        if ((target = attributes.getValue("target")) == null) {
            this.reporter.checkRequiredAttribute("copy", "target", null);
            hasErrors = true;
        }
        if ("".equals(perm = attributes.getValue("perm"))) {
            perm = null;
        }
        String renameString = attributes.getValue("rename");
        boolean rename = false;
        if (renameString != null) {
            rename = this.isAttributeTrue(renameString);
        }
        if (!hasErrors) {
            CopyCommonNativeData data = new CopyCommonNativeData(src, target, rename, perm);
            ICommonNativeData parent = this.elemStack.top((int)-1).data;
            if (parent != null) {
                parent.addChild(data);
            }
            this.elemStack.top().data = data;
        }
    }

    protected void handleMoveAttributes(Attributes attributes) {
        String perm;
        String target;
        String src;
        boolean hasErrors = false;
        if (!this.isPerformSubElement()) {
            this.reporter.unexpectedElement("move", attributes);
            hasErrors = true;
        }
        if (this.hasUnexpectedAttributes(attributes, "move", new String[]{"src", "target", "rename", "perm"})) {
            hasErrors = true;
        }
        if ((src = attributes.getValue("src")) == null) {
            this.reporter.checkRequiredAttribute("move", "src", null);
            hasErrors = true;
        }
        if ((target = attributes.getValue("target")) == null) {
            this.reporter.checkRequiredAttribute("move", "target", null);
            hasErrors = true;
        }
        if ("".equals(perm = attributes.getValue("perm"))) {
            perm = null;
        }
        String renameString = attributes.getValue("rename");
        boolean rename = false;
        if (renameString != null) {
            rename = this.isAttributeTrue(renameString);
        }
        if (!hasErrors) {
            MoveCommonNativeData data = new MoveCommonNativeData(src, target, rename, perm);
            ICommonNativeData parent = this.elemStack.top((int)-1).data;
            if (parent != null) {
                parent.addChild(data);
            }
            this.elemStack.top().data = data;
        }
    }

    protected void handleAgentPropertyAttributes(Attributes attributes) {
        String value;
        String name;
        boolean hasErrors = false;
        if (!this.isTopLevelElement()) {
            this.reporter.unexpectedElement("agent-location", attributes);
            hasErrors = true;
        }
        if (this.hasUnexpectedAttributes(attributes, "agent-location", new String[]{"id", "relative-path"})) {
            hasErrors = true;
        }
        if ((name = attributes.getValue("id")) == null) {
            this.reporter.checkRequiredAttribute("agent-location", "id", null);
            hasErrors = true;
        }
        if ((value = attributes.getValue("relative-path")) == null) {
            this.reporter.checkRequiredAttribute("agent-location", "relative-path", null);
            hasErrors = true;
        }
        if (!hasErrors) {
            AgentLocationCommonNativeData data = new AgentLocationCommonNativeData(name, value);
            this.nativeData.addData(data);
        }
    }

    protected boolean isTopLevelElement() {
        return this.elemStack.size() == 1;
    }

    protected boolean isSubElementOf(String element) {
        int i = -1;
        while (i > -20) {
            ElemStackEntry entry = this.elemStack.top(i);
            if (entry == null) {
                return false;
            }
            if (entry.name.equals(element)) {
                return true;
            }
            --i;
        }
        return false;
    }

    protected String getParentElementName() {
        ElemStackEntry entry = this.elemStack.top(-1);
        if (entry == null) {
            return null;
        }
        return entry.name;
    }

    protected boolean isChmodSubElement() {
        ElemStackEntry entry = this.elemStack.top(-1);
        if (entry == null) {
            return false;
        }
        return entry.name.equals("chmod");
    }

    protected boolean isPerformSubElement() {
        ElemStackEntry entry = this.elemStack.top(-1);
        if (entry == null) {
            return false;
        }
        return entry.name.equals("perform");
    }

    protected PerformCommonNativeData getPerformElement() {
        ElemStackEntry entry = this.elemStack.top(-1);
        if (entry != null && entry.name.equals("perform")) {
            return (PerformCommonNativeData)entry.data;
        }
        return null;
    }

    protected boolean isExecSubElement() {
        ElemStackEntry entry = this.elemStack.top(-1);
        if (entry == null) {
            return false;
        }
        return entry.name.equals("exec");
    }

    protected boolean isLogSubElement() {
        ElemStackEntry entry = this.elemStack.top(-1);
        if (entry == null) {
            return false;
        }
        return entry.name.equals("log");
    }

    protected boolean isInvokeSubElement() {
        ElemStackEntry entry = this.elemStack.top(-1);
        if (entry == null) {
            return false;
        }
        return entry.name.equals("invoke");
    }

    protected boolean hasUnexpectedAttributes(Attributes attributes, String elemName, String[] expectedAttributes) {
        boolean result = false;
        int len = attributes.getLength();
        int i = 0;
        while (i < len) {
            String name = attributes.getLocalName(i);
            boolean foundit = false;
            String[] stringArray = expectedAttributes;
            int n = expectedAttributes.length;
            int n2 = 0;
            while (n2 < n) {
                String expectedAttribute = stringArray[n2];
                if (name.equals(expectedAttribute)) {
                    foundit = true;
                    break;
                }
                ++n2;
            }
            if (!foundit) {
                String value = attributes.getValue(i).trim();
                this.reporter.unexpectedAttribute(elemName, name, value);
                result = true;
            }
            ++i;
        }
        return result;
    }

    protected boolean isAttributeTrue(String value) {
        return XMLUtil.isAttributeTrue((String)value);
    }

    protected boolean isAttributeFalse(String value) {
        return XMLUtil.isAttributeFalse((String)value);
    }

    private boolean isCreateFileSubElement() {
        ElemStackEntry entry = this.elemStack.top(-1);
        if (entry == null) {
            return false;
        }
        return entry.name.equals("createFile");
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isInstance(this)) {
            return this;
        }
        return null;
    }

    public static class ElemStack
    extends Stack {
        private static final long serialVersionUID = -8037870419018380418L;

        public ElemStackEntry top() {
            return (ElemStackEntry)this.peek();
        }

        public ElemStackEntry top(int topRelativeIndex) {
            int topIndex = this.size() - 1;
            int index = topIndex + topRelativeIndex;
            if (index < 0 || index > topIndex) {
                return null;
            }
            return (ElemStackEntry)this.get(index);
        }
    }

    public static class ElemStackEntry {
        public String name;
        public ICommonNativeData data = null;

        public ElemStackEntry(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

