/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.jnl;

import com.sun.deploy.Environment;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.config.Platform;
import com.sun.deploy.security.ruleset.DeploymentRuleSet;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.JVMParameters;
import com.sun.deploy.util.ParameterUtil;
import com.sun.deploy.util.SecurityBaseline;
import com.sun.deploy.util.VersionString;
import com.sun.javaws.jnl.JREDesc;
import com.sun.javaws.jnl.JavaFXRuntimeDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.ResourcesDesc;
import java.io.File;
import java.net.URL;

public class JREMatcher {
    private static final boolean DEBUG = Trace.isEnabled((TraceLevel)TraceLevel.RULESET);
    private JREDesc selectedJREDesc;
    private JREInfo selectedJREInfo;
    private boolean matchComplete;
    private boolean matchSecureComplete;
    private boolean matchVersion;
    private boolean matchFXVersion;
    private boolean matchJVMArgs;
    private boolean matchSecureJVMArgs;
    private long selectedMaxHeap;
    private long selectedInitHeap;
    private JVMParameters selectedJVMArgs;
    private JREDesc drsDesc;
    private int selectionResult;
    private boolean matchToJnlpFound;
    private boolean matchToDRSFound;
    private boolean secureOnly;

    public JREMatcher() {
        this.setDRSVersion(null, false);
    }

    public void setDRSVersion(String string, boolean bl) {
        this.drsDesc = string != null ? new JREDesc(string, bl) : null;
        this.reset(null);
    }

    public boolean hasBeenRun() {
        return null != this.selectedJVMArgs;
    }

    public void beginTraversal(LaunchDesc launchDesc) {
        this.reset(launchDesc);
        if (DEBUG) {
            Trace.println((String)"\tMatch: beginTraversal");
        }
    }

    private void reset(LaunchDesc launchDesc) {
        this.matchComplete = false;
        this.matchSecureComplete = false;
        this.matchVersion = false;
        this.matchFXVersion = false;
        this.matchJVMArgs = false;
        this.matchSecureJVMArgs = false;
        this.selectedInitHeap = -1L;
        this.selectedJREDesc = null;
        this.selectedJREInfo = null;
        if (null == launchDesc) {
            this.selectedMaxHeap = -1L;
            this.selectedJVMArgs = null;
        } else {
            this.selectedMaxHeap = JVMParameters.getDefaultHeapSize();
            this.selectedJVMArgs = new JVMParameters();
        }
        this.matchToJnlpFound = false;
        this.matchToDRSFound = false;
        this.selectionResult = 0;
    }

    public int getSelectionResult() {
        return this.selectionResult;
    }

    public JREInfo getSelectedJREInfo() {
        return this.selectedJREInfo;
    }

    public JREDesc getSelectedJREDesc() {
        return this.selectedJREDesc;
    }

    public JVMParameters getSelectedJVMParameters() {
        return this.selectedJVMArgs;
    }

    public long getSelectedInitHeapSize() {
        return this.selectedInitHeap;
    }

    public long getSelectedMaxHeapSize() {
        return this.selectedMaxHeap;
    }

    public boolean isRunningJVMSatisfying(boolean bl) {
        if (this.secureOnly && !SecurityBaseline.satisfiesSecurityBaseline(null)) {
            return false;
        }
        if (this.selectedJREInfo != null && !this.hasRunningVMRequiredArgs(this.selectedJREInfo)) {
            return false;
        }
        if (bl) {
            return this.matchComplete;
        }
        return this.matchSecureComplete;
    }

    private boolean hasRunningVMRequiredArgs(JREInfo jREInfo) {
        return ParameterUtil.hasRunningVMRequiredArgs((String)jREInfo.getVmArgs());
    }

    public boolean isRunningJVMVersionSatisfying() {
        return this.matchVersion && this.matchFXVersion;
    }

    public boolean isRunningJVMArgsSatisfying(boolean bl) {
        if (bl) {
            return this.matchJVMArgs;
        }
        return this.matchSecureJVMArgs;
    }

    public void digest(JREDesc jREDesc, JREInfo jREInfo) {
        if (DEBUG) {
            Trace.println((String)("Match: digest selected JREDesc: " + jREDesc + ", JREInfo: " + jREInfo));
        }
        this.selectedJREDesc = jREDesc;
        this.selectedJREInfo = jREInfo;
        long l = jREDesc.getMaxHeap();
        if (l > this.selectedMaxHeap) {
            this.selectedMaxHeap = l;
            if (DEBUG) {
                Trace.println((String)("\tMatch: selecting maxHeap: " + l));
            }
        } else if (DEBUG) {
            Trace.println((String)("\tMatch: ignoring maxHeap: " + l));
        }
        if ((l = jREDesc.getMinHeap()) > this.selectedInitHeap) {
            this.selectedInitHeap = l;
            if (DEBUG) {
                Trace.println((String)("\tMatch: selecting InitHeap: " + l));
            }
        } else if (DEBUG) {
            Trace.println((String)("\tMatch: ignoring InitHeap: " + l));
        }
        if (DEBUG) {
            Trace.println((String)("\tMatch: digesting vmargs: " + jREDesc.getVmArgs()));
        }
        this.selectedJVMArgs.parse(jREDesc.getVmArgs());
        if (DEBUG) {
            Trace.println((String)("\tMatch: digested vmargs: " + this.selectedJVMArgs));
        }
        if ((l = this.selectedJVMArgs.getMaxHeapSize()) > this.selectedMaxHeap) {
            this.selectedMaxHeap = l;
            if (DEBUG) {
                Trace.println((String)("\tMatch: selecting maxHeap(2): " + l));
            }
        }
        this.selectedJVMArgs.setMaxHeapSize(JVMParameters.getDefaultHeapSize());
        if (DEBUG) {
            Trace.println((String)("\tMatch: JVM args after accumulation: " + this.selectedJVMArgs));
        }
        if (jREInfo != null) {
            this.selectionResult = 1;
        } else {
            if (this.drsDesc != null) {
                this.calculateMatchesToDRS();
            }
            this.selectionResult = this.matchToJnlpFound && !this.matchToDRSFound ? 3 : (!this.matchToJnlpFound && this.matchToDRSFound ? 2 : 4);
        }
    }

    private void calculateMatchesToDRS() {
        JREInfo[] jREInfoArray = JREInfo.getAll();
        if (jREInfoArray != null) {
            for (int i = 0; i < jREInfoArray.length; ++i) {
                if (!JREMatcher.isDRSVersionMatch(jREInfoArray[i], this.drsDesc)) continue;
                this.matchToDRSFound = true;
            }
        }
    }

    public static String getJREVersionFromDRS(DeploymentRuleSet deploymentRuleSet) {
        JREDesc jREDesc = new JREDesc(deploymentRuleSet.getVersionString(), deploymentRuleSet.isVersionForced());
        JREInfo[] jREInfoArray = JREInfo.getAll();
        if (jREInfoArray != null) {
            for (int i = 0; i < jREInfoArray.length; ++i) {
                if (!JREMatcher.isDRSVersionMatch(jREInfoArray[i], jREDesc)) continue;
                return jREInfoArray[i].getProduct();
            }
        }
        return null;
    }

    public void digest(LaunchDesc launchDesc) {
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (null != resourcesDesc) {
            this.selectedJVMArgs.addProperties(resourcesDesc.getResourcePropertyList());
        }
        if (DEBUG) {
            Trace.println((String)("\tMatch: digest LaunchDesc: " + launchDesc.getLocation()));
            if (null != resourcesDesc) {
                Trace.println((String)("\tMatch: digest properties: " + resourcesDesc.getResourcePropertyList()));
            } else {
                Trace.println((String)"\tMatch: digest properties: ResourcesDesc null");
            }
            Trace.println((String)("\tMatch: JVM args: " + this.selectedJVMArgs));
        }
    }

    public void endTraversal(LaunchDesc launchDesc) {
        if (DEBUG) {
            Trace.println((String)"\tMatch: endTraversal ..");
        }
        if (launchDesc.isApplicationDescriptor() && null == this.selectedJREDesc) {
            throw new IllegalArgumentException("selectedJREDesc null");
        }
        if (this.selectedInitHeap > 0L && this.selectedInitHeap != JVMParameters.getDefaultHeapSize()) {
            this.selectedJVMArgs.parse("-Xms" + JVMParameters.unparseMemorySpec((long)this.selectedInitHeap));
        }
        this.selectedJVMArgs.setMaxHeapSize(this.selectedMaxHeap);
        if (this.selectedJREInfo == null) {
            return;
        }
        this.matchVersion = this.isVersionMatch(launchDesc, this.selectedJREInfo);
        this.matchFXVersion = this.isFXVersionMatch(launchDesc, this.selectedJREInfo);
        if (!this.matchFXVersion) {
            this.selectedJREInfo = null;
            return;
        }
        JVMParameters jVMParameters = JVMParameters.getRunningJVMParameters();
        if (jVMParameters == null) {
            if (Trace.isEnabled((TraceLevel)TraceLevel.BASIC)) {
                Trace.println((String)("\t Match: Running JVM is not set: want:<" + this.selectedJVMArgs + ">"), (TraceLevel)TraceLevel.BASIC);
            }
            this.matchJVMArgs = false;
            this.matchSecureJVMArgs = false;
        } else if (jVMParameters.satisfies(this.selectedJVMArgs)) {
            if (DEBUG) {
                Trace.println((String)("\t Match: Running JVM args match: have:<" + jVMParameters + ">  satisfy want:<" + this.selectedJVMArgs + ">"));
            }
            this.matchJVMArgs = true;
            this.matchSecureJVMArgs = true;
        } else if (jVMParameters.satisfiesSecure(this.selectedJVMArgs)) {
            if (DEBUG) {
                Trace.println((String)("\t Match: Running JVM args match the secure subset: have:<" + jVMParameters + ">  satisfy want:<" + this.selectedJVMArgs + ">"));
            }
            this.matchJVMArgs = false;
            this.matchSecureJVMArgs = true;
        } else {
            if (DEBUG) {
                Trace.println((String)("\t Match: Running JVM args mismatch: have:<" + jVMParameters + "> !satisfy want:<" + this.selectedJVMArgs + ">"));
            }
            this.matchJVMArgs = false;
            this.matchSecureJVMArgs = false;
        }
        this.matchComplete = this.matchVersion && this.matchJVMArgs && this.matchFXVersion;
        this.matchSecureComplete = this.matchVersion && this.matchSecureJVMArgs && this.matchFXVersion;
    }

    public static boolean isInstallJRE(JREInfo jREInfo) {
        File file = new File(Environment.getJavaHome());
        File file2 = new File(jREInfo.getPath());
        File file3 = file2.getParentFile();
        File file4 = new File(file, "lib" + File.separator + "rt.jar");
        if (!file4.exists()) {
            return true;
        }
        return Platform.get().samePaths(file.getPath(), file3.getParentFile().getPath());
    }

    private static boolean isPlatformMatch(JREInfo jREInfo, JREDesc jREDesc) {
        VersionString versionString = new VersionString(jREDesc.getVersion());
        String string = jREInfo.getProduct();
        boolean bl = string == null || JREMatcher.isInstallJRE(jREInfo) || string.indexOf(45) == -1 || string.indexOf("-rev") != -1 || string.indexOf("-er") != -1;
        return versionString.contains(jREInfo.getPlatform()) && bl;
    }

    private static boolean isProductMatch(JREInfo jREInfo, JREDesc jREDesc, boolean bl) {
        boolean bl2;
        String string = jREInfo.getProduct();
        if (bl) {
            int n = string.indexOf("-");
            string = n > 0 ? string.substring(0, n) : string;
        }
        VersionString versionString = new VersionString(jREDesc.getVersion());
        URL uRL = jREDesc.getHref();
        boolean bl3 = bl2 = uRL == null || jREInfo.getLocation().equals(uRL.toString());
        if (bl2) {
            return versionString.contains(string);
        }
        return false;
    }

    protected boolean isDefaultVersionMatch(JREInfo jREInfo, JREDesc jREDesc) {
        if (this.secureOnly) {
            return SecurityBaseline.satisfiesSecurityBaseline((JREInfo)jREInfo);
        }
        if (jREDesc.getVersionType() == 0) {
            return JREMatcher.isProductMatch(jREInfo, jREDesc, false);
        }
        return JREMatcher.isPlatformMatch(jREInfo, jREDesc);
    }

    public boolean isVersionMatch(JREInfo jREInfo, JREDesc jREDesc) {
        if (!jREInfo.isFakeJRE() && !new File(jREInfo.getPath()).exists()) {
            return false;
        }
        if (this.drsDesc != null && this.drsDesc.isVersionForced()) {
            if (JREMatcher.isDRSVersionMatch(jREInfo, this.drsDesc)) {
                this.matchToJnlpFound = true;
                return true;
            }
            return false;
        }
        if (!this.isDefaultVersionMatch(jREInfo, jREDesc)) {
            return false;
        }
        if (this.drsDesc != null) {
            this.matchToJnlpFound = true;
            return JREMatcher.isDRSVersionMatch(jREInfo, this.drsDesc);
        }
        return true;
    }

    private static boolean isDRSVersionMatch(JREInfo jREInfo, JREDesc jREDesc) {
        if (jREDesc.isSecure()) {
            if (jREDesc.getVersion() == null) {
                return SecurityBaseline.satisfiesBaselineStrictly((JREInfo)jREInfo);
            }
            String string = SecurityBaseline.getBaselineVersion((String)jREDesc.getVersion());
            return SecurityBaseline.satisfiesBaselineStrictly((JREInfo)jREInfo, (String)string);
        }
        if (jREDesc.getVersionType() == 0) {
            return JREMatcher.isProductMatch(jREInfo, jREDesc, true);
        }
        return JREMatcher.isPlatformMatch(jREInfo, jREDesc);
    }

    public static boolean isFXVersionMatch(String string, VersionString versionString) {
        if (versionString == null) {
            return false;
        }
        String string2 = versionString.toString().trim();
        if (string2.endsWith("+")) {
            return versionString.contains(string);
        }
        String string3 = string2;
        int n = string2.indexOf(".");
        if (n != -1) {
            string3 = string3.substring(0, n);
        }
        string3 = string3 + "*";
        String string4 = string2;
        if (string4.endsWith("*")) {
            string4 = string4.substring(0, string4.length() - 1);
        }
        string4 = string4 + "+";
        VersionString versionString2 = new VersionString(string3);
        VersionString versionString3 = new VersionString(string4);
        return versionString2.contains(string) && versionString3.contains(string);
    }

    public boolean isFXVersionMatch(JREInfo jREInfo, VersionString versionString) {
        if (versionString == null || versionString.toString().equals("")) {
            return true;
        }
        return jREInfo.getFXVersion() != null && JREMatcher.isFXVersionMatch(jREInfo.getFXVersion().toString(), versionString);
    }

    public boolean isFXVersionMatch(LaunchDesc launchDesc, JREInfo jREInfo) {
        JavaFXRuntimeDesc javaFXRuntimeDesc = launchDesc.getJavaFXRuntimeDescriptor();
        if (javaFXRuntimeDesc == null) {
            return true;
        }
        VersionString versionString = new VersionString(javaFXRuntimeDesc.getVersion());
        return JREMatcher.isFXVersionMatch(jREInfo.getFXVersion().toString(), versionString);
    }

    public boolean isVersionMatch(LaunchDesc launchDesc, JREInfo jREInfo) {
        if (this.secureOnly) {
            return SecurityBaseline.satisfiesSecurityBaseline((JREInfo)jREInfo);
        }
        JREInfo jREInfo2 = launchDesc.getHomeJRE();
        if (!jREInfo2.getProductVersion().match(jREInfo.getProductVersion())) {
            if (DEBUG) {
                Trace.println((String)("\tMatch: Running JREInfo Version mismatches: " + jREInfo2.getProductVersion() + " != " + jREInfo.getProductVersion()));
            }
            return false;
        }
        if (DEBUG) {
            Trace.println((String)("\tMatch: Running JREInfo Version    match: " + jREInfo2.getProductVersion() + " == " + jREInfo.getProductVersion()));
        }
        return true;
    }

    public void setSecureOnly(boolean bl) {
        if (this.secureOnly != bl) {
            this.reset(null);
            this.secureOnly = bl;
        }
    }

    public boolean getSecureOnly() {
        return this.secureOnly;
    }

    public String toString() {
        return "JREMatcher: \n  JREDesc:    " + this.getSelectedJREDesc() + "\n  JREInfo:    " + this.getSelectedJREInfo() + "\n  Init Heap:  " + this.getSelectedInitHeapSize() + "\n  Max  Heap:  " + this.getSelectedMaxHeapSize() + "\n  Satisfying: " + this.isRunningJVMSatisfying(true) + ", " + this.isRunningJVMSatisfying(false) + "\n  SatisfyingVersion: " + this.isRunningJVMVersionSatisfying() + "\n  SatisfyingJVMArgs: " + this.isRunningJVMArgsSatisfying(true) + ", " + this.isRunningJVMSatisfying(false) + "\n  SatisfyingSecure: " + this.isRunningJVMSatisfying(true) + "\n  Selected JVMParam: " + this.getSelectedJVMParameters() + "\n  Running  JVMParam: " + JVMParameters.getRunningJVMParameters();
    }
}

