/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.ui.rap;

import com.ibm.cic.agent.core.AgentRegistry;
import com.ibm.cic.agent.core.AgentRelaunch;
import com.ibm.cic.common.core.internal.utils.CicParserUtils;
import com.ibm.cic.common.core.utils.ApplicationArguments;
import com.ibm.cic.common.core.utils.FileURLUtil;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.JettyDataKeeper;
import com.ibm.cic.common.ui.internal.licensePanel.BaseEclipseStyleLicensePage;
import com.ibm.cic.common.ui.internal.licensePanel.LicensePart;
import com.ibm.cic.common.ui.internal.wizardry.IWizardBreadCrumbs;
import com.ibm.cic.common.ui.rap.RapAboutDialogService;
import com.ibm.cic.common.ui.rap.RapDirectoryDialogService;
import com.ibm.cic.common.ui.rap.RapFileDialogService;
import com.ibm.cic.common.ui.rap.controls.RapStyledText;
import com.ibm.cic.common.ui.rap.controls.RapWizardBreadcrumbs;
import com.ibm.cic.common.ui.services.IAboutDialogService;
import com.ibm.cic.common.ui.services.IClipboard;
import com.ibm.cic.common.ui.services.IDirectoryDialogService;
import com.ibm.cic.common.ui.services.IFileDialogService;
import com.ibm.cic.common.ui.services.IStyledText;
import com.ibm.cic.common.ui.services.IUiServices;
import com.ibm.cic.common.ui.utils.DisplayKeeper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.client.service.JavaScriptExecutor;
import org.eclipse.rap.rwt.client.service.UrlLauncher;
import org.eclipse.rap.rwt.internal.remote.RemoteObjectLifeCycleAdapter;
import org.eclipse.rap.rwt.service.UISession;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class RapUiServices
implements IUiServices {
    public Image createBackgroundImage(ImageDescriptor descriptor) {
        ImageData data = descriptor.getImageData();
        Image transparent = descriptor.createImage();
        Image image = new Image(transparent.getDevice(), data.width, data.height);
        GC gc = new GC((Drawable)image.getDevice());
        try {
            gc.setBackground(image.getDevice().getSystemColor(1));
            gc.fillRectangle(image.getBounds());
            gc.drawImage(transparent, 0, 0);
            Image image2 = image;
            return image2;
        }
        finally {
            gc.dispose();
            transparent.dispose();
        }
    }

    public boolean launchProgram(String command) {
        try {
            File file = new File(command);
            if (file.exists() && file.isFile()) {
                File parent = file.getParentFile();
                if (command.endsWith(".xml")) {
                    File xslFile = new File(parent, "log.xsl");
                    if (xslFile.exists()) {
                        this.registerFile(command);
                        this.registerFile(xslFile);
                    } else {
                        ArrayList files = new ArrayList();
                        FileUtil.listFiles((File)parent, files);
                        for (File hfile : files) {
                            String relativeName = FileUtil.getRelativePath((File)parent, (File)hfile).replace("\\", "/");
                            this.registerFile(relativeName, hfile);
                        }
                    }
                }
                command = RWT.getResourceManager().getLocation(file.getName());
            } else if (FileURLUtil.isFileLocation((String)command)) {
                command = FileURLUtil.toFileString((String)command);
                command = RWT.getResourceManager().getLocation(this.registerFile(command));
            }
            UrlLauncher launcher = (UrlLauncher)RWT.getClient().getService(UrlLauncher.class);
            launcher.openURL(command);
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    private String registerFile(String path) throws FileNotFoundException, MalformedURLException {
        return this.registerFile(new File(path));
    }

    private String registerFile(File f) throws FileNotFoundException, MalformedURLException {
        if (f.exists()) {
            return this.registerFile(f.getName(), f);
        }
        return null;
    }

    private String registerFile(String name, File f) throws FileNotFoundException, MalformedURLException {
        InputStream is = CicParserUtils.getStreamForURL((URL)f.toURI().toURL());
        RWT.getResourceManager().register(name, is);
        return name;
    }

    public boolean findAndExecuteProgram(String filename, String command) {
        return false;
    }

    public int calculateCompositeHeight(Composite composite) {
        int numberOfLines = 10;
        GC gc = new GC((Drawable)composite);
        gc.setFont(composite.getFont());
        FontMetrics fm = gc.getFontMetrics();
        int height = (fm.getHeight() + fm.getAverageCharWidth()) * numberOfLines;
        gc.dispose();
        return height;
    }

    public LicensePart createLicensePart(BaseEclipseStyleLicensePage parentPage) {
        return new LicensePart(parentPage);
    }

    public IStyledText createStyledText(Composite parent, int style) {
        return new RapStyledText(parent, style);
    }

    public void paintBordersFor(FormToolkit toolkit, Composite composite) {
    }

    public IWizardBreadCrumbs createWizardBreadcrumbs(Composite parent) {
        return new RapWizardBreadcrumbs(parent);
    }

    public void setStyleRange(IStyledText text, int style, int length) {
    }

    public void restartWorkbench() {
        String REFRESH_DELAY = "20000";
        this.executeJavaScript("setTimeout(function(){window.location.reload(true);}," + REFRESH_DELAY + ");");
        RemoteObjectLifeCycleAdapter.render();
        ApplicationArguments.getInstance().restore();
        JettyDataKeeper.INSTANCE.saveBeforeRestart();
        AgentRelaunch relaunch = AgentRelaunch.getInstance();
        File agentDir = AgentRegistry.getInstance().getInstalledAgentLocation();
        File pluginsDir = new File(agentDir, "plugins");
        File webAgentDir = new File(agentDir, "web");
        File configIniDir = new File(webAgentDir, "configuration/config.ini");
        relaunch.setNeedsRelaunch(true);
        relaunch.setRelaunchWithInstalledLauncherIniArguments(webAgentDir, pluginsDir, configIniDir, true);
        DisplayKeeper.INSTANCE.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                PlatformUI.getWorkbench().close();
            }
        });
    }

    public IClipboard createClipboard(Display display) {
        return null;
    }

    public boolean isWebPlatformActive() {
        return true;
    }

    public void openUrlInBrowser(URL url) {
        this.launchProgram(url.toString());
    }

    public void configureSession() {
        RWT.getUISession().getHttpSession().setMaxInactiveInterval(0);
    }

    public Object getServerAttribute(String name) {
        return RWT.getSettingStore().getAttribute(name);
    }

    public void setServerAttribute(String name, String value) throws IOException {
        RWT.getSettingStore().setAttribute(name, value);
    }

    public void sendServerError(int code, String error) {
        try {
            RWT.getResponse().sendError(code, error);
        }
        catch (IOException iOException) {}
    }

    public IDirectoryDialogService getDirectoryDialog(Shell shell) {
        return new RapDirectoryDialogService(shell);
    }

    public IFileDialogService getFileDialog(Shell shell) {
        return new RapFileDialogService(shell);
    }

    public IAboutDialogService getAboutDialog(Shell shell) {
        return new RapAboutDialogService(shell);
    }

    public void killSession(Display display) {
        UISession session = RWT.getUISession((Display)display);
        session.getHttpSession().invalidate();
    }

    public void setWorkbenchWindowTitle(Shell shell, String title) {
        this.executeJavaScript("document.title = \"" + title + "\"");
    }

    private void executeJavaScript(String body) {
        JavaScriptExecutor executor = (JavaScriptExecutor)RWT.getClient().getService(JavaScriptExecutor.class);
        executor.execute(body);
    }
}

