/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.antInstallAdapter.ant;

import com.ibm.cic.agent.core.AbstractVariableSubstitution;
import com.ibm.cic.agent.core.InstallContext;
import com.ibm.cic.agent.core.PerformChildInstallOperation;
import com.ibm.cic.agent.core.antInstallAdapter.Messages;
import com.ibm.cic.agent.core.antInstallAdapter.Util;
import com.ibm.cic.agent.core.antInstallAdapter.ant.AntProgress;
import com.ibm.cic.agent.core.antInstallAdapter.tasks.ProgressEvent;
import com.ibm.cic.agent.core.api.ILogLevel;
import com.ibm.cic.agent.core.commonNativeInstallAdapter.ICommonNativeInstallAdapter;
import com.ibm.cic.common.antAdapterData.ant.AntAntData;
import com.ibm.cic.common.antAdapterData.ant.PropertyAntData;
import com.ibm.cic.common.commonNativeAdapterData.PerformCommonNativeData;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.adapterdata.CommonAdapterData;
import com.ibm.cic.common.core.utils.Encodings;
import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.logging.Logger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.text.MessageFormat;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;

public class AntInstallOperation
extends PerformChildInstallOperation {
    private static final Logger log = Logger.getLogger(AntInstallOperation.class);
    static final String CLASSPATH_SEPARATOR = ";";
    private final AntAntData data;
    private final ICommonNativeInstallAdapter.SupplementaryLogWriter writer;
    private PrintStream ps_antlogfile;
    private File antLogfile = null;

    public AntInstallOperation(int phase, IInstallableUnit unit, InstallContext context, AntAntData data, PerformCommonNativeData performData, ICommonNativeInstallAdapter.SupplementaryLogWriter writer) {
        super(phase, unit, context, performData);
        this.data = data;
        this.writer = writer;
    }

    protected CommonAdapterData getData() {
        return this.data;
    }

    private void init() throws CoreException {
        String logfile;
        if (this.data == null) {
            String msg = Messages.error_no_antData;
            Util.antDebug(msg);
            throw Util.coreException(msg);
        }
        Util.antDebug("phrase=" + this.getPhase());
        Util.antDebug("AntInstallOperation:data:file:" + this.data.getAntFile());
        Util.antDebug("AntInstallOperation:data:desc:" + this.data.getDescription());
        Util.antDebug("AntInstallOperation:data:workdir:" + this.data.getWorkingDirectory());
        Util.antDebug("AntInstallOperation:data.gettime:" + this.data.getApproximateTime());
        Util.antDebug("AntInstallOperation:data.loglevel:" + this.data.getLogLevel());
        Util.antDebug("AntInstallOperation:data.executeTarget:" + this.data.getExecuteTarget());
        Util.antDebug("AntInstallOperation:data.logfile:" + this.data.getLogFile());
        if (this.data.getChildren() != null) {
            Util.antDebug("AntInstallOperation:data.getList:" + this.data.getChildren().length);
        }
        if ((logfile = this.performVariableSubstitutions(this.data.getLogFile())) == null) {
            logfile = this.writer.getFile().getPath();
        } else if (!new File(logfile).isAbsolute()) {
            logfile = String.valueOf(this.getAntWorkingDirectory()) + File.separator + logfile;
        }
        try {
            this.antLogfile = new File(logfile);
            this.ps_antlogfile = Encodings.DEFAULT.toPrintStream((OutputStream)new FileOutputStream(logfile));
        }
        catch (Exception e) {
            Util.antDebug(e.getMessage());
            throw Util.coreException(e, e.getMessage());
        }
    }

    private int getLogLevel() {
        String level = this.data.getLogLevel();
        Util.antDebug(level);
        if (level == null) {
            return 2;
        }
        if ((level = level.trim()).equals("err") || level.equals("0")) {
            return 0;
        }
        if (level.equals("warn") || level.equals("1")) {
            return 1;
        }
        if (level.equals("info") || level.equals("2")) {
            return 2;
        }
        if (level.equals("verbose") || level.equals("3")) {
            return 3;
        }
        if (level.equals("debug") || level.equals("4")) {
            return 4;
        }
        return 2;
    }

    private String getAntWorkingDirectory() throws AbstractVariableSubstitution.VariableSubstitutionException {
        File wdir;
        String workingDirectory = this.data.getWorkingDirectory();
        if (workingDirectory == null || workingDirectory.length() == 0) {
            wdir = new File(this.getInstallContext().getInstallLocation());
        } else {
            String workingDir = this.performVariableSubstitutions(workingDirectory);
            Path p = new Path(workingDir);
            wdir = p.toFile();
            if (!wdir.isAbsolute()) {
                wdir = new File(this.getInstallContext().getInstallLocation(), wdir.getPath());
            }
        }
        String tempWDir = null;
        try {
            tempWDir = wdir.getCanonicalPath();
            Util.antDebug(tempWDir);
        }
        catch (Exception exc) {
            Util.coreException(exc.getMessage());
        }
        return tempWDir;
    }

    private void setProperties(Project p) throws AbstractVariableSubstitution.VariableSubstitutionException {
        PropertyAntData[] props;
        PropertyAntData[] propertyAntDataArray = props = this.data.getProperties();
        int n = props.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyAntData prop = propertyAntDataArray[n2];
            p.setProperty(prop.getPropertyName(), this.performVariableSubstitutions(prop.getPropertyValue(), AbstractVariableSubstitution.AllowAbsolutePath.TRUE));
            ++n2;
        }
    }

    protected IStatus doPerform(IProgressMonitor monitor) throws CoreException {
        this.init();
        String myAntFile = this.performVariableSubstitutions(this.data.getAntFile(), AbstractVariableSubstitution.AllowAbsolutePath.TRUE);
        Util.antDebug("Perform:" + myAntFile);
        String antTaskName = this.performVariableSubstitutions(this.data.getDescription());
        if (antTaskName == null) {
            antTaskName = MessageFormat.format(Messages.invoking_antfile, myAntFile);
        }
        monitor.beginTask(antTaskName, this.data.getApproximateTime());
        monitor.subTask(" ");
        File antAdapterFile = new File(myAntFile);
        if (!antAdapterFile.isAbsolute()) {
            antAdapterFile = new File(this.getAntWorkingDirectory(), antAdapterFile.getPath());
        }
        Util.antDebug(antAdapterFile.getAbsolutePath());
        Project p = new Project();
        p.setUserProperty("ant.file", myAntFile);
        try {
            p.setBasedir(this.getAntWorkingDirectory());
        }
        catch (BuildException be) {
            throw Util.coreException(be, be.getMessage());
        }
        this.setProperties(p);
        AntProgress.getInstance().setMonitor(monitor);
        p.addTaskDefinition(ProgressEvent.getProgressTaskName(), ProgressEvent.class);
        DefaultLogger consoleLogger = new DefaultLogger();
        try {
            consoleLogger.setErrorPrintStream(this.ps_antlogfile);
            consoleLogger.setOutputPrintStream(this.ps_antlogfile);
            consoleLogger.setMessageOutputLevel(this.getLogLevel());
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw Util.coreException(e.getMessage());
        }
        p.addBuildListener((BuildListener)consoleLogger);
        IStatus status = Status.OK_STATUS;
        try {
            try {
                Util.antDebug("monitor the real work");
                p.fireBuildStarted();
                p.init();
                ProjectHelper helper = ProjectHelper.getProjectHelper();
                p.addReference("ant.projectHelper", (Object)helper);
                helper.parse(p, (Object)antAdapterFile);
                if (this.data.getExecuteTarget() != null && this.data.getExecuteTarget().length() > 0) {
                    p.executeTarget(this.data.getExecuteTarget());
                } else {
                    p.executeTarget(p.getDefaultTarget());
                }
                monitor.worked(this.data.getApproximateTime());
            }
            catch (BuildException e) {
                status = Util.getStatus(p, antAdapterFile);
                if (status == null) {
                    ICicStatus innerStatus = e.getLocation() != null ? Statuses.ERROR.get(Messages.AntExceptionOriginalMessage, new Object[]{e.getLocalizedMessage(), e.getLocation().getFileName(), e.getLocation().getLineNumber()}) : Statuses.ERROR.get(e.getLocalizedMessage(), new Object[0]);
                    status = Util.antExceptionStatus((IStatus)innerStatus, antAdapterFile);
                }
                throw new CoreException(status);
            }
            catch (Exception e) {
                status = Statuses.ERROR.get(e.getLocalizedMessage(), new Object[0]);
                throw new CoreException((IStatus)Util.antExceptionStatus(status, antAdapterFile));
            }
        }
        catch (Throwable throwable) {
            if (status == null) {
                status = Status.OK_STATUS;
            }
            if (status.isOK()) {
                this.ps_antlogfile.close();
                p.fireBuildFinished(null);
            } else {
                p.fireBuildFinished(status.getException());
                this.ps_antlogfile.close();
                log.status(status);
            }
            monitor.done();
            if (this.antLogfile.exists()) {
                if (this.antLogfile.length() == 0L) {
                    this.antLogfile.delete();
                } else {
                    try {
                        String href = this.antLogfile.toURI().toURL().toString();
                        String description = antTaskName;
                        if (description == null || description.trim().length() == 0) {
                            description = status.isOK() ? href : MessageFormat.format(Messages.error_see_log, status.getMessage(), href);
                        }
                        switch (status.getSeverity()) {
                            case 4: {
                                log.log(ILogLevel.ERROR, href, description, null);
                                break;
                            }
                            case 2: {
                                log.log(ILogLevel.WARNING, href, description, null);
                                break;
                            }
                            default: {
                                log.log(ILogLevel.INFO, href, description, null);
                                break;
                            }
                        }
                    }
                    catch (MalformedURLException e) {
                        throw Util.coreException(e, e.getMessage());
                    }
                }
            }
            throw throwable;
        }
        if (status == null) {
            status = Status.OK_STATUS;
        }
        if (status.isOK()) {
            this.ps_antlogfile.close();
            p.fireBuildFinished(null);
        } else {
            p.fireBuildFinished(status.getException());
            this.ps_antlogfile.close();
            log.status(status);
        }
        monitor.done();
        if (this.antLogfile.exists()) {
            if (this.antLogfile.length() == 0L) {
                this.antLogfile.delete();
            } else {
                try {
                    String href = this.antLogfile.toURI().toURL().toString();
                    String description = antTaskName;
                    if (description == null || description.trim().length() == 0) {
                        description = status.isOK() ? href : MessageFormat.format(Messages.error_see_log, status.getMessage(), href);
                    }
                    switch (status.getSeverity()) {
                        case 4: {
                            log.log(ILogLevel.ERROR, href, description, null);
                            break;
                        }
                        case 2: {
                            log.log(ILogLevel.WARNING, href, description, null);
                            break;
                        }
                        default: {
                            log.log(ILogLevel.INFO, href, description, null);
                            break;
                        }
                    }
                }
                catch (MalformedURLException e) {
                    throw Util.coreException(e, e.getMessage());
                }
            }
        }
        return status;
    }
}

