/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.commonNativeInstallAdapter;

import com.ibm.cic.agent.core.api.IAgent;
import com.ibm.cic.agent.core.api.IInvokeContext;
import com.ibm.cic.agent.core.api.IProfile;
import com.ibm.cic.agent.core.cmd.CmdLine;
import com.ibm.cic.agent.core.commonNativeInstallAdapter.Invoke;
import com.ibm.cic.agent.core.commonNativeInstallAdapter.Messages;
import com.ibm.cic.common.commonNativeAdapterData.InvokeCommonNativeData;
import com.ibm.cic.common.core.definitions.CommonDef;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.preferences.CicCommonSettings;
import com.ibm.cic.common.core.utils.Encodings;
import com.ibm.cic.common.core.utils.PlatformUtils;
import com.ibm.cic.common.core.utils.UnsupportedOperationException;
import com.ibm.cic.common.core.utils.Util;
import com.ibm.cic.common.logging.LogManager;
import com.ibm.cic.common.logging.Logger;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.osgi.util.NLS;

public class InvokeApplication
implements IApplication {
    private static final String LOGDIR_OPTION = "-logdir";
    private static final Logger log = Logger.getLogger(InvokeApplication.class);
    private static final Integer EXIT_ERROR = 1;

    public Object start(IApplicationContext context) {
        CicCommonSettings.setInstanceArea();
        String[] arguments = (String[])context.getArguments().get("application.args");
        try {
            log.debug("Arguments: {0}", new Object[]{arguments});
            arguments = CmdLine.CL.ignoreArguments(arguments);
            if (arguments.length == 0) {
                throw new ErrorException(Messages.InvokeApplication_Usage, LogManager.getDirectory());
            }
            int n = 0;
            if (arguments[n].equalsIgnoreCase(LOGDIR_OPTION)) {
                File logDir;
                if (arguments.length == ++n) {
                    throw new ErrorException(Messages.InvokeApplication_Missing_Required_Log_Directory, LOGDIR_OPTION);
                }
                if (!(logDir = new File(arguments[n++])).isDirectory()) {
                    throw new ErrorException(Messages.InvokeApplication_Not_A_Directory, logDir);
                }
                LogManager.setDirectory((File)logDir);
                if (arguments.length == n) {
                    throw new ErrorException(Messages.InvokeApplication_Missing_Required_Argument);
                }
            }
            String classname = arguments[n++];
            String[] cp = InvokeApplication.splitClasspath(arguments.length == n ? "" : arguments[n++]);
            File[] classpath = new File[cp.length];
            int i = 0;
            while (i < cp.length) {
                File file = new File(cp[i]);
                if (!file.exists()) {
                    throw new ErrorException(Messages.missing_classpath, file);
                }
                classpath[i] = file;
                ++i;
            }
            String[] args = Util.slice((String[])arguments, (int)n, (int)arguments.length);
            InvokeCommonNativeData data = new InvokeCommonNativeData(classname, "", 0, null);
            Invoke invoke = new Invoke(data, classpath);
            InvokeContext invokeContext = new InvokeContext();
            PrintWriter writer = new PrintWriter(Encodings.DEFAULT.writer((OutputStream)System.out), true);
            invoke.perform(invokeContext, args, "", writer, (IProgressMonitor)new NullProgressMonitor());
            writer.flush();
            return IApplication.EXIT_OK;
        }
        catch (CoreException e) {
            log.status(e.getStatus());
        }
        catch (ErrorException e) {
            log.error(e.getMessage());
        }
        catch (Throwable e) {
            log.error(e);
        }
        PlatformUtils.disableErrorOutput();
        return EXIT_ERROR;
    }

    public void stop() {
    }

    private static String[] splitClasspath(String classpath) {
        return classpath.length() == 0 ? CommonDef.EmptyStringArray : classpath.split(";");
    }

    private static class ErrorException
    extends Exception {
        public ErrorException(String message) {
            super(message);
        }

        public ErrorException(String message, Object arg) {
            super(NLS.bind((String)message, (Object)arg));
        }
    }

    private static class InvokeContext
    implements IInvokeContext {
        private InvokeContext() {
        }

        public IAgent getAgent() {
            throw new UnsupportedOperationException();
        }

        public IProfile getProfile() {
            throw new UnsupportedOperationException();
        }

        public IInstallableUnit getUnit() {
            throw new UnsupportedOperationException();
        }

        public String substituteVariables(String s) {
            throw new UnsupportedOperationException();
        }
    }
}

