/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.commonNativeInstallAdapter;

import com.ibm.cic.agent.core.commonNativeInstallAdapter.IPlatformOperationsProvider;
import com.ibm.cic.agent.core.commonNativeInstallAdapter.Messages;
import com.ibm.cic.agent.core.commonNativeInstallAdapter.PlatformOperationsProvider;
import com.ibm.cic.agent.core.commonNativeInstallAdapter.TempUnzipUtil;
import com.ibm.cic.agent.core.commonNativeInstallAdapter.ZipInstallOperation;
import com.ibm.cic.common.core.preferences.CicCommonSettings;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.PathUtil;
import com.ibm.cic.common.core.utils.SplitProgressMonitor;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.logging.Logger;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class DelayedProcessing {
    private static final Logger log = Logger.getLogger(DelayedProcessing.class);
    HashSet m_delayedProcessingFiles;
    private static HashSet m_delayedFileDeletions = new HashSet();

    public DelayedProcessing(HashSet permittedElements) {
        this.m_delayedProcessingFiles = permittedElements;
    }

    public void moveToDestination(CicMultiStatus result, boolean isUndoable, Object zipSource, TempUnzipUtil.ZipEntryFileMap zipEntryFileMap, File outputDir, String taskName, IProgressMonitor monitor) {
        this.moveToDestination(result, isUndoable, zipSource, zipEntryFileMap, outputDir, null, taskName, monitor);
    }

    public void moveToDestination(CicMultiStatus result, boolean isUndoable, Object zipSource, TempUnzipUtil.ZipEntryFileMap zipEntryFileMap, File outputDir, String perm, String taskName, IProgressMonitor monitor) {
        Collection zipEntryNames = zipEntryFileMap.getNamesInZipFormat();
        SplitProgressMonitor spm = new SplitProgressMonitor(monitor, zipEntryNames.size());
        TreeSet<String> filesToChmod = new TreeSet<String>();
        boolean permInit = this.initUnzipPermissions(zipEntryFileMap, perm);
        Iterator iterator = zipEntryNames.iterator();
        while (iterator.hasNext() && (result.isOK() || !isUndoable)) {
            String zipEntryName = (String)iterator.next();
            File outFile = new File(outputDir, zipEntryName);
            File fileToChmod = perm != null ? this.determineFileForChmod(outputDir, outFile, filesToChmod) : null;
            File file = zipEntryFileMap.getFile(zipEntryName);
            FileOperation fileOp = this.moveFile(result, zipEntryName, file, outFile, spm.next());
            if (fileToChmod == null) continue;
            if (fileToChmod.isDirectory()) {
                String fileToChmodPath = FileUtil.getCanonicalPath((File)fileToChmod);
                if (!fileToChmodPath.endsWith(File.separator)) {
                    fileToChmodPath = String.valueOf(fileToChmodPath) + File.separator;
                }
                filesToChmod.add(fileToChmodPath);
                continue;
            }
            if (permInit && !fileOp.equals((Object)FileOperation.COPIED)) continue;
            filesToChmod.add(FileUtil.getCanonicalPath((File)fileToChmod));
        }
        log.debug("Zip Chmod(): Number of files to chmod " + filesToChmod.size() + " from source " + zipSource.toString());
        if (filesToChmod.size() > 0) {
            FileUtil.chmod((String)perm, (boolean)true, (boolean)false, (String[])filesToChmod.toArray(new String[filesToChmod.size()]));
        }
        if (!result.isOK()) {
            result.setMessage(NLS.bind((String)com.ibm.cic.common.core.utils.Messages.Util_Error_Unzipping, (Object)zipSource, (Object)result.getChildren()[0].getMessage()));
        }
    }

    private boolean initUnzipPermissions(TempUnzipUtil.ZipEntryFileMap zipEntryFileMap, String perm) {
        boolean initialized = true;
        if (perm != null) {
            File tempDir = zipEntryFileMap.getTempDirForUnzip();
            if (zipEntryFileMap.getTempDirForUnzip().isDirectory()) {
                String tempDirPath = FileUtil.getCanonicalPath((File)tempDir);
                tempDirPath = String.valueOf(tempDirPath) + (tempDirPath.endsWith(File.separator) ? "*" : String.valueOf(File.separatorChar) + "*");
                initialized = FileUtil.chmod((String)perm, (boolean)true, (boolean)true, (String)tempDirPath);
                File propFile = zipEntryFileMap.getUnzipPropertiesFile();
                if (initialized && propFile != null) {
                    FileUtil.chmod((String)"u+rwx", (boolean)false, (boolean)false, (String)FileUtil.getCanonicalPath((File)propFile));
                }
            }
        }
        return initialized;
    }

    private File determineFileForChmod(File outputDir, File outFile, TreeSet<String> fileList) {
        return !this.alreadyProccessedForChmod(outFile, fileList) ? this.getFileForChmod(outputDir, outFile) : null;
    }

    private File getFileForChmod(File outputDir, File file) {
        if (FileUtil.filesAreSame((File)outputDir, (File)file)) {
            return null;
        }
        File parentFile = file.getParentFile();
        if (parentFile != null && !parentFile.exists() && !FileUtil.filesAreSame((File)outputDir, (File)parentFile)) {
            return this.getFileForChmod(outputDir, parentFile);
        }
        return !file.isDirectory() ? file : null;
    }

    private boolean alreadyProccessedForChmod(File outFile, TreeSet<String> fileList) {
        String outFilePath = FileUtil.getCanonicalPath((File)outFile);
        boolean alreadyProccessed = false;
        for (String filePath : fileList) {
            if (!outFilePath.startsWith(filePath)) continue;
            alreadyProccessed = true;
            break;
        }
        return alreadyProccessed;
    }

    private FileOperation moveFile(CicMultiStatus result, String zipEntryName, File source, File outFile, IProgressMonitor monitor) {
        FileOperation mvFileOp = FileOperation.MOVED;
        if (zipEntryName.endsWith("/")) {
            IStatus mkdirStatus = FileUtil.makeDirectories((File)outFile);
            result.add(mkdirStatus);
            if (mkdirStatus.matches(4)) {
                mvFileOp = FileOperation.FAILED;
            }
        } else {
            assert (source.isFile());
            IStatus removeStatus = this.removeDestinationFile(outFile, zipEntryName);
            File actualDestination = null;
            switch (removeStatus.getSeverity()) {
                case 0: {
                    actualDestination = outFile;
                    break;
                }
                case 2: {
                    actualDestination = this.handleDeleteAfterReboot(result, outFile);
                    break;
                }
                case 4: {
                    result.add(removeStatus);
                    break;
                }
            }
            if (actualDestination != null) {
                IStatus statusMakeDir = FileUtil.makeDirectories((File)outFile.getParentFile());
                if (statusMakeDir.matches(4)) {
                    result.add(statusMakeDir);
                    mvFileOp = FileOperation.FAILED;
                } else {
                    try {
                        mvFileOp = this.mvTryHard(source, actualDestination, monitor);
                    }
                    catch (IOException e) {
                        String msg = NLS.bind((String)Messages.DelayedProcessing_movingUnpackedFileFailed, (Object)source.getAbsolutePath(), (Object)outFile.getAbsolutePath());
                        result.add((IStatus)Statuses.ERROR.get((Throwable)e, msg, new Object[0]));
                        mvFileOp = FileOperation.FAILED;
                    }
                }
            } else {
                mvFileOp = FileOperation.FAILED;
            }
        }
        return mvFileOp;
    }

    private FileOperation mvTryHard(final File file, final File destination, final IProgressMonitor monitor) throws IOException {
        MvRetryOnIOException retry = new MvRetryOnIOException(log){

            protected void operation() throws IOException {
                this.setMvFileOperationPerformed(DelayedProcessing.this.mv(file, destination, monitor));
            }

            protected String getOperationDebugMessage() {
                return NLS.bind((String)"Moving unpacked file {0} to {1}", (Object)file, (Object)destination);
            }

            protected void logFailedInNoRetryMode(IOException e) {
                String msg = NLS.bind((String)Messages.DelayedProcessing_movingUnpackedFileFailed, (Object)file, (Object)destination);
                log.status((IStatus)Statuses.ERROR.get((Throwable)e, msg, new Object[0]));
            }

            protected void onSucceeded() {
                if (this.getOperationCalledCount() > 1) {
                    ZipInstallOperation.log.note(Messages.DelayedProcessing_movingUnpackedFileSucceededAfterRetries, new Object[]{file, destination, this.getOperationCalledCount() - 1});
                }
            }

            protected boolean shouldRetry(IOException e) {
                String msg;
                long elapsed = this.getElapsedTimeMillis();
                if (elapsed > 20000L) {
                    String msg2 = NLS.bind((String)Messages.DelayedProcessing_movingUnpackedFileFailedAfterRetries, (Object[])new Object[]{file, destination, this.getOperationCalledCount()});
                    log.status((IStatus)Statuses.ERROR.get((Throwable)e, msg2, new Object[0]));
                    return false;
                }
                if (this.getOperationCalledCount() == 1) {
                    msg = NLS.bind((String)Messages.DelayedProcessing_movingUnpackedFileNeedsRetry, (Object[])new Object[]{file, destination, 20});
                    log.status((IStatus)Statuses.WARNING.get((Throwable)e, msg, new Object[0]));
                } else {
                    msg = NLS.bind((String)Messages.DelayedProcessing_movingUnpackedFileFailed, (Object[])new Object[]{file, destination, 20});
                    log.status((IStatus)Statuses.WARNING.get((Throwable)e, msg, new Object[0]));
                }
                System.gc();
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e1) {
                    log.debug((Throwable)e1);
                }
                return true;
            }
        };
        retry.perform();
        return retry.getMvFileOperationPerformed();
    }

    private FileOperation mv(File file, File destination, IProgressMonitor monitor) throws FileNotFoundException, IOException {
        FileOperation fileOp = FileOperation.FAILED;
        if (destination.exists()) {
            FileUtil.rm((File)destination);
        }
        if (file.renameTo(destination)) {
            fileOp = FileOperation.MOVED;
        } else {
            FileUtil.copyFile((File)file, (File)destination, (boolean)true, (IProgressMonitor)monitor);
            destination.setLastModified(file.lastModified());
            FileUtil.rm((File)file);
            fileOp = FileOperation.COPIED;
        }
        return fileOp;
    }

    private File handleDeleteAfterReboot(CicMultiStatus result, File outFile) {
        File actualDestination;
        block6: {
            String msg;
            actualDestination = null;
            try {
                actualDestination = this.createTmpFile(outFile);
            }
            catch (IOException e1) {
                msg = NLS.bind((String)Messages.cant_create_tmp_file_for_afterRebootInstall, (Object)outFile);
                result.add((IStatus)Statuses.ERROR.get((Throwable)e1, msg, new Object[0]));
            }
            if (actualDestination == null) {
                return actualDestination;
            }
            try {
                if (DelayedProcessing.scheduleForDelayedMove(actualDestination, outFile)) break block6;
                String msg2 = NLS.bind((String)Messages.cant_move_file_afterReboot, (Object)actualDestination.getAbsolutePath(), (Object)outFile.getAbsolutePath());
                log.error(msg2);
                result.add(this.createError(msg2));
                return null;
            }
            catch (IOException e) {
                msg = NLS.bind((String)Messages.cant_move_file_afterReboot, (Object)actualDestination.getAbsolutePath(), (Object)outFile.getAbsolutePath());
                log.error(msg);
                result.add((IStatus)Statuses.ERROR.get((Throwable)e, msg, new Object[0]));
                return null;
            }
        }
        log.debug("Scheduled after reboot to move: '{0}' to '{1}'", new Object[]{actualDestination.getAbsolutePath(), outFile.getAbsolutePath()});
        return actualDestination;
    }

    IStatus removeDestinationFile(File a_destination, String relativeFileName) {
        boolean deleted;
        IStatus return_value = Status.OK_STATUS;
        relativeFileName = PathUtil.forwardSlashify((String)relativeFileName);
        if (a_destination.exists() && !(deleted = a_destination.delete())) {
            String fdName = a_destination.getAbsolutePath();
            if (this.m_delayedProcessingFiles.contains(relativeFileName)) {
                if (DelayedProcessing.isFileScheduledForDelayedDeletion(a_destination)) {
                    String msg = String.valueOf(fdName) + " already scheduled for delayed deletion";
                    log.debug(msg);
                    return_value = Statuses.WARNING.get(msg, new Object[0]);
                } else {
                    File toBeDeleted;
                    try {
                        File tmpFile = this.createTmpFile(a_destination);
                        if (DelayedProcessing.fileMove(a_destination, tmpFile)) {
                            toBeDeleted = tmpFile;
                            log.debug("Moved '" + a_destination.getAbsolutePath() + "' to '" + tmpFile.getAbsolutePath() + "'");
                        } else {
                            log.debug("Could not move '" + a_destination.getAbsolutePath() + "' to a tmp location.");
                            tmpFile.delete();
                            return_value = Statuses.WARNING.get("Delete after reboot", new Object[0]);
                            toBeDeleted = a_destination;
                        }
                    }
                    catch (IOException iOException) {
                        toBeDeleted = a_destination;
                    }
                    if (!DelayedProcessing.scheduleForDelayedDeletion(toBeDeleted)) {
                        String msg = NLS.bind((String)Messages.cant_delete_file_afterReboot, (Object)fdName);
                        log.error(msg);
                        return_value = this.createError(msg);
                    } else {
                        log.debug("Scheduled to be deleted after reboot:'" + toBeDeleted.getAbsolutePath() + "'");
                    }
                }
            } else {
                String msg = NLS.bind((String)Messages.cant_delete_file, (Object)fdName);
                log.debug(msg);
                return_value = this.createError(msg);
            }
        }
        return return_value;
    }

    private IStatus createError(String msg) {
        return Statuses.ERROR.get(msg, new Object[0]);
    }

    public static boolean isFileScheduledForDelayedDeletion(File file) {
        return m_delayedFileDeletions.contains(file.getPath());
    }

    public static boolean doneDelayedDeletion(File file) {
        return m_delayedFileDeletions.remove(file.getPath());
    }

    public static boolean scheduleForDelayedDeletion(File file) {
        boolean return_value = false;
        if (CicCommonSettings.isWindows()) {
            try {
                IPlatformOperationsProvider provider = PlatformOperationsProvider.getProvider();
                return_value = provider.deleteAfterReboot(file.getPath());
                if (return_value) {
                    m_delayedFileDeletions.add(file.getPath());
                }
            }
            catch (CoreException e) {
                log.status(e.getStatus());
            }
        }
        return return_value;
    }

    public static boolean scheduleForDelayedMove(File srcName, File dstName) throws IOException {
        boolean return_value = false;
        if (CicCommonSettings.isWindows()) {
            try {
                IPlatformOperationsProvider provider = PlatformOperationsProvider.getProvider();
                return_value = provider.moveAfterReboot(srcName.getCanonicalPath(), dstName.getCanonicalPath());
            }
            catch (CoreException e) {
                log.status(e.getStatus());
            }
        }
        return return_value;
    }

    public static boolean fileMove(File srcName, File dstName) throws IOException {
        boolean return_value = false;
        if (CicCommonSettings.isWindows()) {
            try {
                IPlatformOperationsProvider provider = PlatformOperationsProvider.getProvider();
                return_value = provider.moveFile(srcName.getCanonicalPath(), dstName.getCanonicalPath());
            }
            catch (CoreException e) {
                log.status(e.getStatus());
            }
        }
        return return_value;
    }

    private File createTmpFile(File destination_file) throws IOException {
        File return_value = null;
        if (destination_file.isFile()) {
            File folder = destination_file.getParentFile();
            return_value = File.createTempFile("DP_" + destination_file.getName(), null, folder);
        }
        return return_value;
    }

    private static enum FileOperation {
        MOVED,
        COPIED,
        FAILED;

    }

    private static abstract class MvRetryOnIOException
    extends FileUtil.RetryOnIOException {
        private FileOperation mvFileOp = FileOperation.FAILED;

        public MvRetryOnIOException(Logger log) {
            super(log);
        }

        public void setMvFileOperationPerformed(FileOperation fo) {
            this.mvFileOp = fo;
        }

        public FileOperation getMvFileOperationPerformed() {
            return this.mvFileOp;
        }
    }
}

