/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.utils.commands;

import com.ibm.java.diagnostics.utils.IContext;
import com.ibm.java.diagnostics.utils.commands.BaseCommand;
import com.ibm.java.diagnostics.utils.commands.CommandException;
import com.ibm.java.diagnostics.utils.plugins.PluginConfig;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginCommand
extends BaseCommand {
    private static final String COMMAND_NAME = "plugins";
    private static final String SUBCOMMAND_LIST = "list";
    private static final String SUBCOMMAND_RELOAD = "reload";
    private static final String SUBCOMMAND_SHOWPATH = "showpath";
    private static final String SUBCOMMAND_SETPATH = "setpath";
    private final Map<String, Method> commands = new HashMap<String, Method>();

    public PluginCommand() {
        try {
            this.commands.put(SUBCOMMAND_LIST, this.getClass().getDeclaredMethod("commandListPlugins", String[].class, IContext.class, PrintStream.class));
            this.commands.put(SUBCOMMAND_RELOAD, this.getClass().getDeclaredMethod("commandReload", String[].class, IContext.class, PrintStream.class));
            this.commands.put(SUBCOMMAND_SHOWPATH, this.getClass().getDeclaredMethod("commandShowPath", String[].class, IContext.class, PrintStream.class));
            this.commands.put(SUBCOMMAND_SETPATH, this.getClass().getDeclaredMethod("commandSetPath", String[].class, IContext.class, PrintStream.class));
        }
        catch (Exception e) {
            System.err.println("Error creating command list : " + e.getMessage());
        }
        this.addCommand(COMMAND_NAME, "", "Plugin management commands");
        this.addSubCommand(COMMAND_NAME, SUBCOMMAND_LIST, "", "Show the list of loaded plugins for the current context");
        this.addSubCommand(COMMAND_NAME, SUBCOMMAND_RELOAD, "", "Reload plugins for the current context");
        this.addSubCommand(COMMAND_NAME, SUBCOMMAND_SHOWPATH, "", "Show the DTFJ View plugin search path for the current context");
        this.addSubCommand(COMMAND_NAME, SUBCOMMAND_SETPATH, "", "Set the DTFJ View plugin search path for the current context");
    }

    @Override
    public void run(String command, String[] args, IContext context, PrintStream out) throws CommandException {
        if (args.length == 0) {
            out.println("Error, all plugin commands require one or more parameters");
            return;
        }
        if (args[0].equalsIgnoreCase("help") || args[0].equalsIgnoreCase("?")) {
            out.println("The 'plugins' command can show or set the DTFJ View plugin search path, list the currently loaded plugins and reload them.");
            return;
        }
        if (this.commands.containsKey(args[0])) {
            try {
                this.commands.get(args[0]).invoke((Object)this, args, context, out);
            }
            catch (Exception e) {
                out.println("Error executing command " + e.getMessage());
            }
        } else {
            out.println("plugins " + command + " was not recognised, run " + COMMAND_NAME + " " + SUBCOMMAND_LIST + " to see all available options");
        }
    }

    private void commandListPlugins(String[] args, IContext context, PrintStream out) throws CommandException {
        boolean csv = false;
        if (args.length >= 2) {
            csv = args[1].equalsIgnoreCase("csv");
            out.println("id,vmversion,enabled,path,modified,exception");
        }
        if (context.getPluginClassloader() == null) {
            out.println("No plugins are currently loaded");
            return;
        }
        ArrayList<PluginConfig> plugins = context.getPluginClassloader().getPlugins();
        ArrayList<PluginConfig> pluginFailures = context.getPluginClassloader().getPluginFailures();
        if (plugins.size() == 0 && pluginFailures.size() == 0 && !csv) {
            out.println("No plugins are currently loaded");
            return;
        }
        this.printPlugins("Loaded plugins", plugins, out, csv);
        this.printPlugins("Failed plugins", pluginFailures, out, csv);
    }

    private void printPlugins(String msg, ArrayList<PluginConfig> plugins, PrintStream out, boolean csv) {
        if (!csv) {
            out.println(msg);
        }
        if (plugins.size() == 0 && !csv) {
            out.println("\t<none>");
            return;
        }
        for (PluginConfig plugin : plugins) {
            if (csv) {
                out.println(plugin.toCSV());
                continue;
            }
            out.println("\t" + plugin.getId());
        }
    }

    private void commandShowPath(String[] args, IContext context, PrintStream out) {
        String path = System.getProperty("com.ibm.java.diagnostics.plugins");
        path = null == path ? "<<warning : no dtfj plugin path has been defined>>" : path + String.format(" (set from system property %s)", "com.ibm.java.diagnostics.plugins");
        out.println("DTFJ View Plugin search path : " + path);
    }

    private void commandSetPath(String[] args, IContext context, PrintStream out) {
        if (args.length != 2) {
            out.println("The setpath option only takes a single parameter of the search path");
            return;
        }
        System.getProperties().setProperty("com.ibm.java.diagnostics.plugins", args[1]);
        out.println("DTFJ View Plugin search path set to : " + args[1]);
        out.println("Execute plugins reload to scan this path for plugins");
    }

    private void commandReload(String[] args, IContext context, PrintStream out) {
        context.refresh();
        out.println("Plugins reloaded");
    }
}

