/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.javacore.parser.j9.section.platform;

import com.ibm.dtfj.javacore.parser.framework.tag.LineRule;
import com.ibm.dtfj.javacore.parser.framework.tag.TagParser;
import com.ibm.dtfj.javacore.parser.j9.section.common.CommonPatternMatchers;
import com.ibm.dtfj.javacore.parser.j9.section.platform.IPlatformTypes;
import com.ibm.dtfj.javacore.parser.j9.section.platform.PlatformPatternMatchers;
import java.util.regex.Matcher;

public class PlatformTagParser
extends TagParser
implements IPlatformTypes {
    private static final Matcher NOT_EQUALS = CommonPatternMatchers.generateMatcher("[^\\n\\r][^=\\n\\r]*", 2);

    public PlatformTagParser() {
        super("GPINFO");
    }

    protected void initTagAttributeRules() {
        this.addHostName();
        this.addOSLevel();
        this.addTag("2XHCPUS", null);
        this.addCPUArch();
        this.addCPUCount();
        this.addExceptionCodeRule();
        this.addTag("1XHERROR2", null);
        this.addExceptionModuleRule();
        this.addRegisterRule();
        this.addEnvironmentVars();
    }

    private void addHostName() {
        LineRule lineRule = new LineRule(){

            public void processLine(String source, int startingOffset) {
                this.consumeUntilFirstMatch(CommonPatternMatchers.colon);
                this.consumeUntilFirstMatch(CommonPatternMatchers.whitespace);
                this.addAllCharactersAsTokenAndConsumeFirstMatch("platform_host_name", CommonPatternMatchers.colon);
                this.addToken("platform_host_addr", CommonPatternMatchers.allButLineFeed);
            }
        };
        this.addTag("2XHHOSTNAME", lineRule);
    }

    private void addOSLevel() {
        LineRule lineRule = new LineRule(){

            public void processLine(String source, int startingOffset) {
                this.consumeUntilFirstMatch(CommonPatternMatchers.colon);
                if (this.findFirst(PlatformPatternMatchers.Windows_XP)) {
                    this.addToken("platform_os_name", PlatformPatternMatchers.Windows_XP);
                } else if (this.findFirst(PlatformPatternMatchers.Windows_Server_2003)) {
                    this.addToken("platform_os_name", PlatformPatternMatchers.Windows_Server_2003);
                } else if (this.findFirst(PlatformPatternMatchers.Windows_Server_2008)) {
                    this.addToken("platform_os_name", PlatformPatternMatchers.Windows_Server_2008);
                } else if (this.findFirst(PlatformPatternMatchers.Windows_2000)) {
                    this.addToken("platform_os_name", PlatformPatternMatchers.Windows_2000);
                } else if (this.findFirst(PlatformPatternMatchers.Windows_Vista)) {
                    this.addToken("platform_os_name", PlatformPatternMatchers.Windows_Vista);
                } else if (this.findFirst(PlatformPatternMatchers.Windows_7)) {
                    this.addToken("platform_os_name", PlatformPatternMatchers.Windows_7);
                } else if (this.findFirst(PlatformPatternMatchers.Windows_8)) {
                    this.addToken("platform_os_name", PlatformPatternMatchers.Windows_8);
                } else if (this.findFirst(PlatformPatternMatchers.Windows_Server_8)) {
                    this.addToken("platform_os_name", PlatformPatternMatchers.Windows_Server_8);
                } else if (this.findFirst(PlatformPatternMatchers.Windows_Generic)) {
                    this.addToken("platform_os_name", PlatformPatternMatchers.Windows_Generic);
                } else if (this.findFirst(PlatformPatternMatchers.Linux)) {
                    this.addToken("platform_os_name", PlatformPatternMatchers.Linux);
                } else if (this.findFirst(PlatformPatternMatchers.AIX)) {
                    this.addToken("platform_os_name", PlatformPatternMatchers.AIX);
                } else if (this.findFirst(PlatformPatternMatchers.z_OS)) {
                    this.addToken("platform_os_name", PlatformPatternMatchers.z_OS);
                }
                this.consumeUntilFirstMatch(CommonPatternMatchers.whitespace);
                this.addToken("platform_os_version", CommonPatternMatchers.allButLineFeed);
            }
        };
        this.addTag("2XHOSLEVEL", lineRule);
    }

    private void addCPUArch() {
        LineRule lineRule = new LineRule(){

            public void processLine(String source, int startingOffset) {
                this.consumeUntilFirstMatch(CommonPatternMatchers.colon);
                this.consumeUntilFirstMatch(CommonPatternMatchers.whitespace);
                this.addToken("platform_cpu_arch", CommonPatternMatchers.allButLineFeed);
            }
        };
        this.addTag("3XHCPUARCH", lineRule);
    }

    private void addCPUCount() {
        LineRule lineRule = new LineRule(){

            public void processLine(String source, int startingOffset) {
                this.consumeUntilFirstMatch(CommonPatternMatchers.colon);
                this.addToken("platform_cpu_count", CommonPatternMatchers.dec);
            }
        };
        this.addTag("3XHNUMCPUS", lineRule);
        this.addTag("3XHNUMASUP", null);
    }

    private void addExceptionCodeRule() {
        LineRule lineRule = new LineRule(){

            public void processLine(String source, int startingOffset) {
                if (this.findFirst(PlatformPatternMatchers.J9Signal_1)) {
                    this.consumeUntilFirstMatch(PlatformPatternMatchers.J9Signal_1);
                    this.addNonPrefixedHexToken("platform_signal");
                } else if (this.findFirst(PlatformPatternMatchers.J9Signal_2)) {
                    this.consumeUntilFirstMatch(PlatformPatternMatchers.J9Signal_2);
                    this.addNonPrefixedHexToken("platform_signal");
                }
            }
        };
        this.addTag("1XHEXCPCODE", lineRule);
    }

    private void addExceptionModuleRule() {
        LineRule lineRule = new LineRule(){

            public void processLine(String source, int startingOffset) {
                if (this.findFirst(PlatformPatternMatchers.Module)) {
                    this.consumeUntilFirstMatch(PlatformPatternMatchers.Module);
                    this.consumeUntilFirstMatch(CommonPatternMatchers.whitespace);
                    this.addToken("platform_module_name", CommonPatternMatchers.allButLineFeed);
                } else if (this.findFirst(PlatformPatternMatchers.Module_base)) {
                    this.consumeUntilFirstMatch(PlatformPatternMatchers.Module_base);
                    this.addNonPrefixedHexToken("platform_module_base");
                } else if (this.findFirst(PlatformPatternMatchers.Module_offset)) {
                    this.consumeUntilFirstMatch(PlatformPatternMatchers.Module_offset);
                    this.addNonPrefixedHexToken("platform_module_offset");
                }
            }
        };
        this.addTag("1XHEXCPMODULE", lineRule);
    }

    private void addRegisterRule() {
        this.addTag("1XHREGISTERS", new LineRule(){

            public void processLine(String source, int startingOffset) {
            }
        });
        LineRule lineRule = new LineRule(){

            public void processLine(String source, int startingOffset) {
                this.consumeUntilFirstMatch(CommonPatternMatchers.whitespace);
                this.addAllCharactersAsTokenAndConsumeFirstMatch("platform_register_name", CommonPatternMatchers.colon);
                this.addNonPrefixedHexToken("platform_register_value");
            }
        };
        this.addTag("2XHREGISTER", lineRule);
    }

    private void addEnvironmentVars() {
        this.addTag("1XHENVVARS", new LineRule(){

            public void processLine(String source, int startingOffset) {
            }
        });
        LineRule lineRule = new LineRule(){

            public void processLine(String source, int startingOffset) {
                this.consumeUntilFirstMatch(CommonPatternMatchers.whitespace);
                this.addToken("environment_variable_name", NOT_EQUALS);
                this.consumeUntilFirstMatch(CommonPatternMatchers.equals);
                this.addToken("environment_variable_value", CommonPatternMatchers.allButLineFeed);
            }
        };
        this.addTag("1XHENVVAR", lineRule);
    }
}

