/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.image.j9;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImageModule;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.ImageProcess;
import com.ibm.dtfj.image.j9.CorruptData;
import com.ibm.dtfj.image.j9.ImageAddressSpace;
import com.ibm.dtfj.image.j9.ImageSymbol;
import java.util.Iterator;

public class ImageStackFrame
implements com.ibm.dtfj.image.ImageStackFrame {
    private ImageAddressSpace _space;
    private String _procedureName = null;
    private ImagePointer _procedureAddress;
    private ImagePointer _basePointer;

    public ImageStackFrame(ImageAddressSpace space, ImagePointer procedureAddress, ImagePointer basePointer) {
        this._space = space;
        this._procedureAddress = procedureAddress;
        this._basePointer = basePointer;
    }

    public ImagePointer getProcedureAddress() throws CorruptDataException {
        return this._procedureAddress;
    }

    public ImagePointer getBasePointer() throws CorruptDataException {
        return this._basePointer;
    }

    public String getProcedureName() throws CorruptDataException {
        if (null == this._procedureName) {
            ImageModule bestModule = null;
            ImageSymbol bestClosest = null;
            long bestDelta = Long.MAX_VALUE;
            Iterator i = this._space.getProcesses();
            while (i.hasNext()) {
                Object nexti = i.next();
                if (nexti instanceof CorruptData) continue;
                ImageProcess process = (ImageProcess)nexti;
                if (this._procedureAddress.getAddress() == (1L << process.getPointerSize()) - 1L) continue;
                try {
                    ImageModule module = process.getExecutable();
                    ImageSymbol closest = this.getClosestSymbolFrom(module);
                    long delta = this.getDelta(module, closest);
                    if (delta >= 0L && delta < bestDelta) {
                        bestModule = module;
                        bestClosest = closest;
                        bestDelta = delta;
                    }
                }
                catch (DataUnavailable e) {
                }
                catch (CorruptDataException e) {
                    // empty catch block
                }
                try {
                    Iterator j = process.getLibraries();
                    while (j.hasNext()) {
                        ImageSymbol closest;
                        ImageModule module;
                        long delta;
                        Object next = j.next();
                        if (next instanceof CorruptData || (delta = this.getDelta(module = (ImageModule)next, closest = this.getClosestSymbolFrom(module))) < 0L || delta >= bestDelta) continue;
                        bestModule = module;
                        bestClosest = closest;
                        bestDelta = delta;
                    }
                }
                catch (DataUnavailable e) {
                }
                catch (CorruptDataException e) {
                }
            }
            ImageSymbol closest = bestClosest;
            ImageModule module = bestModule;
            long delta = bestDelta;
            if (null != module) {
                String deltaString = "";
                deltaString = delta == Long.MAX_VALUE ? "<offset not available>" : (delta >= 0L ? "+0x" + Long.toHexString(delta) : "-0x" + Long.toHexString(delta));
                this._procedureName = null != closest ? module.getName() + "::" + closest.getName() + deltaString : module.getName() + deltaString;
            }
        }
        if (null == this._procedureName) {
            this._procedureName = "<unknown location>";
        }
        return this._procedureName;
    }

    private long getDelta(ImageModule module, ImageSymbol closest) throws CorruptDataException {
        long delta = 0L;
        if (closest != null) {
            delta = this.getProcedureAddress().getAddress() - closest.getAddress().getAddress();
        } else {
            try {
                delta = this.getProcedureAddress().getAddress() - ((com.ibm.dtfj.image.j9.ImageModule)module).getLoadAddress();
            }
            catch (DataUnavailable e) {
                delta = Long.MAX_VALUE;
            }
        }
        return delta;
    }

    private ImageSymbol getClosestSymbolFrom(ImageModule module) {
        long pc = this._procedureAddress.getAddress();
        long maxDifference = Long.MAX_VALUE;
        ImageSymbol closestSymbol = null;
        Iterator iter = module.getSymbols();
        while (iter.hasNext()) {
            ImageSymbol currentSymbol;
            long symbolAddress;
            Object next = iter.next();
            if (next instanceof CorruptData || (symbolAddress = (currentSymbol = (ImageSymbol)next).getAddress().getAddress()) > pc || pc - symbolAddress >= maxDifference) continue;
            maxDifference = pc - symbolAddress;
            closestSymbol = currentSymbol;
        }
        return closestSymbol;
    }
}

