/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.corereaders.j9;

import com.ibm.dtfj.corereaders.MemoryAccessException;
import com.ibm.dtfj.corereaders.j9.J9RASFragment;
import com.ibm.dtfj.corereaders.j9.J9RASFragmentJ5GA;
import com.ibm.dtfj.corereaders.j9.J9RASFragmentJ5SR10;
import com.ibm.dtfj.corereaders.j9.J9RASFragmentJ5v2;
import com.ibm.dtfj.corereaders.j9.J9RASFragmentJ6GA;
import com.ibm.dtfj.corereaders.j9.J9RASFragmentJ6SR6;
import com.ibm.dtfj.corereaders.j9.J9RASFragmentJ6v2;
import com.ibm.dtfj.corereaders.j9.J9RASFragmentJ6v3;
import com.ibm.dtfj.corereaders.j9.Memory;

public class J9RAS
implements J9RASFragment {
    public static final String J9RAS_EYECATCHER = "J9VMRAS\u0000";
    public static final byte[] J9RAS_EYECATCHER_BYTES = "J9VMRAS\u0000".getBytes();
    public static final long INTEGRITY_CHECK = -6172840429334713771L;
    private long address = -2401053089480183795L;
    private long integrity = 0L;
    private int version = -1;
    private int length = -1;
    private boolean valid = false;
    private J9RASFragment fragment = null;
    private Memory memory = null;

    public J9RAS(Memory memory, long address) throws MemoryAccessException {
        this.address = address;
        this.integrity = memory.getLongAt(address + 8L);
        boolean bl = this.valid = this.integrity == -6172840429334713771L;
        if (this.valid) {
            this.processStructure(memory);
            this.memory = memory;
        }
    }

    private void processStructure(Memory memory) throws MemoryAccessException {
        this.version = memory.getIntAt(this.address + 16L);
        this.length = memory.getIntAt(this.address + 20L);
        if (memory.bytesPerPointer() == 4) {
            this.process32bitStructure(memory);
        } else {
            this.process64bitStructure(memory);
        }
    }

    private void process64bitStructure(Memory memory) throws MemoryAccessException {
        this.fragment = this.length < 608 ? (this.version >= 131072 ? new J9RASFragmentJ5v2(memory, this.address, true) : (this.length == 344 ? new J9RASFragmentJ5SR10(memory, this.address, true) : new J9RASFragmentJ5GA())) : (this.version >= 196608 ? new J9RASFragmentJ6v3(memory, this.address, true) : (this.version >= 131072 ? new J9RASFragmentJ6v2(memory, this.address, true) : (this.length == 632 ? new J9RASFragmentJ6SR6(memory, this.address, true) : new J9RASFragmentJ6GA())));
    }

    private void process32bitStructure(Memory memory) throws MemoryAccessException {
        this.fragment = this.length < 568 ? (this.version >= 131072 ? new J9RASFragmentJ5v2(memory, this.address, false) : (this.length == 288 ? new J9RASFragmentJ5SR10(memory, this.address, false) : new J9RASFragmentJ5GA())) : (this.version >= 196608 ? new J9RASFragmentJ6v3(memory, this.address, false) : (this.version >= 131072 ? new J9RASFragmentJ6v2(memory, this.address, false) : (this.length == 576 ? new J9RASFragmentJ6SR6(memory, this.address, false) : new J9RASFragmentJ6GA())));
    }

    public boolean isValid() {
        return this.valid;
    }

    public int getVersion() {
        return this.version;
    }

    public int getLength() {
        return this.length;
    }

    public long getAddress() {
        return this.address;
    }

    public boolean equals(Object obj) {
        if (obj instanceof J9RAS) {
            J9RAS ras = (J9RAS)obj;
            return ras.address == this.address && ras.memory.equals(this.memory);
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return "J9RAS @0x" + Long.toHexString(this.address) + " length " + this.length + " version " + this.version;
    }

    public boolean currentThreadSupported() {
        if (this.fragment == null) {
            return false;
        }
        return this.fragment.currentThreadSupported();
    }

    public long getPID() {
        if (this.valid && this.fragment != null) {
            return this.fragment.getPID();
        }
        throw new UnsupportedOperationException("Get PID() is not supported as this is not a valid J9RAS structure");
    }

    public long getTID() {
        if (this.valid && this.fragment != null) {
            return this.fragment.getTID();
        }
        throw new UnsupportedOperationException("Get TID() is not supported as this is not a valid J9RAS structure");
    }
}

