/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.net.rdma.jverbs.verbs;

import com.ibm.net.rdma.jverbs.verbs.RdmaJVerbs;
import com.ibm.net.rdma.jverbs.verbs.VerbsContext;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class Device {
    protected NodeType ibvNodeType;
    protected TransportType ibvTransportType;
    protected String name;
    protected String deviceName;
    protected String devPath;
    protected String ibvdevPath;
    protected RdmaJVerbs verbs = RdmaJVerbs.open();
    protected VerbsContext context;

    protected Device() throws IOException {
    }

    public String getName() {
        return this.name;
    }

    public String getDevName() {
        return this.deviceName;
    }

    public String getDevicePath() {
        return this.devPath;
    }

    public String getIbvDevicePath() {
        return this.ibvdevPath;
    }

    public NodeType getNodeType() {
        return this.ibvNodeType;
    }

    public TransportType getTransportType() {
        return this.ibvTransportType;
    }

    public String getDeviceName() throws IOException {
        return this.verbs.getDeviceName(this);
    }

    public long getDeviceGuid() throws IOException {
        return this.verbs.getDeviceGuid(this);
    }

    public VerbsContext getContext() {
        return this.context;
    }

    public static enum TransportType {
        IBV_TRANSPORT_UNKNOWN(-1),
        IBV_TRANSPORT_IB(0),
        IBV_TRANSPORT_IWARP(1);

        private int value;
        private static final Map<Integer, TransportType> IBV_TRANSPORT_TYPE_MAP;

        private TransportType(int n2) {
            this.value = n2;
        }

        public static TransportType getEnumFromValue(int n) {
            return IBV_TRANSPORT_TYPE_MAP.get(n);
        }

        public int getValue() {
            return this.value;
        }

        static {
            IBV_TRANSPORT_TYPE_MAP = new HashMap<Integer, TransportType>();
            for (TransportType transportType : TransportType.values()) {
                IBV_TRANSPORT_TYPE_MAP.put(transportType.value, transportType);
            }
        }
    }

    public static enum NodeType {
        IBV_NODE_UNKNOWN(-1),
        IBV_NODE_CA(1),
        IBV_NODE_SWITCH(2),
        IBV_NODE_ROUTER(3),
        IBV_NODE_RNIC(4);

        private int value;
        private static final Map<Integer, NodeType> IBV_NODE_TYPE_MAP;

        private NodeType(int n2) {
            this.value = n2;
        }

        public static NodeType getEnumFromValue(int n) {
            return IBV_NODE_TYPE_MAP.get(n);
        }

        public int getValue() {
            return this.value;
        }

        static {
            IBV_NODE_TYPE_MAP = new HashMap<Integer, NodeType>();
            for (NodeType nodeType : NodeType.values()) {
                IBV_NODE_TYPE_MAP.put(nodeType.value, nodeType);
            }
        }
    }
}

