/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.net.rdma.jverbs.cm;

import com.ibm.net.rdma.jverbs.cm.EndianUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

class NetUtils {
    private static final boolean nativeIsNetwork = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;

    private NetUtils() {
    }

    public static int getIntIPFromName(String string) throws UnknownHostException {
        InetAddress inetAddress = InetAddress.getByName(string);
        byte[] byArray = inetAddress.getAddress();
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.clear();
        return byteBuffer.getInt();
    }

    public static int getIntIPFromInetAddress(InetAddress inetAddress) throws UnknownHostException {
        byte[] byArray = inetAddress.getAddress();
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.clear();
        return byteBuffer.getInt();
    }

    public static InetAddress getInetAddressFromIntIP(int n) throws UnknownHostException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.putInt(n);
        byteBuffer.clear();
        byte[] byArray = new byte[4];
        byteBuffer.get(byArray);
        InetAddress inetAddress = InetAddress.getByAddress(byArray);
        return inetAddress;
    }

    public static short hostToNetworkByteOrder(short s) {
        if (nativeIsNetwork) {
            return s;
        }
        return EndianUtils.swap(s);
    }

    public static char hostToNetworkByteOrder(char c) {
        if (nativeIsNetwork) {
            return c;
        }
        return EndianUtils.swap(c);
    }

    public static int hostToNetworkByteOrder(int n) {
        if (nativeIsNetwork) {
            return n;
        }
        return EndianUtils.swap(n);
    }

    public static long hostToNetworkByteOrder(long l) {
        if (nativeIsNetwork) {
            return l;
        }
        return EndianUtils.swap(l);
    }

    public static short networkToHostByteOrder(short s) {
        if (nativeIsNetwork) {
            return s;
        }
        return EndianUtils.swap(s);
    }

    public static char networkToHostByteOrder(char c) {
        if (nativeIsNetwork) {
            return c;
        }
        return EndianUtils.swap(c);
    }

    public static int networkToHostByteOrder(int n) {
        if (nativeIsNetwork) {
            return n;
        }
        return EndianUtils.swap(n);
    }

    public static long networkToHostByteOrder(long l) {
        if (nativeIsNetwork) {
            return l;
        }
        return EndianUtils.swap(l);
    }

    public static int getIntIPFromInetAddress(String string) {
        return 0;
    }
}

