/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Map;
import java.util.Vector;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;
import sun.security.ssl.Debug;
import sun.security.ssl.SSLSessionImpl;
import sun.security.ssl.SessionId;
import sun.security.util.Cache;

final class SSLSessionContextImpl
implements SSLSessionContext {
    private Cache sessionCache;
    private Cache sessionHostPortCache;
    private int cacheLimit = this.getDefaultCacheLimit();
    private int timeout = 86400;
    private static final Debug debug = Debug.getInstance("ssl");

    SSLSessionContextImpl() {
        this.sessionCache = Cache.newSoftMemoryCache(this.cacheLimit, this.timeout);
        this.sessionHostPortCache = Cache.newSoftMemoryCache(this.cacheLimit, this.timeout);
    }

    @Override
    public SSLSession getSession(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException("session id cannot be null");
        }
        SSLSessionImpl sSLSessionImpl = (SSLSessionImpl)this.sessionCache.get(new SessionId(byArray));
        if (!this.isTimedout(sSLSessionImpl)) {
            return sSLSessionImpl;
        }
        return null;
    }

    @Override
    public Enumeration<byte[]> getIds() {
        SessionCacheVisitor sessionCacheVisitor = new SessionCacheVisitor();
        this.sessionCache.accept(sessionCacheVisitor);
        return sessionCacheVisitor.getSessionIds();
    }

    @Override
    public void setSessionTimeout(int n) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (this.timeout != n) {
            this.sessionCache.setTimeout(n);
            this.sessionHostPortCache.setTimeout(n);
            this.timeout = n;
        }
    }

    @Override
    public int getSessionTimeout() {
        return this.timeout;
    }

    @Override
    public void setSessionCacheSize(int n) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (this.cacheLimit != n) {
            this.sessionCache.setCapacity(n);
            this.sessionHostPortCache.setCapacity(n);
            this.cacheLimit = n;
        }
    }

    @Override
    public int getSessionCacheSize() {
        return this.cacheLimit;
    }

    SSLSessionImpl get(byte[] byArray) {
        return (SSLSessionImpl)this.getSession(byArray);
    }

    SSLSessionImpl get(String string, int n) {
        if (string == null && n == -1) {
            return null;
        }
        SSLSessionImpl sSLSessionImpl = (SSLSessionImpl)this.sessionHostPortCache.get(this.getKey(string, n));
        if (!this.isTimedout(sSLSessionImpl)) {
            return sSLSessionImpl;
        }
        return null;
    }

    private String getKey(String string, int n) {
        return (string + ":" + String.valueOf(n)).toLowerCase();
    }

    void put(SSLSessionImpl sSLSessionImpl) {
        this.sessionCache.put(sSLSessionImpl.getSessionId(), sSLSessionImpl);
        if (sSLSessionImpl.getPeerHost() != null && sSLSessionImpl.getPeerPort() != -1) {
            this.sessionHostPortCache.put(this.getKey(sSLSessionImpl.getPeerHost(), sSLSessionImpl.getPeerPort()), sSLSessionImpl);
        }
        sSLSessionImpl.setContext(this);
    }

    void remove(SessionId sessionId) {
        SSLSessionImpl sSLSessionImpl = (SSLSessionImpl)this.sessionCache.get(sessionId);
        if (sSLSessionImpl != null) {
            this.sessionCache.remove(sessionId);
            this.sessionHostPortCache.remove(this.getKey(sSLSessionImpl.getPeerHost(), sSLSessionImpl.getPeerPort()));
        }
    }

    private int getDefaultCacheLimit() {
        int n = 0;
        try {
            String string = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty("javax.net.ssl.sessionCacheSize");
                }
            });
            n = string != null ? Integer.valueOf(string) : 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n > 0 ? n : 0;
    }

    boolean isTimedout(SSLSession sSLSession) {
        if (this.timeout == 0) {
            return false;
        }
        if (sSLSession != null && sSLSession.getCreationTime() + (long)this.timeout * 1000L <= System.currentTimeMillis()) {
            sSLSession.invalidate();
            return true;
        }
        return false;
    }

    final class SessionCacheVisitor
    implements Cache.CacheVisitor {
        Vector<byte[]> ids = null;

        SessionCacheVisitor() {
        }

        @Override
        public void visit(Map<Object, Object> map) {
            this.ids = new Vector(map.size());
            for (Object object : map.keySet()) {
                SSLSessionImpl sSLSessionImpl = (SSLSessionImpl)map.get(object);
                if (SSLSessionContextImpl.this.isTimedout(sSLSessionImpl)) continue;
                this.ids.addElement(((SessionId)object).getId());
            }
        }

        public Enumeration<byte[]> getSessionIds() {
            return this.ids != null ? this.ids.elements() : new Vector().elements();
        }
    }
}

