/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs;

import com.ibm.bidiTools.bdlayout.BidiConvert;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.security.AccessController;
import sun.misc.VM;
import sun.nio.cs.Surrogate;
import sun.security.action.GetPropertyAction;

class UTF8_Encoder
extends CharsetEncoder {
    private Surrogate.Parser sgp;
    private final int flags;
    private String bidiParms;
    private boolean bidiEnabled = false;
    private static String bidiInit;
    private static boolean UseBuffer;
    private String csName = null;

    protected UTF8_Encoder(Charset charset, int n) {
        super(charset, 1.1f, 3.0f);
        this.flags = n;
        this.csName = charset.name();
        this.bidiParms = bidiInit;
        if (null == this.bidiParms) {
            if (VM.isBooted()) {
                this.bidiParms = System.getSecurityManager() == null ? new GetPropertyAction("JAVABIDI").run() : AccessController.doPrivileged(new GetPropertyAction("JAVABIDI"));
                if (null == this.bidiParms) {
                    this.bidiParms = "NO";
                }
                bidiInit = this.bidiParms;
            } else {
                this.bidiParms = "NO";
            }
        }
        this.bidiEnabled = !"NO".equals(this.bidiParms);
    }

    @Override
    public boolean isLegalReplacement(byte[] byArray) {
        return byArray.length == 1 && byArray[0] >= 0 || super.isLegalReplacement(byArray);
    }

    private static CoderResult overflow(CharBuffer charBuffer, int n, ByteBuffer byteBuffer, int n2) {
        UTF8_Encoder.updatePositions(charBuffer, n, byteBuffer, n2);
        return CoderResult.OVERFLOW;
    }

    private static CoderResult overflow(CharBuffer charBuffer, int n) {
        charBuffer.position(n);
        return CoderResult.OVERFLOW;
    }

    static final void updatePositions(Buffer buffer, int n, Buffer buffer2, int n2) {
        buffer.position(n - buffer.arrayOffset());
        buffer2.position(n2 - buffer2.arrayOffset());
    }

    @Override
    public boolean canEncode(char c) {
        if ((this.flags & 6) != 0) {
            return true;
        }
        return !Surrogate.is(c);
    }

    private CoderResult encodeArrayLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        char[] cArray = charBuffer.array();
        int n = charBuffer.arrayOffset() + charBuffer.position();
        int n2 = charBuffer.arrayOffset() + charBuffer.limit();
        byte[] byArray = byteBuffer.array();
        int n3 = byteBuffer.arrayOffset() + byteBuffer.position();
        int n4 = byteBuffer.arrayOffset() + byteBuffer.limit();
        int n5 = n3 + Math.min(n2 - n, n4 - n3);
        while (n3 < n5 && cArray[n] < '\u0080') {
            byArray[n3++] = (byte)cArray[n++];
        }
        while (n < n2) {
            char c = cArray[n];
            if (c < '\u0080') {
                if (n3 >= n4) {
                    return UTF8_Encoder.overflow(charBuffer, n, byteBuffer, n3);
                }
                byArray[n3++] = (byte)c;
            } else if (c < '\u0800') {
                if (n4 - n3 < 2) {
                    return UTF8_Encoder.overflow(charBuffer, n, byteBuffer, n3);
                }
                byArray[n3++] = (byte)(0xC0 | c >> 6);
                byArray[n3++] = (byte)(0x80 | c & 0x3F);
            } else if (Surrogate.is(c)) {
                int n6;
                if (this.sgp == null) {
                    this.sgp = new Surrogate.Parser();
                }
                if ((n6 = this.sgp.parse(c, cArray, n, n2)) < 0) {
                    UTF8_Encoder.updatePositions(charBuffer, n, byteBuffer, n3);
                    return this.sgp.error();
                }
                if (n4 - n3 < 4) {
                    return UTF8_Encoder.overflow(charBuffer, n, byteBuffer, n3);
                }
                byArray[n3++] = (byte)(0xF0 | n6 >> 18);
                byArray[n3++] = (byte)(0x80 | n6 >> 12 & 0x3F);
                byArray[n3++] = (byte)(0x80 | n6 >> 6 & 0x3F);
                byArray[n3++] = (byte)(0x80 | n6 & 0x3F);
                ++n;
            } else {
                if (n4 - n3 < 3) {
                    return UTF8_Encoder.overflow(charBuffer, n, byteBuffer, n3);
                }
                byArray[n3++] = (byte)(0xE0 | c >> 12);
                byArray[n3++] = (byte)(0x80 | c >> 6 & 0x3F);
                byArray[n3++] = (byte)(0x80 | c & 0x3F);
            }
            ++n;
        }
        UTF8_Encoder.updatePositions(charBuffer, n, byteBuffer, n3);
        return CoderResult.UNDERFLOW;
    }

    private CoderResult encodeBufferLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        int n = charBuffer.position();
        while (charBuffer.hasRemaining()) {
            char c = charBuffer.get();
            if (c < '\u0080') {
                if (!byteBuffer.hasRemaining()) {
                    return UTF8_Encoder.overflow(charBuffer, n);
                }
                byteBuffer.put((byte)c);
            } else if (c < '\u0800') {
                if (byteBuffer.remaining() < 2) {
                    return UTF8_Encoder.overflow(charBuffer, n);
                }
                byteBuffer.put((byte)(0xC0 | c >> 6));
                byteBuffer.put((byte)(0x80 | c & 0x3F));
            } else if (Surrogate.is(c)) {
                int n2;
                if (this.sgp == null) {
                    this.sgp = new Surrogate.Parser();
                }
                if ((n2 = this.sgp.parse(c, charBuffer)) < 0) {
                    charBuffer.position(n);
                    return this.sgp.error();
                }
                if (byteBuffer.remaining() < 4) {
                    return UTF8_Encoder.overflow(charBuffer, n);
                }
                byteBuffer.put((byte)(0xF0 | n2 >> 18));
                byteBuffer.put((byte)(0x80 | n2 >> 12 & 0x3F));
                byteBuffer.put((byte)(0x80 | n2 >> 6 & 0x3F));
                byteBuffer.put((byte)(0x80 | n2 & 0x3F));
                ++n;
            } else {
                if (byteBuffer.remaining() < 3) {
                    return UTF8_Encoder.overflow(charBuffer, n);
                }
                byteBuffer.put((byte)(0xE0 | c >> 12));
                byteBuffer.put((byte)(0x80 | c >> 6 & 0x3F));
                byteBuffer.put((byte)(0x80 | c & 0x3F));
            }
            ++n;
        }
        charBuffer.position(n);
        return CoderResult.UNDERFLOW;
    }

    @Override
    protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        BidiConvert bidiConvert;
        if (this.bidiEnabled && (bidiConvert = new BidiConvert()).isBidiData(charBuffer, UseBuffer, this.bidiParms, this.csName)) {
            int n;
            int n2;
            int n3;
            int n4;
            if (charBuffer.hasArray() && !UseBuffer) {
                char[] cArray = charBuffer.array();
                n4 = charBuffer.arrayOffset() + charBuffer.position();
                n3 = charBuffer.arrayOffset() + charBuffer.limit();
                int n5 = 0;
                int n6 = byteBuffer.remaining();
                for (n2 = n4; n2 < n3; ++n2) {
                    char c = cArray[n2];
                    if (c < '\u0080') {
                        n = 1;
                    } else if (c < '\u0800') {
                        n = 2;
                    } else if (!Surrogate.is(c)) {
                        n = 3;
                    } else {
                        if (Surrogate.isHigh(c) ? n2 + 1 >= n3 || !Surrogate.isLow(cArray[n2 + 1]) : n2 == n4 || !Surrogate.isHigh(cArray[n2 - 1])) break;
                        n = 2;
                    }
                    if (n5 + n > n6) break;
                    n5 += n;
                }
                n = n2 - n4;
            } else {
                int n7 = charBuffer.position();
                n3 = 0;
                n2 = byteBuffer.remaining();
                while (charBuffer.hasRemaining()) {
                    n4 = charBuffer.get();
                    if (n4 < 128) {
                        n = 1;
                    } else if (n4 < 2048) {
                        n = 2;
                    } else if (!Surrogate.is(n4)) {
                        n = 3;
                    } else {
                        if (Surrogate.isHigh(n4) ? !charBuffer.hasRemaining() || !Surrogate.isLow(charBuffer.get(charBuffer.position())) : charBuffer.position() - 2 < n7 || !Surrogate.isHigh(charBuffer.get(charBuffer.position() - 2))) break;
                        n = 2;
                    }
                    if (n3 + n > n2) break;
                    n3 += n;
                }
                n = charBuffer.position() - n7;
                charBuffer.position(n7);
            }
            int n8 = charBuffer.limit();
            charBuffer.limit(charBuffer.position() + n);
            CharBuffer charBuffer2 = bidiConvert.toSbcs(charBuffer, UseBuffer, this.bidiParms, this.csName);
            charBuffer.limit(n8);
            n3 = charBuffer2.position();
            CoderResult coderResult = charBuffer2.hasArray() && byteBuffer.hasArray() && !UseBuffer ? this.encodeArrayLoop(charBuffer2, byteBuffer) : this.encodeBufferLoop(charBuffer2, byteBuffer);
            n3 = charBuffer.position() + charBuffer2.position() - n3;
            charBuffer.position(n3);
            if (coderResult == CoderResult.UNDERFLOW && charBuffer.hasRemaining()) {
                coderResult = CoderResult.OVERFLOW;
            }
            return coderResult;
        }
        if (charBuffer.hasArray() && byteBuffer.hasArray() && !UseBuffer) {
            return this.encodeArrayLoop(charBuffer, byteBuffer);
        }
        return this.encodeBufferLoop(charBuffer, byteBuffer);
    }

    static {
        UseBuffer = false;
    }
}

