/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CoderResult;
import sun.nio.cs.Surrogate;
import sun.nio.cs.UnicodeEncoder;

public abstract class UTF16_Encoder
extends UnicodeEncoder {
    private int byteOrder;
    private boolean usesMark;
    private boolean needsMark;
    private boolean markWritten = false;
    private int byteOff;
    private int charOff;
    private final Surrogate.Parser sgp = new Surrogate.Parser();

    protected UTF16_Encoder(Charset charset, int n, boolean bl) {
        super(charset, n, bl);
        this.usesMark = this.needsMark = bl;
        this.byteOrder = n;
    }

    private void put(char c, ByteBuffer byteBuffer) {
        if (this.byteOrder == 0) {
            byteBuffer.put((byte)(c >> 8));
            byteBuffer.put((byte)(c & 0xFF));
        } else {
            byteBuffer.put((byte)(c & 0xFF));
            byteBuffer.put((byte)(c >> 8));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        if (charBuffer.hasArray() && byteBuffer.hasArray()) {
            char[] cArray = charBuffer.array();
            int n = charBuffer.arrayOffset() + charBuffer.position();
            int n2 = charBuffer.arrayOffset() + charBuffer.limit();
            byte[] byArray = byteBuffer.array();
            int n3 = byteBuffer.arrayOffset() + byteBuffer.position();
            int n4 = byteBuffer.arrayOffset() + byteBuffer.limit();
            this.charOff = n;
            this.byteOff = n3;
            int n5 = n;
            int n6 = n3;
            int n7 = n4 - 2;
            try {
                int n8;
                int n9;
                boolean bl;
                if (n2 - n5 > n4 - n6) {
                    bl = true;
                    n9 = n4 - n6;
                } else {
                    bl = false;
                    n9 = n2 - n5;
                }
                if (this.usesMark && !this.markWritten && n9 > 0) {
                    if (n6 > n7) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    if (this.byteOrder == 0) {
                        byArray[n6++] = -2;
                        byArray[n6++] = -1;
                    } else {
                        byArray[n6++] = -1;
                        byArray[n6++] = -2;
                    }
                    this.markWritten = true;
                }
                if (this.byteOrder == 0) {
                    while (n5 < n2) {
                        if (n6 > n7) {
                            this.charOff = n5;
                            this.byteOff = n6;
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        if (!Surrogate.is(cArray[n5])) {
                            n8 = cArray[n5++];
                            byArray[n6++] = (byte)(n8 >> 8);
                            byArray[n6++] = (byte)(n8 & 0xFF);
                            continue;
                        }
                        n8 = this.sgp.parse(cArray[n5], cArray, n5, n2);
                        if (n8 < 0) {
                            this.charOff = n5;
                            this.byteOff = n6;
                            CoderResult coderResult = this.sgp.error();
                            return coderResult;
                        }
                        if (n4 - n6 < 4) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        n5 += 2;
                        byArray[n6++] = (byte)(Surrogate.high(n8) >> 8);
                        byArray[n6++] = (byte)(Surrogate.high(n8) & 0xFF);
                        byArray[n6++] = (byte)(Surrogate.low(n8) >> 8);
                        byArray[n6++] = (byte)(Surrogate.low(n8) & 0xFF);
                    }
                } else {
                    while (n5 < n2) {
                        if (n6 > n7) {
                            this.charOff = n5;
                            this.byteOff = n6;
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        if (!Surrogate.is(cArray[n5])) {
                            n8 = cArray[n5++];
                            byArray[n6++] = (byte)(n8 & 0xFF);
                            byArray[n6++] = (byte)(n8 >> 8);
                        }
                        if ((n8 = this.sgp.parse(cArray[n5], cArray, n5, n2)) < 0) {
                            this.charOff = n5;
                            this.byteOff = n6;
                            CoderResult coderResult = this.sgp.error();
                            return coderResult;
                        }
                        if (n4 - n6 < 4) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        n5 += 2;
                        byArray[n6++] = (byte)(Surrogate.high(n8) & 0xFF);
                        byArray[n6++] = (byte)(Surrogate.high(n8) >> 8);
                        byArray[n6++] = (byte)(Surrogate.low(n8) & 0xFF);
                        byArray[n6++] = (byte)(Surrogate.low(n8) >> 8);
                    }
                }
                this.charOff = n5;
                this.byteOff = n6;
                if (bl) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                charBuffer.position(this.charOff);
                byteBuffer.position(this.byteOff);
            }
        }
        int n = charBuffer.position();
        if (this.needsMark) {
            if (byteBuffer.remaining() < 2) {
                return CoderResult.OVERFLOW;
            }
            if (charBuffer.hasRemaining()) {
                this.put('\ufeff', byteBuffer);
                this.needsMark = false;
            }
        }
        try {
            while (charBuffer.hasRemaining()) {
                char c = charBuffer.get();
                if (!Surrogate.is(c)) {
                    if (byteBuffer.remaining() < 2) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    ++n;
                    this.put(c, byteBuffer);
                    continue;
                }
                int n10 = this.sgp.parse(c, charBuffer);
                if (n10 < 0) {
                    CoderResult coderResult = this.sgp.error();
                    return coderResult;
                }
                if (byteBuffer.remaining() < 4) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                n += 2;
                this.put(Surrogate.high(n10), byteBuffer);
                this.put(Surrogate.low(n10), byteBuffer);
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            charBuffer.position(n);
        }
    }

    @Override
    protected void implReset() {
        this.needsMark = this.usesMark;
        this.charOff = 0;
        this.byteOff = 0;
        this.markWritten = false;
    }

    @Override
    public boolean canEncode(char c) {
        return !Surrogate.is(c);
    }
}

