/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.channels.SocketChannel;
import java.security.AccessController;
import java.util.List;
import sun.nio.ch.NetworkProvider;
import sun.nio.ch.ProviderNet;
import sun.nio.ch.RDMAFdRsocketCache;
import sun.nio.ch.RDMANet;
import sun.nio.ch.RDMASocketDispatcher;
import sun.nio.ch.SocketChannelImpl;
import sun.nio.ch.SocketDispatcher;
import sun.security.action.GetPropertyAction;
import sun.security.action.LoadLibraryAction;

class RDMANetworkProvider
implements NetworkProvider {
    private static final String name = "RDMA";
    private InetAddress preferredAddress = null;

    RDMANetworkProvider() {
    }

    @Override
    public void initialize() throws IOException {
        if (this.initialize0() != 0) {
            throw new IOException("Could not initialize RDMA transport!");
        }
    }

    @Override
    public void cleanup() {
        this.cleanup0();
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public void setPreferredAddress(List<String> list) {
        InetAddress inetAddress = null;
        try {
            if (!list.isEmpty()) {
                String string = AccessController.doPrivileged(new GetPropertyAction("com.ibm.nio.rdma.preferredAddress"));
                inetAddress = string != null && list.contains(string) ? InetAddress.getByName(string) : InetAddress.getByName(list.get(0));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.preferredAddress = inetAddress;
    }

    @Override
    public InetAddress getPreferredAddress() {
        return this.preferredAddress;
    }

    @Override
    public void createSocket(FileDescriptor fileDescriptor, int n) throws IOException {
        long l = this.create0(fileDescriptor, n);
        RDMAFdRsocketCache.addNewEntry(fileDescriptor, l);
    }

    @Override
    public ProviderNet getProviderNet() {
        return new RDMANet();
    }

    @Override
    public SocketDispatcher getProviderDispatcher() {
        return new RDMASocketDispatcher();
    }

    @Override
    public void postAccept(FileDescriptor fileDescriptor, SocketChannel socketChannel) throws IOException {
        FileDescriptor fileDescriptor2 = ((SocketChannelImpl)socketChannel).getFD();
        ((SocketChannelImpl)socketChannel).setNetworkProvider(this);
        long l = RDMAFdRsocketCache.getMatchingRsocket(fileDescriptor);
        long l2 = RDMANetworkProvider.socketPostAccept(fileDescriptor2, l);
        RDMAFdRsocketCache.addNewEntry(fileDescriptor2, l2);
    }

    private native int initialize0();

    private native int cleanup0();

    private native long create0(FileDescriptor var1, int var2) throws IOException;

    private static native long socketPostAccept(FileDescriptor var0, long var1) throws IOException;

    static {
        AccessController.doPrivileged(new LoadLibraryAction("jsor"));
    }
}

