/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.luni.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import org.apache.harmony.luni.util.MapEntry;

public class ModifiedMap<K, V>
extends AbstractMap<K, V>
implements SortedMap<K, V>,
Cloneable,
Serializable {
    private static final long serialVersionUID = 5746086209455290355L;
    transient int size;
    transient Entry<K, V> root;
    private Comparator<? super K> comparator;
    transient int modCount;
    transient Set<Map.Entry<K, V>> entrySet;
    private Set keySet;
    private AbstractCollection valuesCollection;

    private static <T> Comparable<T> toComparable(T t) {
        return (Comparable)t;
    }

    public ModifiedMap() {
    }

    public ModifiedMap(Comparator<? super K> comparator) {
        this.comparator = comparator;
    }

    public ModifiedMap(Map<? extends K, ? extends V> map) {
        this.putAll(map);
    }

    public ModifiedMap(SortedMap<K, ? extends V> sortedMap) {
        this.comparator = sortedMap.comparator();
        Iterator<Map.Entry<K, V>> iterator = sortedMap.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry<K, V> entry = iterator.next();
            Entry<K, V> entry2 = new Entry<K, V>(entry.getKey(), entry.getValue());
            this.root = entry2;
            this.size = 1;
            while (iterator.hasNext()) {
                entry = iterator.next();
                Entry<K, V> entry3 = new Entry<K, V>(entry.getKey(), entry.getValue());
                entry3.parent = entry2;
                entry2.right = entry3;
                ++this.size;
                this.balance(entry3);
                entry2 = entry3;
            }
        }
    }

    void balance(Entry<K, V> entry) {
        entry.color = true;
        while (entry != this.root && entry.parent.color) {
            Entry entry2;
            if (entry.parent == entry.parent.parent.left) {
                entry2 = entry.parent.parent.right;
                if (entry2 != null && entry2.color) {
                    entry.parent.color = false;
                    entry2.color = false;
                    entry.parent.parent.color = true;
                    entry = entry.parent.parent;
                    continue;
                }
                if (entry == entry.parent.right) {
                    entry = entry.parent;
                    this.leftRotate(entry);
                }
                entry.parent.color = false;
                entry.parent.parent.color = true;
                this.rightRotate(entry.parent.parent);
                continue;
            }
            entry2 = entry.parent.parent.left;
            if (entry2 != null && entry2.color) {
                entry.parent.color = false;
                entry2.color = false;
                entry.parent.parent.color = true;
                entry = entry.parent.parent;
                continue;
            }
            if (entry == entry.parent.left) {
                entry = entry.parent;
                this.rightRotate(entry);
            }
            entry.parent.color = false;
            entry.parent.parent.color = true;
            this.leftRotate(entry.parent.parent);
        }
        this.root.color = false;
    }

    @Override
    public void clear() {
        this.root = null;
        this.size = 0;
        ++this.modCount;
    }

    @Override
    public Object clone() {
        try {
            ModifiedMap modifiedMap = (ModifiedMap)super.clone();
            modifiedMap.entrySet = null;
            if (this.root != null) {
                modifiedMap.root = this.root.clone(null);
            }
            return modifiedMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    @Override
    public Comparator<? super K> comparator() {
        return this.comparator;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.find(object) != null;
    }

    @Override
    public boolean containsValue(Object object) {
        if (this.root != null) {
            return this.containsValue(this.root, object);
        }
        return false;
    }

    private boolean containsValue(Entry<K, V> entry, Object object) {
        if (object == null ? entry.value == null : object.equals(entry.value)) {
            return true;
        }
        if (entry.left != null && this.containsValue(entry.left, object)) {
            return true;
        }
        return entry.right != null && this.containsValue(entry.right, object);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet<Map.Entry<K, V>>(){

                @Override
                public int size() {
                    return ModifiedMap.this.size;
                }

                @Override
                public void clear() {
                    ModifiedMap.this.clear();
                }

                @Override
                public boolean contains(Object object) {
                    if (object instanceof Map.Entry) {
                        Map.Entry entry = (Map.Entry)object;
                        Object v = ModifiedMap.this.get(entry.getKey());
                        Object v2 = entry.getValue();
                        return v == null ? v2 == null : v.equals(v2);
                    }
                    return false;
                }

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    return new UnboundedEntryIterator(ModifiedMap.this);
                }
            };
        }
        return this.entrySet;
    }

    private Entry<K, V> find(Object object) {
        Object object2 = object;
        Comparable<Object> comparable = null;
        if (this.comparator == null) {
            comparable = ModifiedMap.toComparable(object2);
            Entry<K, V> entry = this.root;
            while (entry != null) {
                int n = comparable.compareTo(entry.key);
                if (n == 0) {
                    return entry;
                }
                entry = n < 0 ? entry.left : entry.right;
            }
        } else {
            Entry<K, V> entry = this.root;
            while (entry != null) {
                int n = this.comparator.compare(object2, entry.key);
                if (n == 0) {
                    return entry;
                }
                entry = n < 0 ? entry.left : entry.right;
            }
        }
        return null;
    }

    Entry<K, V> findAfter(Object object) {
        Object object2 = object;
        Comparable<Object> comparable = null;
        if (this.comparator == null) {
            comparable = ModifiedMap.toComparable(object2);
        }
        Entry<K, V> entry = this.root;
        Entry<K, V> entry2 = null;
        while (entry != null) {
            int n;
            int n2 = n = comparable != null ? comparable.compareTo(entry.key) : this.comparator.compare(object2, entry.key);
            if (n == 0) {
                return entry;
            }
            if (n < 0) {
                entry2 = entry;
                entry = entry.left;
                continue;
            }
            entry = entry.right;
        }
        return entry2;
    }

    Entry<K, V> findBefore(K k) {
        Comparable<K> comparable = null;
        if (this.comparator == null) {
            comparable = ModifiedMap.toComparable(k);
        }
        Entry<K, V> entry = this.root;
        Entry<K, V> entry2 = null;
        while (entry != null) {
            int n;
            int n2 = n = comparable != null ? comparable.compareTo(entry.key) : this.comparator.compare(k, entry.key);
            if (n <= 0) {
                entry = entry.left;
                continue;
            }
            entry2 = entry;
            entry = entry.right;
        }
        return entry2;
    }

    @Override
    public K firstKey() {
        if (this.root != null) {
            return (K)ModifiedMap.minimum(this.root).key;
        }
        throw new NoSuchElementException();
    }

    private void fixup(Entry<K, V> entry) {
        while (entry != this.root && !entry.color) {
            Entry entry2;
            if (entry == entry.parent.left) {
                entry2 = entry.parent.right;
                if (entry2 == null) {
                    entry = entry.parent;
                    continue;
                }
                if (entry2.color) {
                    entry2.color = false;
                    entry.parent.color = true;
                    this.leftRotate(entry.parent);
                    entry2 = entry.parent.right;
                    if (entry2 == null) {
                        entry = entry.parent;
                        continue;
                    }
                }
                if (!(entry2.left != null && entry2.left.color || entry2.right != null && entry2.right.color)) {
                    entry2.color = true;
                    entry = entry.parent;
                    continue;
                }
                if (entry2.right == null || !entry2.right.color) {
                    entry2.left.color = false;
                    entry2.color = true;
                    this.rightRotate(entry2);
                    entry2 = entry.parent.right;
                }
                entry2.color = entry.parent.color;
                entry.parent.color = false;
                entry2.right.color = false;
                this.leftRotate(entry.parent);
                entry = this.root;
                continue;
            }
            entry2 = entry.parent.left;
            if (entry2 == null) {
                entry = entry.parent;
                continue;
            }
            if (entry2.color) {
                entry2.color = false;
                entry.parent.color = true;
                this.rightRotate(entry.parent);
                entry2 = entry.parent.left;
                if (entry2 == null) {
                    entry = entry.parent;
                    continue;
                }
            }
            if (!(entry2.left != null && entry2.left.color || entry2.right != null && entry2.right.color)) {
                entry2.color = true;
                entry = entry.parent;
                continue;
            }
            if (entry2.left == null || !entry2.left.color) {
                entry2.right.color = false;
                entry2.color = true;
                this.leftRotate(entry2);
                entry2 = entry.parent.left;
            }
            entry2.color = entry.parent.color;
            entry.parent.color = false;
            entry2.left.color = false;
            this.rightRotate(entry.parent);
            entry = this.root;
        }
        entry.color = false;
    }

    @Override
    public V get(Object object) {
        Entry<K, V> entry = this.find(object);
        if (entry != null) {
            return (V)entry.value;
        }
        return null;
    }

    @Override
    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new AbstractSet<K>(){

                @Override
                public boolean contains(Object object) {
                    return ModifiedMap.this.containsKey(object);
                }

                @Override
                public int size() {
                    return ModifiedMap.this.size;
                }

                @Override
                public void clear() {
                    ModifiedMap.this.clear();
                }

                @Override
                public Iterator<K> iterator() {
                    return new UnboundedKeyIterator(ModifiedMap.this);
                }
            };
        }
        return this.keySet;
    }

    @Override
    public K lastKey() {
        if (this.root != null) {
            return (K)ModifiedMap.maximum(this.root).key;
        }
        throw new NoSuchElementException();
    }

    private void leftRotate(Entry<K, V> entry) {
        Entry entry2 = entry.right;
        entry.right = entry2.left;
        if (entry2.left != null) {
            entry2.left.parent = entry;
        }
        entry2.parent = entry.parent;
        if (entry.parent == null) {
            this.root = entry2;
        } else if (entry == entry.parent.left) {
            entry.parent.left = entry2;
        } else {
            entry.parent.right = entry2;
        }
        entry2.left = entry;
        entry.parent = entry2;
    }

    static <K, V> Entry<K, V> maximum(Entry<K, V> entry) {
        while (entry.right != null) {
            entry = entry.right;
        }
        return entry;
    }

    static <K, V> Entry<K, V> minimum(Entry<K, V> entry) {
        while (entry.left != null) {
            entry = entry.left;
        }
        return entry;
    }

    static <K, V> Entry<K, V> predecessor(Entry<K, V> entry) {
        if (entry.left != null) {
            return ModifiedMap.maximum(entry.left);
        }
        Entry entry2 = entry.parent;
        while (entry2 != null && entry == entry2.left) {
            entry = entry2;
            entry2 = entry2.parent;
        }
        return entry2;
    }

    @Override
    public V put(K k, V v) {
        Entry<K, V> entry = this.rbInsert(k);
        Object v2 = entry.value;
        entry.value = v;
        return v2;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        super.putAll(map);
    }

    void rbDelete(Entry<K, V> entry) {
        Entry entry2;
        Entry<K, V> entry3 = entry.left == null || entry.right == null ? entry : ModifiedMap.successor(entry);
        Entry entry4 = entry2 = entry3.left != null ? entry3.left : entry3.right;
        if (entry2 != null) {
            entry2.parent = entry3.parent;
        }
        if (entry3.parent == null) {
            this.root = entry2;
        } else if (entry3 == entry3.parent.left) {
            entry3.parent.left = entry2;
        } else {
            entry3.parent.right = entry2;
        }
        ++this.modCount;
        if (entry3 != entry) {
            entry.key = entry3.key;
            entry.value = entry3.value;
        }
        if (!entry3.color && this.root != null) {
            if (entry2 == null) {
                this.fixup(entry3.parent);
            } else {
                this.fixup(entry2);
            }
        }
        entry3.parent = null;
        entry3.right = null;
        entry3.left = null;
        --this.size;
    }

    private Entry<K, V> rbInsert(K k) {
        Object object;
        int n = 0;
        Entry<K, V> entry = null;
        if (this.size != 0) {
            object = null;
            if (this.comparator == null) {
                object = ModifiedMap.toComparable(k);
                Entry<K, V> entry2 = this.root;
                while (entry2 != null) {
                    entry = entry2;
                    n = object.compareTo(entry2.key);
                    if (n == 0) {
                        return entry2;
                    }
                    entry2 = n < 0 ? entry2.left : entry2.right;
                }
            } else {
                Entry<K, V> entry3 = this.root;
                while (entry3 != null) {
                    entry = entry3;
                    n = this.comparator.compare(k, entry3.key);
                    if (n == 0) {
                        return entry3;
                    }
                    entry3 = n < 0 ? entry3.left : entry3.right;
                }
            }
        }
        ++this.size;
        ++this.modCount;
        object = new Entry(k);
        if (entry == null) {
            this.root = object;
            return this.root;
        }
        ((Entry)object).parent = entry;
        if (n < 0) {
            entry.left = object;
        } else {
            entry.right = object;
        }
        this.balance((Entry<K, V>)object);
        return object;
    }

    @Override
    public V remove(Object object) {
        if (this.size == 0) {
            return null;
        }
        Entry<K, V> entry = this.find(object);
        if (entry == null) {
            return null;
        }
        Object object2 = entry.value;
        this.rbDelete(entry);
        return (V)object2;
    }

    private void rightRotate(Entry<K, V> entry) {
        Entry entry2 = entry.left;
        entry.left = entry2.right;
        if (entry2.right != null) {
            entry2.right.parent = entry;
        }
        entry2.parent = entry.parent;
        if (entry.parent == null) {
            this.root = entry2;
        } else if (entry == entry.parent.right) {
            entry.parent.right = entry2;
        } else {
            entry.parent.left = entry2;
        }
        entry2.right = entry;
        entry.parent = entry2;
    }

    @Override
    public int size() {
        return this.size;
    }

    static <K, V> Entry<K, V> successor(Entry<K, V> entry) {
        if (entry.right != null) {
            return ModifiedMap.minimum(entry.right);
        }
        Entry entry2 = entry.parent;
        while (entry2 != null && entry == entry2.right) {
            entry = entry2;
            entry2 = entry2.parent;
        }
        return entry2;
    }

    @Override
    public Collection<V> values() {
        if (this.valuesCollection == null) {
            this.valuesCollection = new AbstractCollection<V>(){

                @Override
                public boolean contains(Object object) {
                    return ModifiedMap.this.containsValue(object);
                }

                @Override
                public int size() {
                    return ModifiedMap.this.size;
                }

                @Override
                public void clear() {
                    ModifiedMap.this.clear();
                }

                @Override
                public Iterator<V> iterator() {
                    return new UnboundedValueIterator(ModifiedMap.this);
                }
            };
        }
        return this.valuesCollection;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.size);
        if (this.size > 0) {
            Entry<K, V> entry = ModifiedMap.minimum(this.root);
            while (entry != null) {
                objectOutputStream.writeObject(entry.key);
                objectOutputStream.writeObject(entry.value);
                entry = ModifiedMap.successor(entry);
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.size = objectInputStream.readInt();
        Entry entry = null;
        int n = this.size;
        while (--n >= 0) {
            Entry entry2 = new Entry(objectInputStream.readObject());
            entry2.value = objectInputStream.readObject();
            if (entry == null) {
                this.root = entry2;
            } else {
                entry2.parent = entry;
                entry.right = entry2;
                this.balance(entry2);
            }
            entry = entry2;
        }
    }

    @Override
    public SortedMap<K, V> headMap(K k) {
        return null;
    }

    @Override
    public SortedMap<K, V> subMap(K k, K k2) {
        return null;
    }

    @Override
    public SortedMap<K, V> tailMap(K k) {
        return null;
    }

    private static class BoundedValueIterator<K, V>
    extends BoundedIterator<K, V>
    implements Iterator<V> {
        BoundedValueIterator(ModifiedMap<K, V> modifiedMap, Entry<K, V> entry, Entry<K, V> entry2) {
            super(modifiedMap, entry, entry2);
        }

        @Override
        public V next() {
            this.makeNext();
            return (V)this.lastNode.value;
        }
    }

    private static class BoundedKeyIterator<K, V>
    extends BoundedIterator<K, V>
    implements Iterator<K> {
        BoundedKeyIterator(ModifiedMap<K, V> modifiedMap, Entry<K, V> entry, Entry<K, V> entry2) {
            super(modifiedMap, entry, entry2);
        }

        @Override
        public K next() {
            this.makeNext();
            return (K)this.lastNode.key;
        }
    }

    private static class BoundedEntryIterator<K, V>
    extends BoundedIterator<K, V>
    implements Iterator<Map.Entry<K, V>> {
        BoundedEntryIterator(ModifiedMap<K, V> modifiedMap, Entry<K, V> entry, Entry<K, V> entry2) {
            super(modifiedMap, entry, entry2);
        }

        @Override
        public Map.Entry<K, V> next() {
            this.makeNext();
            return this.lastNode;
        }
    }

    private static class BoundedIterator<K, V>
    extends AbstractMapIterator<K, V> {
        private final Entry<K, V> finishNode;

        BoundedIterator(ModifiedMap<K, V> modifiedMap, Entry<K, V> entry, Entry<K, V> entry2) {
            super(modifiedMap, entry);
            this.finishNode = entry2;
        }

        final void makeNext() {
            if (this.expectedModCount != this.backingMap.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.node == null) {
                throw new NoSuchElementException();
            }
            this.lastNode = this.node;
            this.node = this.node != this.finishNode ? ModifiedMap.successor(this.node) : null;
        }
    }

    static class UnboundedValueIterator<K, V>
    extends UnboundedIterator<K, V>
    implements Iterator<V> {
        public UnboundedValueIterator(ModifiedMap<K, V> modifiedMap, Entry<K, V> entry) {
            super(modifiedMap, entry);
        }

        public UnboundedValueIterator(ModifiedMap<K, V> modifiedMap) {
            super(modifiedMap, modifiedMap.root == null ? null : ModifiedMap.minimum(modifiedMap.root));
        }

        @Override
        public V next() {
            this.makeNext();
            return (V)this.lastNode.value;
        }
    }

    static class UnboundedKeyIterator<K, V>
    extends UnboundedIterator<K, V>
    implements Iterator<K> {
        public UnboundedKeyIterator(ModifiedMap<K, V> modifiedMap, Entry<K, V> entry) {
            super(modifiedMap, entry);
        }

        public UnboundedKeyIterator(ModifiedMap<K, V> modifiedMap) {
            super(modifiedMap, modifiedMap.root == null ? null : ModifiedMap.minimum(modifiedMap.root));
        }

        @Override
        public K next() {
            this.makeNext();
            return (K)this.lastNode.key;
        }
    }

    private static class UnboundedEntryIterator<K, V>
    extends UnboundedIterator<K, V>
    implements Iterator<Map.Entry<K, V>> {
        UnboundedEntryIterator(ModifiedMap<K, V> modifiedMap, Entry<K, V> entry) {
            super(modifiedMap, entry);
        }

        UnboundedEntryIterator(ModifiedMap<K, V> modifiedMap) {
            super(modifiedMap, modifiedMap.root == null ? null : ModifiedMap.minimum(modifiedMap.root));
        }

        @Override
        public Map.Entry<K, V> next() {
            this.makeNext();
            return this.lastNode;
        }
    }

    private static class UnboundedIterator<K, V>
    extends AbstractMapIterator<K, V> {
        public UnboundedIterator(ModifiedMap<K, V> modifiedMap, Entry<K, V> entry) {
            super(modifiedMap, entry);
        }

        final void makeNext() {
            if (this.expectedModCount != this.backingMap.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.node == null) {
                throw new NoSuchElementException();
            }
            this.lastNode = this.node;
            this.node = ModifiedMap.successor(this.node);
        }
    }

    private static class AbstractMapIterator<K, V> {
        ModifiedMap<K, V> backingMap;
        int expectedModCount;
        Entry<K, V> node;
        Entry<K, V> lastNode;

        AbstractMapIterator(ModifiedMap<K, V> modifiedMap, Entry<K, V> entry) {
            this.backingMap = modifiedMap;
            this.expectedModCount = modifiedMap.modCount;
            this.node = entry;
        }

        public boolean hasNext() {
            return this.node != null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final void remove() {
            if (this.expectedModCount != this.backingMap.modCount) throw new ConcurrentModificationException();
            if (this.lastNode == null) throw new IllegalStateException();
            this.backingMap.rbDelete(this.lastNode);
            this.lastNode = null;
            ++this.expectedModCount;
        }
    }

    static class Entry<K, V>
    extends MapEntry<K, V> {
        Entry<K, V> parent;
        Entry<K, V> left;
        Entry<K, V> right;
        boolean color;

        Entry(K k) {
            super(k);
        }

        Entry(K k, V v) {
            super(k, v);
        }

        Entry<K, V> clone(Entry<K, V> entry) {
            Entry entry2 = (Entry)super.clone();
            entry2.parent = entry;
            if (this.left != null) {
                entry2.left = this.left.clone(entry2);
            }
            if (this.right != null) {
                entry2.right = this.right.clone(entry2);
            }
            return entry2;
        }
    }
}

