/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import com.ibm.jvm.MemorySafetyService;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import sun.misc.Hashing;
import sun.misc.VM;
import sun.security.action.GetPropertyAction;

public class WeakHashMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V> {
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    static final Entry<?, ?>[] EMPTY_TABLE = new Entry[0];
    Entry<K, V>[] table = EMPTY_TABLE;
    private int size;
    private int threshold;
    private final float loadFactor;
    private final ReferenceQueue<Object> queue = new ReferenceQueue();
    int modCount;
    static final int ALTERNATIVE_HASHING_THRESHOLD_DEFAULT = Integer.MAX_VALUE;
    transient boolean useAltHashing;
    final transient int hashSeed = Hashing.randomHashSeed(this);
    private static final Object NULL_KEY = new Object();
    private transient Set<Map.Entry<K, V>> entrySet = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Entry<K, V>[] newTable(int n) {
        if (MemorySafetyService.isSafeMode()) {
            long l = -1L;
            try {
                l = MemorySafetyService.enterObjectsMemoryArea((Object)this);
                Entry[] entryArray = new Entry[n];
                return entryArray;
            }
            finally {
                MemorySafetyService.exitLastMemoryArea((long)l);
            }
        }
        return new Entry[n];
    }

    public WeakHashMap(int n, float f) {
        int n2;
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Initial Capacity: " + n);
        }
        if (n > 0x40000000) {
            n = 0x40000000;
        }
        if (f <= 0.0f || Float.isNaN(f)) {
            throw new IllegalArgumentException("Illegal Load factor: " + f);
        }
        for (n2 = 1; n2 < n; n2 <<= 1) {
        }
        this.loadFactor = f;
        this.threshold = n;
        this.useAltHashing = VM.isBooted() && n2 >= Holder.ALTERNATIVE_HASHING_THRESHOLD;
    }

    public WeakHashMap(int n) {
        this(n, 0.75f);
    }

    public WeakHashMap() {
        this(16, 0.75f);
    }

    public WeakHashMap(Map<? extends K, ? extends V> map) {
        this(Math.max((int)((float)map.size() / 0.75f) + 1, 16), 0.75f);
        super.inflateTable(this.threshold);
        this.putAll(map);
    }

    private static int roundUpToPowerOf2(int n) {
        int n2;
        n2 = n >= 0x40000000 ? 0x40000000 : ((n2 = Integer.highestOneBit(n)) != 0 ? (Integer.bitCount(n) > 1 ? n2 << 1 : n2) : 1);
        return n2;
    }

    private void inflateTable(int n) {
        int n2 = WeakHashMap.roundUpToPowerOf2(n);
        this.threshold = (int)Math.min((float)n2 * this.loadFactor, 1.0737418E9f);
        this.table = this.newTable(n2);
    }

    private static Object maskNull(Object object) {
        return object == null ? NULL_KEY : object;
    }

    static Object unmaskNull(Object object) {
        return object == NULL_KEY ? null : object;
    }

    private static boolean eq(Object object, Object object2) {
        return object == object2 || object.equals(object2);
    }

    int hash(Object object) {
        int n;
        if (this.useAltHashing) {
            n = this.hashSeed;
            if (object instanceof String) {
                return Hashing.stringHash32((String)object);
            }
            n ^= object.hashCode();
        } else {
            n = object.hashCode();
        }
        n ^= n >>> 20 ^ n >>> 12;
        return n ^ n >>> 7 ^ n >>> 4;
    }

    private static int indexFor(int n, int n2) {
        return n & n2 - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expungeStaleEntries() {
        Reference<Object> reference;
        while ((reference = this.queue.poll()) != null) {
            ReferenceQueue<Object> referenceQueue = this.queue;
            synchronized (referenceQueue) {
                Entry<K, V> entry;
                Entry entry2 = (Entry)reference;
                int n = WeakHashMap.indexFor(entry2.hash, this.table.length);
                Entry<K, V> entry3 = entry = this.table[n];
                while (entry3 != null) {
                    Entry entry4 = entry3.next;
                    if (entry3 == entry2) {
                        if (entry == entry2) {
                            this.table[n] = entry4;
                        } else {
                            entry.next = entry4;
                        }
                        entry2.value = null;
                        --this.size;
                        break;
                    }
                    entry = entry3;
                    entry3 = entry4;
                }
            }
        }
    }

    private Entry<K, V>[] getTable() {
        this.expungeStaleEntries();
        return this.table;
    }

    @Override
    public int size() {
        if (this.size == 0) {
            return 0;
        }
        this.expungeStaleEntries();
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public V get(Object object) {
        if (this.size == 0) {
            return null;
        }
        Object object2 = WeakHashMap.maskNull(object);
        int n = this.hash(object2);
        Entry<K, V>[] entryArray = this.getTable();
        int n2 = WeakHashMap.indexFor(n, entryArray.length);
        Entry<K, V> entry = entryArray[n2];
        while (entry != null) {
            if (entry.hash == n && WeakHashMap.eq(object2, entry.get())) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.getEntry(object) != null;
    }

    Entry<K, V> getEntry(Object object) {
        if (this.size == 0) {
            return null;
        }
        Object object2 = WeakHashMap.maskNull(object);
        int n = this.hash(object2);
        Entry<K, V>[] entryArray = this.getTable();
        int n2 = WeakHashMap.indexFor(n, entryArray.length);
        Entry<K, V> entry = entryArray[n2];
        while (!(entry == null || entry.hash == n && WeakHashMap.eq(object2, entry.get()))) {
            entry = entry.next;
        }
        return entry;
    }

    @Override
    public V put(K k, V v) {
        if (this.table == EMPTY_TABLE) {
            this.inflateTable(this.threshold);
        }
        Object object = WeakHashMap.maskNull(k);
        int n = this.hash(object);
        Entry<K, V>[] entryArray = this.getTable();
        int n2 = WeakHashMap.indexFor(n, entryArray.length);
        Entry<K, V> entry = entryArray[n2];
        while (entry != null) {
            if (n == entry.hash && WeakHashMap.eq(object, entry.get())) {
                Object v2 = entry.value;
                if (v != v2) {
                    entry.value = v;
                }
                return v2;
            }
            entry = entry.next;
        }
        ++this.modCount;
        entry = entryArray[n2];
        entryArray[n2] = new Entry<K, V>(object, v, this.queue, n, entry);
        if (++this.size >= this.threshold) {
            this.resize(entryArray.length * 2);
        }
        return null;
    }

    void resize(int n) {
        Entry<K, V>[] entryArray = this.getTable();
        int n2 = entryArray.length;
        if (n2 == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        Entry<K, V>[] entryArray2 = this.newTable(n);
        boolean bl = this.useAltHashing;
        this.useAltHashing |= VM.isBooted() && n >= Holder.ALTERNATIVE_HASHING_THRESHOLD;
        boolean bl2 = bl ^ this.useAltHashing;
        this.transfer(entryArray, entryArray2, bl2);
        this.table = entryArray2;
        if (this.size >= this.threshold / 2) {
            this.threshold = (int)((float)n * this.loadFactor);
        } else {
            this.expungeStaleEntries();
            this.transfer(entryArray2, entryArray, false);
            this.table = entryArray;
        }
    }

    private void transfer(Entry<K, V>[] entryArray, Entry<K, V>[] entryArray2, boolean bl) {
        for (int i = 0; i < entryArray.length; ++i) {
            Entry<K, V> entry = entryArray[i];
            entryArray[i] = null;
            while (entry != null) {
                Entry entry2 = entry.next;
                Object t = entry.get();
                if (t == null) {
                    entry.next = null;
                    entry.value = null;
                    --this.size;
                } else {
                    if (bl) {
                        entry.hash = this.hash(t);
                    }
                    int n = WeakHashMap.indexFor(entry.hash, entryArray2.length);
                    entry.next = entryArray2[n];
                    entryArray2[n] = entry;
                }
                entry = entry2;
            }
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        int n = map.size();
        if (n == 0) {
            return;
        }
        if (this.table == EMPTY_TABLE) {
            this.inflateTable((int)Math.max((float)n * this.loadFactor, (float)this.threshold));
        }
        if (n > this.threshold) {
            int n2;
            int n3 = (int)((float)n / this.loadFactor + 1.0f);
            if (n3 > 0x40000000) {
                n3 = 0x40000000;
            }
            for (n2 = this.table.length; n2 < n3; n2 <<= 1) {
            }
            if (n2 > this.table.length) {
                this.resize(n2);
            }
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object object) {
        Entry<K, V> entry;
        if (this.size == 0) {
            return null;
        }
        Object object2 = WeakHashMap.maskNull(object);
        int n = this.hash(object2);
        Entry<K, V>[] entryArray = this.getTable();
        int n2 = WeakHashMap.indexFor(n, entryArray.length);
        Entry<K, V> entry2 = entry = entryArray[n2];
        while (entry2 != null) {
            Entry entry3 = entry2.next;
            if (n == entry2.hash && WeakHashMap.eq(object2, entry2.get())) {
                ++this.modCount;
                --this.size;
                if (entry == entry2) {
                    entryArray[n2] = entry3;
                } else {
                    entry.next = entry3;
                }
                return entry2.value;
            }
            entry = entry2;
            entry2 = entry3;
        }
        return null;
    }

    boolean removeMapping(Object object) {
        Entry<K, V> entry;
        if (this.size == 0 || !(object instanceof Map.Entry)) {
            return false;
        }
        Entry<K, V>[] entryArray = this.getTable();
        Map.Entry entry2 = (Map.Entry)object;
        Object object2 = WeakHashMap.maskNull(entry2.getKey());
        int n = this.hash(object2);
        int n2 = WeakHashMap.indexFor(n, entryArray.length);
        Entry<K, V> entry3 = entry = entryArray[n2];
        while (entry3 != null) {
            Entry entry4 = entry3.next;
            if (n == entry3.hash && entry3.equals(entry2)) {
                ++this.modCount;
                --this.size;
                if (entry == entry3) {
                    entryArray[n2] = entry4;
                } else {
                    entry.next = entry4;
                }
                return true;
            }
            entry = entry3;
            entry3 = entry4;
        }
        return false;
    }

    @Override
    public void clear() {
        while (this.queue.poll() != null) {
        }
        ++this.modCount;
        Arrays.fill(this.table, null);
        this.size = 0;
        while (this.queue.poll() != null) {
        }
    }

    @Override
    public boolean containsValue(Object object) {
        if (object == null) {
            return this.containsNullValue();
        }
        Entry<K, V>[] entryArray = this.getTable();
        int n = entryArray.length;
        while (n-- > 0) {
            Entry<K, V> entry = entryArray[n];
            while (entry != null) {
                if (object.equals(entry.value)) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    private boolean containsNullValue() {
        Entry<K, V>[] entryArray = this.getTable();
        int n = entryArray.length;
        while (n-- > 0) {
            Entry<K, V> entry = entryArray[n];
            while (entry != null) {
                if (entry.value == null) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    @Override
    public Set<K> keySet() {
        Set set = this.keySet;
        return set != null ? set : (this.keySet = new KeySet());
    }

    @Override
    public Collection<V> values() {
        Collection collection = this.values;
        return collection != null ? collection : (this.values = new Values());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet entrySet = this.entrySet;
        return entrySet != null ? entrySet : (this.entrySet = new EntrySet());
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Entry entry2 = WeakHashMap.this.getEntry(entry.getKey());
            return entry2 != null && entry2.equals(entry);
        }

        @Override
        public boolean remove(Object object) {
            return WeakHashMap.this.removeMapping(object);
        }

        @Override
        public int size() {
            return WeakHashMap.this.size();
        }

        @Override
        public void clear() {
            WeakHashMap.this.clear();
        }

        private List<Map.Entry<K, V>> deepCopy() {
            ArrayList arrayList = new ArrayList(this.size());
            for (Map.Entry entry : this) {
                arrayList.add(new AbstractMap.SimpleEntry(entry));
            }
            return arrayList;
        }

        @Override
        public Object[] toArray() {
            return this.deepCopy().toArray();
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            return this.deepCopy().toArray(TArray);
        }
    }

    private class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return WeakHashMap.this.size();
        }

        @Override
        public boolean contains(Object object) {
            return WeakHashMap.this.containsValue(object);
        }

        @Override
        public void clear() {
            WeakHashMap.this.clear();
        }
    }

    private class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return WeakHashMap.this.size();
        }

        @Override
        public boolean contains(Object object) {
            return WeakHashMap.this.containsKey(object);
        }

        @Override
        public boolean remove(Object object) {
            if (WeakHashMap.this.containsKey(object)) {
                WeakHashMap.this.remove(object);
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            WeakHashMap.this.clear();
        }
    }

    private class EntryIterator
    extends HashIterator<Map.Entry<K, V>> {
        private EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            return this.nextEntry();
        }
    }

    private class KeyIterator
    extends HashIterator<K> {
        private KeyIterator() {
        }

        @Override
        public K next() {
            return this.nextEntry().getKey();
        }
    }

    private class ValueIterator
    extends HashIterator<V> {
        private ValueIterator() {
        }

        @Override
        public V next() {
            return this.nextEntry().value;
        }
    }

    private abstract class HashIterator<T>
    implements Iterator<T> {
        private int index;
        private Entry<K, V> entry = null;
        private Entry<K, V> lastReturned = null;
        private int expectedModCount;
        private Object nextKey;
        private Object currentKey;

        HashIterator() {
            this.expectedModCount = WeakHashMap.this.modCount;
            this.nextKey = null;
            this.currentKey = null;
            this.index = WeakHashMap.this.isEmpty() ? 0 : WeakHashMap.this.table.length;
        }

        @Override
        public boolean hasNext() {
            Entry<K, V>[] entryArray = WeakHashMap.this.table;
            while (this.nextKey == null) {
                Entry entry = this.entry;
                int n = this.index;
                while (entry == null && n > 0) {
                    entry = entryArray[--n];
                }
                this.entry = entry;
                this.index = n;
                if (entry == null) {
                    this.currentKey = null;
                    return false;
                }
                this.nextKey = entry.get();
                if (this.nextKey != null) continue;
                this.entry = this.entry.next;
            }
            return true;
        }

        protected Entry<K, V> nextEntry() {
            if (WeakHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.nextKey == null && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.entry;
            this.entry = this.entry.next;
            this.currentKey = this.nextKey;
            this.nextKey = null;
            return this.lastReturned;
        }

        @Override
        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (WeakHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            WeakHashMap.this.remove(this.currentKey);
            this.expectedModCount = WeakHashMap.this.modCount;
            this.lastReturned = null;
            this.currentKey = null;
        }
    }

    private static class Entry<K, V>
    extends WeakReference<Object>
    implements Map.Entry<K, V> {
        V value;
        int hash;
        Entry<K, V> next;

        Entry(Object object, V v, ReferenceQueue<Object> referenceQueue, int n, Entry<K, V> entry) {
            super(object, referenceQueue);
            this.value = v;
            this.hash = n;
            this.next = entry;
        }

        @Override
        public K getKey() {
            return (K)WeakHashMap.unmaskNull(this.get());
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V v) {
            V v2 = this.value;
            this.value = v;
            return v2;
        }

        @Override
        public boolean equals(Object object) {
            Object v;
            V v2;
            Object k;
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            K k2 = this.getKey();
            return (k2 == (k = entry.getKey()) || k2 != null && k2.equals(k)) && ((v2 = this.getValue()) == (v = entry.getValue()) || v2 != null && v2.equals(v));
        }

        @Override
        public int hashCode() {
            K k = this.getKey();
            V v = this.getValue();
            return (k == null ? 0 : k.hashCode()) ^ (v == null ? 0 : v.hashCode());
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }

    private static class Holder {
        static final int ALTERNATIVE_HASHING_THRESHOLD;

        private Holder() {
        }

        static {
            int n;
            String string = AccessController.doPrivileged(new GetPropertyAction("jdk.map.althashing.threshold"));
            try {
                int n2 = n = null != string ? Integer.parseInt(string) : Integer.MAX_VALUE;
                if (n == -1) {
                    n = Integer.MAX_VALUE;
                }
                if (n < 0) {
                    throw new IllegalArgumentException("value must be positive integer.");
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new Error("Illegal value for 'jdk.map.althashing.threshold'", illegalArgumentException);
            }
            ALTERNATIVE_HASHING_THRESHOLD = n;
        }
    }
}

