/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.downloads.messages;

import com.ibm.cic.common.downloads.messages.AbstractProtocolMessage;
import com.ibm.cic.common.downloads.messages.IProtocolHeader;
import com.ibm.cic.common.downloads.messages.IProtocolMessage;
import com.ibm.cic.common.downloads.messages.MessageDirection;
import com.ibm.cic.common.downloads.messages.ProtocolHeader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class SimpleProtocolMessage
extends AbstractProtocolMessage {
    private final List<IProtocolHeader> headers;
    private Set<String> keys;

    public static Builder builder(String protocol, MessageDirection direction, String mainHeaderKey) {
        return new Builder(protocol, direction, mainHeaderKey);
    }

    public static Builder builder(IProtocolMessage msg) {
        return new Builder(msg.getProtocol(), msg.getMessageDirection(), msg.getMainHeaderKey());
    }

    private SimpleProtocolMessage(String protocol, MessageDirection direction, String mainHeaderKey, List<IProtocolHeader> headers) {
        super(protocol, direction, mainHeaderKey);
        this.headers = headers;
    }

    @Override
    public IProtocolHeader[] getHeaders() {
        return this.getHeaders(null);
    }

    @Override
    public IProtocolHeader[] getHeaders(String key) {
        if (key == null) {
            return this.headers.toArray(new IProtocolHeader[this.headers.size()]);
        }
        ArrayList<IProtocolHeader> list = new ArrayList<IProtocolHeader>();
        for (IProtocolHeader header : this.headers) {
            if (!key.equals(header.getKey())) continue;
            list.add(header);
        }
        return list.toArray(new IProtocolHeader[list.size()]);
    }

    @Override
    public Set<String> getHeaderKeys() {
        if (this.keys == null) {
            this.keys = new LinkedHashSet<String>(this.headers.size());
            for (IProtocolHeader header : this.headers) {
                this.keys.add(header.getKey());
            }
        }
        return Collections.unmodifiableSet(this.keys);
    }

    /* synthetic */ SimpleProtocolMessage(String string, MessageDirection messageDirection, String string2, List list, SimpleProtocolMessage simpleProtocolMessage) {
        this(string, messageDirection, string2, list);
    }

    public static class Builder {
        private final String protocol;
        private final MessageDirection direction;
        private final String mainHeaderKey;
        private final List<IProtocolHeader> headers = new ArrayList<IProtocolHeader>();

        Builder(String protocol, MessageDirection direction, String mainHeaderKey) {
            this.protocol = protocol;
            this.direction = direction;
            this.mainHeaderKey = mainHeaderKey;
        }

        public SimpleProtocolMessage build() {
            return new SimpleProtocolMessage(this.protocol, this.direction, this.mainHeaderKey, this.headers, null);
        }

        public Builder header(String key, String name, String value) {
            return this.header(new ProtocolHeader(key, name, value));
        }

        public Builder header(IProtocolHeader header) {
            this.headers.add(header);
            return this;
        }
    }
}

