/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.downloads.messages;

import com.ibm.cic.common.downloads.messages.IProtocolHeader;
import com.ibm.cic.common.downloads.messages.IProtocolMessage;
import com.ibm.cic.common.downloads.messages.MessageDirection;
import com.ibm.cic.common.logging.Logger;
import java.util.ArrayList;
import java.util.Set;

abstract class AbstractProtocolMessage
implements IProtocolMessage {
    private final String protocol;
    private final MessageDirection direction;
    private final String mainHeaderKey;

    protected AbstractProtocolMessage(String protocol, MessageDirection direction, String mainHeaderKey) {
        assert (direction != null);
        assert (protocol != null);
        this.protocol = protocol.trim();
        assert (this.protocol.length() > 0);
        this.direction = direction;
        this.mainHeaderKey = mainHeaderKey;
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public MessageDirection getMessageDirection() {
        return this.direction;
    }

    @Override
    public String getMainHeaderKey() {
        return this.mainHeaderKey;
    }

    @Override
    public abstract Set getHeaderKeys();

    @Override
    public abstract IProtocolHeader[] getHeaders();

    @Override
    public abstract IProtocolHeader[] getHeaders(String var1);

    @Override
    public String[] toLines() {
        String dirPrefix = this.getMessageDirection().equals(MessageDirection.MD_IN) ? "< " : "> ";
        IProtocolHeader[] headers = this.getHeaders();
        ArrayList<String> lines = new ArrayList<String>(headers.length);
        IProtocolHeader[] iProtocolHeaderArray = headers;
        int n = headers.length;
        int n2 = 0;
        while (n2 < n) {
            IProtocolHeader header = iProtocolHeaderArray[n2];
            StringBuilder sb = new StringBuilder();
            sb.append(dirPrefix);
            if (header.getKey().equals(this.getMainHeaderKey())) {
                sb.append(header.getValue());
            } else {
                sb.append(header.getName());
                sb.append(':');
                sb.append(header.getValue());
            }
            lines.add(sb.toString());
            ++n2;
        }
        return lines.toArray(new String[lines.size()]);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String[] stringArray = this.toLines();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            sb.append(line).append(Logger.NEWLINE);
            ++n2;
        }
        return sb.toString();
    }
}

