/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.downloads.handlerImpl;

import com.ibm.cic.common.downloads.DownloadCanceledException;
import com.ibm.cic.common.downloads.IHasIsCanceled;
import com.ibm.cic.common.downloads.handlerImpl.AuthenticationContext;
import com.ibm.cic.common.downloads.handlerImpl.DownloadHandlerUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.UnknownHostException;

public class RequestRetryHandler {
    private int retryCount;
    private int lastAskedCount;
    protected AuthenticationContext authContext;
    private final IHasIsCanceled cancelMonitor;

    public RequestRetryHandler(AuthenticationContext authContext, IHasIsCanceled cancelMonitor, int retryCount) {
        this.retryCount = retryCount;
        this.authContext = authContext;
        this.lastAskedCount = authContext.getAskedCount();
        this.cancelMonitor = cancelMonitor;
    }

    public boolean shouldRetry(Object request, String urlString, IOException exception, int executionCount) throws IOException {
        if (this.cancelMonitor.isCanceled()) {
            throw DownloadCanceledException.create(request, urlString, exception);
        }
        if (exception instanceof DownloadCanceledException) {
            throw (DownloadCanceledException)exception;
        }
        if (this.authContext.checkThreadCanceled(false)) {
            throw DownloadCanceledException.createAuthenticationCanceled(request, urlString, exception);
        }
        if (exception instanceof MalformedURLException) {
            throw (MalformedURLException)exception;
        }
        if (exception instanceof UnknownHostException) {
            throw (UnknownHostException)exception;
        }
        if (exception instanceof FileNotFoundException) {
            throw (FileNotFoundException)exception;
        }
        int curAskedCount = this.authContext.getAskedCount();
        int askedCount = curAskedCount - this.lastAskedCount;
        if (askedCount > 0) {
            if (DownloadHandlerUtil.traceProxySettings.enabled) {
                DownloadHandlerUtil.traceProxySettings.println("HttpClientDownloadHandler.MethodRetryHandler: increasing retry count by {0} to adjust for credential popup dialogs", Integer.toString(askedCount));
            }
            this.retryCount += askedCount;
            this.lastAskedCount = curAskedCount;
        }
        return executionCount <= this.retryCount;
    }
}

