/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.downloads.handlerImpl;

import com.ibm.cic.common.downloads.DownloadUI;
import com.ibm.cic.common.downloads.IDownloadContext;
import com.ibm.cic.common.downloads.IDownloadUI;
import com.ibm.cic.common.downloads.IHasIsCanceled;
import com.ibm.cic.common.downloads.IRestorePrevious;

public class DownloadCancelMonitorUtil {
    private static final String KEY_DOWNLOAD_CANCEL_MONITOR = "KEY_DOWNLOAD_CANCEL_MONITOR";

    public static IHasIsCanceled getDownloadCancelMonitor(IDownloadContext ctxt) {
        IHasIsCanceled cancelMonitor = DownloadCancelMonitorUtil.getDownloadUICancelMonitor(ctxt);
        if (cancelMonitor != null) {
            return cancelMonitor;
        }
        return DownloadCancelMonitorUtil.getContextCancelMonitor(ctxt);
    }

    public static IHasIsCanceled getDownloadUICancelMonitor(IDownloadContext ctxt) {
        if (ctxt == null) {
            return null;
        }
        IDownloadUI ui = DownloadUI.getDownloadUI(ctxt);
        if (ui instanceof IHasIsCanceled) {
            return (IHasIsCanceled)((Object)ui);
        }
        return null;
    }

    private static IHasIsCanceled getContextCancelMonitor(IDownloadContext ctxt) {
        if (ctxt == null) {
            return null;
        }
        return (IHasIsCanceled)ctxt.get(KEY_DOWNLOAD_CANCEL_MONITOR);
    }

    public static IRestorePrevious setContextCancelMonitor(final IDownloadContext ctxt, IHasIsCanceled cancelMonitor) {
        final IHasIsCanceled prev = DownloadCancelMonitorUtil.getContextCancelMonitor(ctxt);
        IRestorePrevious prevCallback = new IRestorePrevious(){

            @Override
            public void restore() {
                DownloadCancelMonitorUtil.privateSetContextCancelMonitor(ctxt, prev);
            }
        };
        DownloadCancelMonitorUtil.privateSetContextCancelMonitor(ctxt, cancelMonitor);
        return prevCallback;
    }

    private static void privateSetContextCancelMonitor(IDownloadContext ctxt, IHasIsCanceled cancelMonitor) {
        ctxt.put(KEY_DOWNLOAD_CANCEL_MONITOR, cancelMonitor);
    }
}

