/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.downloads;

import com.ibm.cic.common.core.internal.utils.RefCount;
import com.ibm.cic.common.downloads.IHasIsCanceled;
import com.ibm.cic.common.downloads.Messages;
import com.ibm.cic.common.downloads.SocketEvents;
import com.ibm.cic.common.downloads.WaitMonitor;
import com.ibm.cic.common.logging.Logger;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.osgi.util.NLS;

public class SocketMonitor {
    private static String getSocketWaitText(WaitMonitor.ActivityInfo activity) {
        Object o = activity.getActivity();
        if (o instanceof SocketEvents.SocketToConnect) {
            SocketEvents.SocketToConnect stc = (SocketEvents.SocketToConnect)o;
            String server = SocketMonitor.getServerHostPortString(stc.getHostInfo().getHost(), stc.getHostInfo().getPort());
            return NLS.bind((String)Messages.SocketMonitor_wait_for_connection, (Object)server);
        }
        SocketEvents.IEventWithSocket event = (SocketEvents.IEventWithSocket)o;
        InetSocketAddress address = (InetSocketAddress)event.getSocket().getRemoteSocketAddress();
        String server = SocketMonitor.getServerHostPortString(address.getHostName(), address.getPort());
        return NLS.bind((String)Messages.SocketMonitor_server_stalls, (Object)server);
    }

    private static String getSocketArrivedText(WaitMonitor.ActivityInfo activity) {
        Object o = activity.getActivity();
        if (o instanceof SocketEvents.SocketToConnect) {
            SocketEvents.SocketToConnect stc = (SocketEvents.SocketToConnect)activity.getActivity();
            String server = SocketMonitor.getServerHostPortString(stc.getHostInfo().getHost(), stc.getHostInfo().getPort());
            return NLS.bind((String)Messages.SocketMonitor_connection_established, (Object)server);
        }
        SocketEvents.IEventWithSocket event = (SocketEvents.IEventWithSocket)o;
        InetSocketAddress address = (InetSocketAddress)event.getSocket().getRemoteSocketAddress();
        String server = SocketMonitor.getServerHostPortString(address.getHostName(), address.getPort());
        return NLS.bind((String)Messages.SocketMonitor_server_response_received, (Object)server);
    }

    private static String getServerHostPortString(String host, int port) {
        return NLS.bind((String)Messages.SocketMonitor_host_and_port, (Object)host, (Object)port);
    }

    private static class NoResponseExpected {
        static final Logger logNRE = Logger.getLoggerUsingDebug("com.ibm.cic.common.core/debug/NoResponseExpected");
        private final Map noResponseExpected = Collections.synchronizedMap(new HashMap());

        private NoResponseExpected() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void beginNoResponseExpected(Object o) {
            Map map = this.noResponseExpected;
            synchronized (map) {
                RefCount refCount = (RefCount)this.noResponseExpected.get(o);
                if (refCount == null) {
                    refCount = new RefCount(o);
                    this.noResponseExpected.put(o, refCount);
                } else {
                    refCount.incrRefCount();
                }
                this.logThis();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void endNoResponseExpected(Object o) {
            Map map = this.noResponseExpected;
            synchronized (map) {
                RefCount refCount = (RefCount)this.noResponseExpected.get(o);
                assert (refCount != null);
                refCount.decrRefCount();
                if (refCount.isZeroRefCount()) {
                    this.noResponseExpected.remove(o);
                }
                this.logThis();
            }
        }

        private void logThis() {
            if (!logNRE.isDebugLoggable()) {
                return;
            }
            int size = this.noResponseExpected.size();
            if (size > 0) {
                StringBuffer sb = new StringBuffer(size * 100);
                sb.append("No response expected for: ");
                sb.append(size);
                for (Map.Entry entry : this.noResponseExpected.entrySet()) {
                    sb.append("\n");
                    sb.append(SocketEvents.toStringWithId(entry.getValue()));
                }
                logNRE.debug("{0}", sb.toString());
            } else {
                logNRE.debug("No sockets for which no response is expected.");
            }
        }

        boolean isNoResponseExpected(Object o) {
            RefCount refCount = (RefCount)this.noResponseExpected.get(o);
            return refCount != null;
        }
    }

    public static class SocketListenerToProgressMonitorRunnable
    extends WaitMonitor.OldestWaitToProgressMonitorRunnable {
        public SocketListenerToProgressMonitorRunnable(WaitMonitor.IWaitFeedbackArea waitFeedback, IHasIsCanceled cancelMonitor, long msRefreshFrequency, long msMinimumAge) {
            super(waitFeedback, cancelMonitor, msRefreshFrequency, msMinimumAge);
        }

        @Override
        protected void removeWaitListeners(Object obj) {
            ((SocketListenerToWaitMonitor)obj).done();
        }

        @Override
        protected Object setupWaitListeners() {
            return new SocketListenerToWaitMonitor();
        }

        @Override
        protected WaitMonitor getWaitMonitor(Object listener) {
            return ((SocketListenerToWaitMonitor)listener).getWaitMonitor();
        }

        @Override
        protected String getWaitText(WaitMonitor.ActivityInfo activity) {
            return SocketMonitor.getSocketWaitText(activity);
        }
    }

    private static class SocketListenerToWaitMonitor {
        private final WaitMonitor monitor = new WaitMonitor();
        private final NoResponseExpected noResponseExpected = new NoResponseExpected();
        private final SocketEvents.SocketListener listener;

        SocketListenerToWaitMonitor() {
            this.monitor.setFilter(new WaitMonitor.IActivityFilter(){

                @Override
                public boolean skip(WaitMonitor.ActivityInfo ai) {
                    Object a = ai.getActivity();
                    if (a instanceof SocketEvents.IEventWithSocket) {
                        SocketEvents.IEventWithSocket withSocket = (SocketEvents.IEventWithSocket)a;
                        if (SocketListenerToWaitMonitor.this.noResponseExpected.isNoResponseExpected(withSocket.getSocket())) {
                            NoResponseExpected.logNRE.debug("Not reporting wait as silence is expected {0}", a);
                            return true;
                        }
                    }
                    return false;
                }
            });
            this.listener = new SocketEvents.SocketListener(){

                @Override
                public void onBeforeSocketConnected(SocketEvents.SocketToConnect stc) {
                    SocketListenerToWaitMonitor.this.monitor.startActivity(stc);
                    this.debugSleep();
                }

                private void debugSleep() {
                }

                @Override
                public void onSocketConnected(SocketEvents.SocketToConnect stc) {
                    SocketListenerToWaitMonitor.this.monitor.endActivity(stc);
                }

                @Override
                public void onSocketConnectFailed(SocketEvents.SocketToConnect stc, Throwable t) {
                    SocketListenerToWaitMonitor.this.monitor.endActivity(stc);
                }

                @Override
                public void onBeforeSocketEvent(SocketEvents.IEventWithSocket event) {
                    SocketListenerToWaitMonitor.this.monitor.startActivity(event);
                    this.debugSleep();
                }

                @Override
                public void onFailedSocketEvent(SocketEvents.IEventWithSocket event, Throwable e) {
                    SocketListenerToWaitMonitor.this.monitor.endActivity(event);
                }

                @Override
                public void onPostSocketEvent(SocketEvents.IEventWithSocket event) {
                    SocketListenerToWaitMonitor.this.monitor.endActivity(event);
                }

                @Override
                public void beginNoResponseExpected(Socket socket) {
                    SocketListenerToWaitMonitor.this.noResponseExpected.beginNoResponseExpected(socket);
                }

                @Override
                public void endNoResponseExpected(Socket socket) {
                    SocketListenerToWaitMonitor.this.noResponseExpected.endNoResponseExpected(socket);
                }
            };
            SocketEvents.INSTANCE.addSocketListener(this.listener);
        }

        void done() {
            SocketEvents.INSTANCE.removeSocketListener(this.listener);
        }

        WaitMonitor getWaitMonitor() {
            return this.monitor;
        }
    }

    public static class SocketMTWaitToProgressMonitorRunnable
    extends WaitMonitor.MultithreadedWaitToProgressMonitorRunnable {
        public SocketMTWaitToProgressMonitorRunnable(WaitMonitor.IWaitSetFeedbackArea waitFeedback, long msRefreshFrequency, long msMinimumAge) {
            super(waitFeedback, msRefreshFrequency, msMinimumAge);
        }

        @Override
        protected void removeWaitListeners(Object obj) {
            ((SocketListenerToWaitMonitor)obj).done();
        }

        @Override
        protected Object setupWaitListeners() {
            return new SocketListenerToWaitMonitor();
        }

        @Override
        protected WaitMonitor getWaitMonitor(Object listener) {
            return ((SocketListenerToWaitMonitor)listener).getWaitMonitor();
        }

        @Override
        protected String getWaitText(WaitMonitor.ActivityInfo activity) {
            return SocketMonitor.getSocketWaitText(activity);
        }

        @Override
        protected String getArrivedText(WaitMonitor.ActivityInfo activity) {
            return SocketMonitor.getSocketArrivedText(activity);
        }
    }
}

