/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.downloads;

public class SizeInfo {
    public static final long UNDEFINED = Long.MIN_VALUE;
    private long downloadSize;
    private long installSize;

    public SizeInfo() {
        this(Long.MIN_VALUE, Long.MIN_VALUE);
    }

    public SizeInfo(SizeInfo rhs) {
        this(rhs.getDownloadSize(), rhs.getInstallSize());
    }

    public boolean equals(Object obj) {
        if (obj instanceof SizeInfo) {
            SizeInfo rhs = (SizeInfo)obj;
            return this.downloadSize == rhs.downloadSize && this.installSize == rhs.installSize;
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.downloadSize * 17L + this.installSize);
    }

    public SizeInfo(long downloadSize, long installSize) {
        this.setDownloadSize(downloadSize);
        this.setInstallSize(installSize);
    }

    public String toString() {
        return "downloadSize=" + SizeInfo.toString(this.downloadSize) + ", installSize=" + SizeInfo.toString(this.installSize);
    }

    public long getDownloadSize() {
        return this.downloadSize;
    }

    public void setDownloadSize(long downloadSize) {
        this.downloadSize = downloadSize;
    }

    public long getInstallSize() {
        return this.installSize;
    }

    public void setInstallSize(long installSize) {
        this.installSize = installSize;
    }

    public void setSizes(long downloadSize, long installSize) {
        this.setDownloadSize(downloadSize);
        this.setInstallSize(installSize);
    }

    public void setSizes(SizeInfo that) {
        this.setDownloadSize(that.getDownloadSize());
        this.setInstallSize(that.getInstallSize());
    }

    public void add(SizeInfo that) {
        this.addDownloadSize(that.downloadSize);
        this.addInstallSize(that.installSize);
    }

    public void addDownloadSize(long size) {
        this.setDownloadSize(SizeInfo.add(this.downloadSize, size));
    }

    public void addInstallSize(long size) {
        this.setInstallSize(SizeInfo.add(this.installSize, size));
    }

    public void subtractInstallSize(long size) {
        this.setInstallSize(SizeInfo.subtract(this.installSize, size));
    }

    protected static long add(long x, long y) {
        return x == Long.MIN_VALUE ? y : (y == Long.MIN_VALUE ? x : x + y);
    }

    protected static long subtract(long x, long y) {
        return x == Long.MIN_VALUE ? -y : (y == Long.MIN_VALUE ? x : x - y);
    }

    protected static String toString(long x) {
        return x == Long.MIN_VALUE ? "undefined" : Long.toString(x);
    }
}

