/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.downloads;

import com.ibm.cic.common.core.internal.ComIbmCicCommonCorePlugin;
import com.ibm.cic.common.downloads.AbstractDownloadListener;
import com.ibm.cic.common.downloads.DownloadHandlerRequest;
import com.ibm.cic.common.downloads.IDownloadContext;
import com.ibm.cic.common.downloads.IDownloadListener;
import com.ibm.cic.common.logging.Logger;
import java.util.ArrayList;
import org.eclipse.core.runtime.Plugin;

public class DownloadEvents {
    private final ArrayList listeners;
    private static final Logger log = Logger.getLogger(DownloadEvents.class, (Plugin)ComIbmCicCommonCorePlugin.getDefault());
    private final FireEvents MY_FIRE = new FireEvents();
    private static final String DOWNLOAD_CONTEXT_KEY = "DownloadEvents";
    private static final IDownloadListener NULL_FIRE = new AbstractDownloadListener(){};

    private DownloadEvents() {
        this.listeners = new ArrayList(10);
    }

    public static IDownloadListener getFire(IDownloadContext ctxt) {
        DownloadEvents events = (DownloadEvents)ctxt.get(DOWNLOAD_CONTEXT_KEY);
        if (events != null) {
            return events.getFire();
        }
        return NULL_FIRE;
    }

    public static DownloadEvents getDownloadEvents(IDownloadContext ctxt) {
        DownloadEvents events = (DownloadEvents)ctxt.get(DOWNLOAD_CONTEXT_KEY);
        if (events == null) {
            events = new DownloadEvents();
            ctxt.put(DOWNLOAD_CONTEXT_KEY, events);
        }
        return events;
    }

    public IDownloadListener getFire() {
        return this.MY_FIRE;
    }

    public synchronized void addListener(IDownloadListener listener) {
        if (this.listeners.contains(listener)) {
            return;
        }
        this.listeners.add(listener);
    }

    public synchronized void removeListener(IDownloadListener listener) {
        this.listeners.remove(listener);
    }

    private synchronized IDownloadListener[] getListeners() {
        return this.listeners.toArray(new IDownloadListener[this.listeners.size()]);
    }

    class FireEvents
    implements IDownloadListener {
        FireEvents() {
        }

        @Override
        public void enter(DownloadHandlerRequest request) {
            IDownloadListener[] aListeners;
            log.debug(request);
            IDownloadListener[] iDownloadListenerArray = aListeners = DownloadEvents.this.getListeners();
            int n = aListeners.length;
            int n2 = 0;
            while (n2 < n) {
                IDownloadListener listener = iDownloadListenerArray[n2];
                try {
                    listener.enter(request);
                }
                catch (Throwable t) {
                    log.error(t);
                }
                ++n2;
            }
        }

        @Override
        public void exit(DownloadHandlerRequest request, Object returns) {
            IDownloadListener[] aListeners;
            log.debug("{0} returns {1}", request, returns);
            IDownloadListener[] iDownloadListenerArray = aListeners = DownloadEvents.this.getListeners();
            int n = aListeners.length;
            int n2 = 0;
            while (n2 < n) {
                IDownloadListener listener = iDownloadListenerArray[n2];
                try {
                    listener.exit(request, returns);
                }
                catch (Throwable t) {
                    log.error(t);
                }
                ++n2;
            }
        }

        @Override
        public void beforeSendRequest(IDownloadListener.Access access) {
            IDownloadListener[] aListeners;
            log.debug(access);
            IDownloadListener[] iDownloadListenerArray = aListeners = DownloadEvents.this.getListeners();
            int n = aListeners.length;
            int n2 = 0;
            while (n2 < n) {
                IDownloadListener listener = iDownloadListenerArray[n2];
                try {
                    listener.beforeSendRequest(access);
                }
                catch (Throwable t) {
                    log.error(t);
                }
                ++n2;
            }
        }

        @Override
        public void receivedUnauthorizedResponse(IDownloadListener.Access access) {
            IDownloadListener[] aListeners;
            log.debug(access);
            IDownloadListener[] iDownloadListenerArray = aListeners = DownloadEvents.this.getListeners();
            int n = aListeners.length;
            int n2 = 0;
            while (n2 < n) {
                IDownloadListener listener = iDownloadListenerArray[n2];
                try {
                    listener.receivedUnauthorizedResponse(access);
                }
                catch (Throwable t) {
                    log.error(t);
                }
                ++n2;
            }
        }

        @Override
        public void receivedResponse(IDownloadListener.Access access, Object received) {
            IDownloadListener[] aListeners;
            log.debug("{0}\nreceived:{1}", access, received);
            IDownloadListener[] iDownloadListenerArray = aListeners = DownloadEvents.this.getListeners();
            int n = aListeners.length;
            int n2 = 0;
            while (n2 < n) {
                IDownloadListener listener = iDownloadListenerArray[n2];
                try {
                    listener.receivedResponse(access, received);
                }
                catch (Throwable t) {
                    log.error(t);
                }
                ++n2;
            }
        }

        @Override
        public void sendRequestException(IDownloadListener.Access access, Exception e) {
            IDownloadListener[] aListeners;
            log.debug("{0}", access, e);
            IDownloadListener[] iDownloadListenerArray = aListeners = DownloadEvents.this.getListeners();
            int n = aListeners.length;
            int n2 = 0;
            while (n2 < n) {
                IDownloadListener listener = iDownloadListenerArray[n2];
                try {
                    listener.sendRequestException(access, e);
                }
                catch (Throwable t) {
                    log.error(t);
                }
                ++n2;
            }
        }

        @Override
        public void sendRequestCanceled(IDownloadListener.Access access) {
            IDownloadListener[] aListeners;
            log.debug(access);
            IDownloadListener[] iDownloadListenerArray = aListeners = DownloadEvents.this.getListeners();
            int n = aListeners.length;
            int n2 = 0;
            while (n2 < n) {
                IDownloadListener listener = iDownloadListenerArray[n2];
                try {
                    listener.sendRequestCanceled(access);
                }
                catch (Throwable t) {
                    log.error(t);
                }
                ++n2;
            }
        }

        @Override
        public void openReadingStream(IDownloadListener.Access access) {
            IDownloadListener[] aListeners;
            log.debug(access);
            IDownloadListener[] iDownloadListenerArray = aListeners = DownloadEvents.this.getListeners();
            int n = aListeners.length;
            int n2 = 0;
            while (n2 < n) {
                IDownloadListener listener = iDownloadListenerArray[n2];
                try {
                    listener.openReadingStream(access);
                }
                catch (Throwable t) {
                    log.error(t);
                }
                ++n2;
            }
        }

        @Override
        public void closeReadingStream(IDownloadListener.Access access) {
            IDownloadListener[] aListeners;
            log.debug(access);
            IDownloadListener[] iDownloadListenerArray = aListeners = DownloadEvents.this.getListeners();
            int n = aListeners.length;
            int n2 = 0;
            while (n2 < n) {
                IDownloadListener listener = iDownloadListenerArray[n2];
                try {
                    listener.closeReadingStream(access);
                }
                catch (Throwable t) {
                    log.error(t);
                }
                ++n2;
            }
        }

        @Override
        public void startReadingStream(IDownloadListener.Access access) {
            IDownloadListener[] aListeners;
            log.debug(access);
            IDownloadListener[] iDownloadListenerArray = aListeners = DownloadEvents.this.getListeners();
            int n = aListeners.length;
            int n2 = 0;
            while (n2 < n) {
                IDownloadListener listener = iDownloadListenerArray[n2];
                try {
                    listener.startReadingStream(access);
                }
                catch (Throwable t) {
                    log.error(t);
                }
                ++n2;
            }
        }

        @Override
        public void endReadingStream(IDownloadListener.Access access) {
            IDownloadListener[] aListeners;
            log.debug(access);
            IDownloadListener[] iDownloadListenerArray = aListeners = DownloadEvents.this.getListeners();
            int n = aListeners.length;
            int n2 = 0;
            while (n2 < n) {
                IDownloadListener listener = iDownloadListenerArray[n2];
                try {
                    listener.endReadingStream(access);
                }
                catch (Throwable t) {
                    log.error(t);
                }
                ++n2;
            }
        }
    }
}

