/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.downloads;

import com.ibm.cic.common.core.auth.AuthorizationInfo;
import com.ibm.cic.common.core.internal.ComIbmCicCommonCorePlugin;
import com.ibm.cic.common.core.internal.downloads.CredentialStoreEntry;
import com.ibm.cic.common.core.internal.downloads.CredentialStoreParser;
import com.ibm.cic.common.core.preferences.CicCommonSettings;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.XMLWriter;
import com.ibm.cic.common.downloads.AbstractHostInfo;
import com.ibm.cic.common.downloads.CredentialInfo;
import com.ibm.cic.common.downloads.CredentialRequested;
import com.ibm.cic.common.downloads.CredentialTarget;
import com.ibm.cic.common.downloads.handlerImpl.DownloadHandlerUtil;
import com.ibm.cic.common.logging.Logger;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.EventListener;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.equinox.security.storage.StorageException;
import org.xml.sax.SAXException;

public class CredentialStore {
    private static final Logger log = Logger.getLogger(CredentialStore.class);
    public static final CredentialStore INSTANCE = new CredentialStore();
    private static final String EXT_BAK = ".bak";
    private static CicMultiStatus status = Statuses.ST.createMultiStatus();
    private static List entries = null;
    private static IPath file = null;
    private boolean fCStoreOff;
    public static final String PROP_NO_PERSIST = "cic.cstore.off";
    private final ListenerList listeners = new ListenerList();

    static {
        CredentialStore.initialize();
    }

    private static void initialize() {
        CredentialStoreParser parser = new CredentialStoreParser(ComIbmCicCommonCorePlugin.getBundleContext(), ComIbmCicCommonCorePlugin.getPluginId());
        file = CicCommonSettings.getApplicationCredentialStoreLocation();
        try {
            parser.parse(file);
            entries = (List)parser.getRootObject();
        }
        catch (FileNotFoundException fileNotFoundException) {
            log.info("Store does not exist. Creating a new store...");
            entries = Collections.synchronizedList(new LinkedList());
        }
        catch (SAXException e) {
            try {
                FileUtil.renameTo(new File(file.toOSString()), new File(String.valueOf(file.toOSString()) + EXT_BAK), true);
            }
            catch (IOException e1) {
                status.add(Statuses.ST.createMultiStatus(-1, e, "Please remove following file and restart: " + file.toOSString(), new Object[0]));
                e1.printStackTrace();
            }
            entries = Collections.synchronizedList(new LinkedList());
        }
        catch (Exception e) {
            log.error(e);
            status = Statuses.ST.createMultiStatus(-1, e, "Unknown error while initializing credential store", new Object[0]);
            entries = Collections.synchronizedList(new LinkedList());
        }
    }

    private CredentialStore() {
        this.fCStoreOff = System.getProperties().containsKey(PROP_NO_PERSIST);
    }

    public void setNoWrite(boolean value) {
        this.fCStoreOff = value;
    }

    public CredentialInfo retrieveCredentials(AbstractHostInfo hostInfo, CredentialRequested requested, CredentialTarget credTarget) {
        Map platformInfo = this.retrieveCredentialsCheckBackwardCompatibility(hostInfo, requested, credTarget);
        if (platformInfo == null) {
            return CredentialInfo.NONE;
        }
        this.updateEntry(requested, credTarget);
        return new CredentialInfo(platformInfo);
    }

    private Map retrieveCredentialsCheckBackwardCompatibility(AbstractHostInfo hostInfo, CredentialRequested requested, CredentialTarget credTarget) {
        CredentialTarget target;
        Map platformInfo = AuthorizationInfo.getAuthorizationInfo(credTarget.getUrl(), credTarget.getRealm(), credTarget.getAuthScheme());
        if (platformInfo == null && AuthorizationInfo.isLegacyKeyringActive() && (platformInfo = AuthorizationInfo.getAuthorizationInfo((target = CredentialTarget.makeFromRequest1003(hostInfo, requested)).getUrl(), target.getRealm(), target.getAuthScheme())) != null) {
            if (this.storeCredentials(requested, credTarget, new CredentialInfo(platformInfo))) {
                this.removeCredentials(requested, target);
            } else {
                log.error("Unable to upgrade legacy keyring file from 1.0.0.3 format");
            }
        }
        return platformInfo;
    }

    public boolean storeCredentials(CredentialRequested requested, CredentialTarget credTarget, CredentialInfo credentials) {
        if (DownloadHandlerUtil.traceProxySettings.enabled) {
            DownloadHandlerUtil.traceProxySettings.println("CredentialStore: saving credentials ''{0}'' for ''{1}''", credentials.toString(), credTarget.toString());
        }
        try {
            AuthorizationInfo.addAuthorizationInfo(credTarget.getUrl(), credTarget.getRealm(), credTarget.getAuthScheme(), credentials.getInfoMap());
            this.updateEntry(requested, credTarget);
            return true;
        }
        catch (CoreException e) {
            log.status(e.getStatus());
        }
        catch (StorageException e) {
            log.status(e.getMessage(), null);
        }
        return false;
    }

    public boolean removeCredentials(CredentialRequested requested, CredentialTarget credTarget) {
        if (DownloadHandlerUtil.traceProxySettings.enabled) {
            DownloadHandlerUtil.traceProxySettings.println("CredentialStore: removing credentials for ''{0}''", credTarget.toString());
        }
        try {
            AuthorizationInfo.flushAuthorizationInfo(credTarget.getUrl(), credTarget.getRealm(), credTarget.getAuthScheme());
            this.removeEntry(requested, credTarget);
            return true;
        }
        catch (CoreException e) {
            log.status(e.getStatus());
            return false;
        }
    }

    private void fireRemovedAllCredentials() {
        Object[] list;
        Object[] objectArray = list = this.listeners.getListeners();
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            ((ICredentialStoreListener)element).clearCachedCredentials();
            ++n2;
        }
    }

    public boolean removeAllCredentials() {
        int i = entries.size() - 1;
        while (i >= 0) {
            CredentialStoreEntry entry = (CredentialStoreEntry)entries.get(i);
            try {
                AuthorizationInfo.flushAuthorizationInfo(new URL(entry.getProtocol(), entry.getHost(), entry.getPort(), ""), entry.getRealm(), entry.isProxy() ? "" : entry.getScheme());
                entries.remove(i);
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (CoreException e) {
                log.status(e.getStatus());
            }
            --i;
        }
        this.writeEntries();
        this.fireRemovedAllCredentials();
        return entries.size() == 0;
    }

    public boolean isAnyCredentialSaved() {
        boolean flag = entries.size() > 0;
        Object[] list = this.listeners.getListeners();
        int j = 0;
        while (!flag && j < list.length) {
            flag |= ((ICredentialStoreListener)list[j]).isAnyCredentialSaved();
            ++j;
        }
        return flag;
    }

    public void addCredentialStoreListener(ICredentialStoreListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeCredentialStoreListener(ICredentialStoreListener listener) {
        this.listeners.remove((Object)listener);
    }

    private void updateEntry(CredentialRequested requested, CredentialTarget target) {
        CredentialStoreEntry entry;
        int i;
        if (requested != null && (i = entries.lastIndexOf(entry = CredentialStoreEntry.create(target.getUrl(), target.getRealm(), requested.getScheme(), requested.isProxy()))) == -1) {
            entries.add(entry);
            this.writeEntries();
        }
    }

    private void removeEntry(CredentialRequested requested, CredentialTarget target) {
        CredentialStoreEntry entry;
        int i;
        if (requested != null && (i = entries.lastIndexOf(entry = CredentialStoreEntry.create(target.getUrl(), target.getRealm(), requested.getScheme(), requested.isProxy()))) > -1) {
            entries.remove(entry);
            this.writeEntries();
        }
    }

    private synchronized void writeEntries() {
        if (this.fCStoreOff) {
            return;
        }
        if (!status.isOK()) {
            log.error("Credential store can not be updated");
            log.error(status.getMessage());
            return;
        }
        try {
            new FileUtil.SafeUpdate(new File(file.toOSString())){

                @Override
                public void write(FileOutputStream stream) throws IOException {
                    XMLWriter writer = new XMLWriter((OutputStream)stream, new XMLWriter.ProcessingInstruction[0]);
                    CredentialStore.this.writeEntries(writer);
                    writer.flush();
                    FileUtil.fdSync(stream.getFD());
                    writer.close();
                }
            }.write();
        }
        catch (IOException e) {
            log.error("Unable to update credential store");
            log.error(e);
        }
    }

    protected void writeEntries(XMLWriter writer) {
        if (this.fCStoreOff) {
            return;
        }
        writer.start("store");
        int i = 0;
        while (i < entries.size()) {
            CredentialStoreEntry entry = (CredentialStoreEntry)entries.get(i);
            writer.start("entry");
            writer.start("protocol");
            writer.cdata(entry.getProtocol());
            writer.end();
            writer.start("host");
            writer.cdata(entry.getHost());
            writer.end();
            writer.start("port");
            writer.cdata(String.valueOf(entry.getPort()));
            writer.end();
            writer.start("realm");
            writer.cdata(entry.getRealm());
            writer.end();
            writer.start("scheme");
            writer.cdata(entry.getScheme());
            writer.end();
            writer.start("proxy");
            writer.cdata(entry.getProxyType().toString());
            writer.end();
            writer.end();
            ++i;
        }
        writer.end();
    }

    public void clearCache() {
        this.fireRemovedAllCredentials();
        CredentialStore.initialize();
    }

    public boolean isCredentialInKeyring(CredentialTarget ct) {
        try {
            Map authInfo;
            Map map = authInfo = ct == null ? AuthorizationInfo.getAuthorizationInfo(new URL("http://www.ibm.com"), "", "") : AuthorizationInfo.getAuthorizationInfo(ct.getUrl(), ct.getRealm(), ct.getAuthScheme());
            return authInfo != null;
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
    }

    public static interface ICredentialStoreListener
    extends EventListener {
        public void clearCachedCredentials();

        public boolean isAnyCredentialSaved();
    }
}

