/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.downloads;

import com.ibm.cic.common.core.internal.downloads.DownloadBadRangeImplentationTooManyBytesException;
import com.ibm.cic.common.core.internal.downloads.DownloadUnexpectedTotalSizeException;
import com.ibm.cic.common.core.internal.downloads.Messages;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.downloads.ByteRange;
import com.ibm.cic.common.downloads.DownloadByteRangeOutOfBoundsException;
import com.ibm.cic.common.downloads.DownloadPrematureEOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ByteRangeMonitorInputStream
extends FilterInputStream {
    protected String source;
    protected ByteRange requestedRange;
    protected ByteRange effectiveRange;
    protected long actualSize;
    protected long retrieved;
    protected boolean atEof;

    public static void checkForStartOutOfBoundsException(String source, ByteRange requestedRange, long actualSize, Exception cause) throws DownloadByteRangeOutOfBoundsException {
        if (actualSize != -1L && requestedRange.getStart() >= actualSize) {
            String msg = NLS.bind(Messages.ByteRangeMonitorInputStream_startBeyondActualSize, source, requestedRange, actualSize);
            throw new DownloadByteRangeOutOfBoundsException(msg, actualSize, cause);
        }
    }

    public static ByteRange checkAndGetEffectiveRange(String source, ByteRange requestedRange, long actualSize) throws DownloadUnexpectedTotalSizeException, DownloadByteRangeOutOfBoundsException {
        assert (source != null);
        assert (requestedRange != null);
        ByteRange effectiveRange = requestedRange;
        if (actualSize != -1L) {
            if (effectiveRange.getEnd() == -1L) {
                effectiveRange = ByteRange.remainingRange(effectiveRange.getStart(), actualSize);
            }
            if (effectiveRange.extendsToSpecifiedEOF() && actualSize != effectiveRange.getEnd()) {
                String msg = NLS.bind(Messages.ByteRangeMonitorInputStream_requestedSizeConflictsWithActualSize, source, effectiveRange, actualSize);
                throw new DownloadUnexpectedTotalSizeException(msg, actualSize, null);
            }
            if (effectiveRange.hasSpecifiedEnd() && effectiveRange.getEnd() > actualSize) {
                String msg = NLS.bind(Messages.ByteRangeMonitorInputStream_requestedEndBeyondActualSize, source, requestedRange, actualSize);
                throw new DownloadByteRangeOutOfBoundsException(msg, actualSize, null);
            }
            assert (effectiveRange.getEnd() <= actualSize);
        }
        return effectiveRange;
    }

    public static ByteRangeMonitorInputStream checkAndWrap(String source, InputStream in, ByteRange requestedRange, long actualSize) throws DownloadUnexpectedTotalSizeException, DownloadByteRangeOutOfBoundsException {
        ByteRange effectiveRange = ByteRangeMonitorInputStream.checkAndGetEffectiveRange(source, requestedRange, actualSize);
        return ByteRangeMonitorInputStream.wrap(source, in, requestedRange, effectiveRange, actualSize);
    }

    public static ByteRangeMonitorInputStream wrap(String source, InputStream in, ByteRange requestedRange, ByteRange effectiveRange, long actualSize) {
        return new ByteRangeMonitorInputStream(source, in, requestedRange, effectiveRange, actualSize);
    }

    protected ByteRangeMonitorInputStream(String source, InputStream in, ByteRange requestedRange, ByteRange effectiveRange, long actualSize) {
        super(in);
        assert (source != null);
        assert (requestedRange != null);
        assert (effectiveRange != null);
        this.source = source;
        this.requestedRange = requestedRange;
        this.effectiveRange = effectiveRange;
        this.actualSize = actualSize;
        this.retrieved = 0L;
        this.atEof = false;
    }

    public ByteRange getEffectiveRange() {
        return this.effectiveRange;
    }

    public ByteRange getRequestedRange() {
        return this.requestedRange;
    }

    protected void doCloseAtEOF() throws IOException {
        super.close();
    }

    protected void doCloseBeforeEOF() throws IOException {
        super.close();
    }

    @Override
    public void close() throws IOException {
        if (this.atEof) {
            this.doCloseAtEOF();
        } else {
            this.doCloseBeforeEOF();
        }
    }

    @Override
    public void mark(int readlimit) {
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    private int noticeRead(int rc) throws DownloadBadRangeImplentationTooManyBytesException, DownloadPrematureEOFException {
        return this.noticeRead(rc, rc);
    }

    private int noticeRead(int rc, int len) throws DownloadBadRangeImplentationTooManyBytesException, DownloadPrematureEOFException {
        if (rc == -1) {
            this.atEof = true;
            int reasons = 0;
            if (this.retrieved == 0L && !this.effectiveRange.hasSpecifiedEnd()) {
                reasons |= 4;
            }
            if (this.requestedRange.hasSpecifiedEnd() && this.retrieved < this.requestedRange.size()) {
                reasons = 2;
            }
            if (this.actualSize != -1L) {
                assert (this.effectiveRange.hasSpecifiedEnd());
                assert (this.effectiveRange.getEnd() <= this.actualSize);
                if (this.retrieved < this.effectiveRange.size()) {
                    reasons |= 1;
                }
            }
            if (reasons != 0) {
                String reasonString = DownloadPrematureEOFException.reasonsAsString(reasons);
                String msg = this.actualSize != -1L ? NLS.bind(Messages.ByteRangeMonitorInputStream_prematureEOF, this.source, this.requestedRange, this.actualSize, this.retrieved, reasonString) : NLS.bind(Messages.ByteRangeMonitorInputStream_prematureEOFUnknownActualSize, this.source, this.requestedRange, this.retrieved, reasonString);
                throw new DownloadPrematureEOFException(reasons, msg, null);
            }
        } else if (len != -1) {
            this.retrieved += (long)len;
            if (this.effectiveRange.hasSpecifiedEnd() && this.effectiveRange.getStart() + this.retrieved > this.effectiveRange.getEnd()) {
                String msg = NLS.bind(Messages.ByteRangeMonitorInputStream_moreBytesRetrievedThanRequested, this.source, this.effectiveRange, this.retrieved);
                throw new DownloadBadRangeImplentationTooManyBytesException(msg, null);
            }
        }
        return rc;
    }

    @Override
    public int read() throws IOException {
        return this.noticeRead(this.in.read(), 1);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.noticeRead(this.in.read(b, off, len));
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.noticeRead(this.in.read(b));
    }

    @Override
    public long skip(long n) throws IOException {
        return this.in.skip(n);
    }
}

