/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.utils;

import com.ibm.cic.common.core.utils.Comparators;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Version;

public class VersionUtil {
    public static final VersionRange EMPTY_RANGE = new VersionRange(Version.emptyVersion, true, Version.emptyVersion, false);
    public static final VersionRange UNSPECIFIED_TOLERANCE = VersionUtil.createExactTolerance(Version.emptyVersion);

    public static boolean isEmptyRange(VersionRange range) {
        return range == EMPTY_RANGE || VersionUtil.isEmptyRange(range.getMinimum(), range.getIncludeMinimum(), range.getRight(), range.getIncludeMaximum());
    }

    public static VersionRange computeUnion(VersionRange range1, VersionRange range2) {
        if (range1.equals((Object)range2)) {
            return range1;
        }
        VersionRange lMin = VersionUtil.greaterMinimum(range1, range2) ? range2 : range1;
        VersionRange gMax = VersionUtil.greaterMaximum(range1, range2) ? range1 : range2;
        return lMin == gMax ? lMin : VersionUtil.createVersionRange(lMin.getMinimum(), lMin.getIncludeMinimum(), gMax.getRight(), gMax.getIncludeMaximum());
    }

    public static VersionRange computeIntersection(VersionRange range1, VersionRange range2) {
        VersionRange gMin = VersionUtil.computeGreaterMinimum(range1, range2);
        VersionRange lMax = VersionUtil.computeLesserMaximum(range1, range2);
        return VersionUtil.createVersionRange(gMin.getMinimum(), gMin.getIncludeMinimum(), lMax.getRight(), lMax.getIncludeMaximum());
    }

    public static boolean hasIntersection(VersionRange range1, VersionRange range2) {
        VersionRange gMin = VersionUtil.computeGreaterMinimum(range1, range2);
        VersionRange lMax = VersionUtil.computeLesserMaximum(range1, range2);
        return !VersionUtil.isEmptyRange(gMin.getMinimum(), gMin.getIncludeMinimum(), lMax.getRight(), lMax.getIncludeMaximum());
    }

    public static VersionRange lowerComplement(VersionRange range1, VersionRange range2) {
        VersionRange lMin = VersionUtil.computeLesserMinimum(range1, range2);
        if (VersionUtil.hasIntersection(range1, range2)) {
            VersionRange gMin = VersionUtil.computeGreaterMinimum(range1, range2);
            return VersionUtil.createVersionRange(lMin.getMinimum(), lMin.getIncludeMinimum(), gMin.getMinimum(), !gMin.getIncludeMinimum());
        }
        return lMin;
    }

    public static VersionRange upperComplement(VersionRange range1, VersionRange range2) {
        VersionRange gMax = VersionUtil.computeGreaterMaximum(range1, range2);
        if (VersionUtil.hasIntersection(range1, range2)) {
            VersionRange lMax = VersionUtil.computeLesserMaximum(range1, range2);
            return VersionUtil.createVersionRange(lMax.getRight(), !lMax.getIncludeMaximum(), gMax.getRight(), gMax.getIncludeMaximum());
        }
        return gMax;
    }

    public static int compareToIgnoreQualifier(Version x, Version y) {
        if (x == null) {
            return y == null ? 0 : 1;
        }
        if (y == null) {
            return -1;
        }
        int result = x.getMajor() - y.getMajor();
        if (result != 0) {
            return result;
        }
        result = x.getMinor() - y.getMinor();
        if (result != 0) {
            return result;
        }
        return x.getMicro() - y.getMicro();
    }

    public static VersionRange replaceMinimumForVersion(Version min, VersionRange tolerance) {
        return new VersionRange(VersionUtil.removeQualifier(min), true, tolerance.getRight(), tolerance.getIncludeMaximum());
    }

    public static VersionRange createExactTolerance(Version version) {
        return new VersionRange(version, true, version, true);
    }

    public static VersionRange getDefaultTolerance(Version version) {
        if (version == null) {
            return null;
        }
        if (Version.emptyVersion.equals((Object)version)) {
            return UNSPECIFIED_TOLERANCE;
        }
        Version minVersion = VersionUtil.removeQualifier(version);
        Version maxVersion = new Version(version.getMajor() + 1, 0, 0);
        return new VersionRange(minVersion, true, maxVersion, false);
    }

    public static VersionRange getAllowQualiferChangesTolerance(Version version) {
        if (version == null) {
            return null;
        }
        if (Version.emptyVersion.equals((Object)version)) {
            return UNSPECIFIED_TOLERANCE;
        }
        Version minVersion = VersionUtil.removeQualifier(version);
        Version maxVersion = new Version(version.getMajor(), version.getMinor(), version.getMicro() + 1);
        return new VersionRange(minVersion, true, maxVersion, false);
    }

    public static Version removeQualifier(Version version) {
        return version.getQualifier().length() == 0 ? version : new Version(version.getMajor(), version.getMinor(), version.getMicro());
    }

    public static String toExternalVersion(Version version) {
        int micro = version.getMicro();
        StringBuilder sb = new StringBuilder();
        sb.append(version.getMajor()).append('.').append(version.getMinor()).append('.').append(micro / 1000);
        if ((micro %= 1000) > 0) {
            sb.append('.').append(micro);
        }
        return sb.toString();
    }

    public static boolean isIncluded(VersionRange range, Version version) {
        if (range.isEmpty()) {
            return false;
        }
        if (Comparators.compare(range.getMinimum(), version) >= (range.getIncludeMinimum() ? 1 : 0)) {
            return false;
        }
        Version right = range.getRight();
        if (right == null) {
            return true;
        }
        return Comparators.compare(right, version) >= (range.getIncludeMaximum() ? 0 : 1);
    }

    private static VersionRange computeLesserMinimum(VersionRange range1, VersionRange range2) {
        return VersionUtil.greaterMinimum(range1, range2) ? range2 : range1;
    }

    private static VersionRange computeGreaterMinimum(VersionRange range1, VersionRange range2) {
        return VersionUtil.greaterMinimum(range1, range2) ? range1 : range2;
    }

    private static VersionRange computeLesserMaximum(VersionRange range1, VersionRange range2) {
        return VersionUtil.greaterMaximum(range1, range2) ? range2 : range1;
    }

    private static VersionRange computeGreaterMaximum(VersionRange range1, VersionRange range2) {
        return VersionUtil.greaterMaximum(range1, range2) ? range1 : range2;
    }

    private static boolean greaterMinimum(VersionRange range1, VersionRange range2) {
        int cmp = range1.getMinimum().compareTo(range2.getMinimum());
        return cmp > 0 || cmp == 0 && !range1.getIncludeMinimum() && range2.getIncludeMinimum();
    }

    private static boolean greaterMaximum(VersionRange range1, VersionRange range2) {
        int cmp = Comparators.compare(range1.getRight(), range2.getRight());
        return cmp > 0 || cmp == 0 && range1.getIncludeMaximum() && !range2.getIncludeMaximum();
    }

    private static VersionRange createVersionRange(Version minimum, boolean includeMinimum, Version maximum, boolean includeMaximum) {
        if (VersionUtil.isEmptyRange(minimum, includeMinimum, maximum, includeMaximum)) {
            return null;
        }
        return new VersionRange(minimum, includeMinimum, maximum, includeMaximum);
    }

    private static boolean isEmptyRange(Version minimum, boolean includeMinimum, Version maximum, boolean includeMaximum) {
        int cmp = Comparators.compare(minimum, maximum);
        return cmp > 0 || cmp == 0 && (!includeMinimum || !includeMaximum);
    }
}

