/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.utils;

import com.ibm.cic.common.core.internal.utils.RefCount;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.logging.ExceptionUtil;
import com.ibm.cic.common.logging.Logger;
import com.ibm.icu.util.GregorianCalendar;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;

public class TempUtil {
    private static final Logger log = Logger.getLogger(TempUtil.class);
    public static final String JAVA_IO_TMPDIR = "java.io.tmpdir";
    private static final FolderTracker folderTracker = new FolderTracker();
    private static String uniqueifier = null;
    public static final int MASK_USE_UNIQUIFIER = 1;
    public static final int MASK_USE_TIME = 2;
    public static final int MASK_USE_TIME_IF_UNIQUEIFIER_NULL = 4;
    public static final int MASK_DONT_UNIQUIFY = 8;

    @Deprecated
    public static void resetFolderTracker() {
        folderTracker.reset();
    }

    public static File getJavaTempDir() throws CoreException {
        final JavaTempDir jtd = new JavaTempDir();
        return new File(jtd.getTmpDir().toString()){

            @Override
            public boolean delete() {
                boolean deleted = super.delete();
                try {
                    jtd.cleanEmptyDirs();
                }
                catch (IOException e) {
                    log.debug(e);
                }
                return deleted;
            }
        };
    }

    public static File createTempFile(String prefix, String simpleName) throws IOException, CoreException {
        final JavaTempDir jtmpDir = new JavaTempDir();
        File file = TempUtil.doCreateTempFile(prefix, simpleName, jtmpDir.getTmpDir());
        return new File(file.toString()){

            @Override
            public boolean delete() {
                boolean rc = super.delete();
                try {
                    jtmpDir.cleanEmptyDirs();
                }
                catch (IOException e) {
                    log.debug(e);
                }
                return rc;
            }
        };
    }

    private static File doCreateTempFile(String prefix, String simpleName, File tmpDir) throws IOException {
        Path path = new Path(simpleName);
        String ext = path.getFileExtension();
        File tempFile = File.createTempFile(String.valueOf(prefix) + simpleName, ext, tmpDir);
        return tempFile;
    }

    public static File createTempFile(String prefix, String simpleName, File tmpDir) throws IOException {
        assert (tmpDir != null);
        FileUtil.checkDirectoryExistsAndWritable(tmpDir);
        File tempFile = TempUtil.doCreateTempFile(prefix, simpleName, tmpDir);
        return tempFile;
    }

    private static String getDateTimeForFileName(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        StringBuffer sb = new StringBuffer(15);
        calendar.setTime(date);
        sb.append(calendar.get(1));
        TempUtil.appendInt2(sb, calendar.get(2) + 1);
        TempUtil.appendInt2(sb, calendar.get(5));
        sb.append('_');
        TempUtil.appendInt2(sb, calendar.get(11));
        TempUtil.appendInt2(sb, calendar.get(12));
        return sb.toString();
    }

    private static File getDateStampedFile(File dir, String simpleName, String extension, String dateStamp, int n) {
        StringBuffer sb = new StringBuffer(simpleName.length() + extension.length() + 20);
        sb.append(simpleName);
        sb.append('_');
        sb.append(dateStamp);
        if (n > 0) {
            TempUtil.appendInt2(sb, n);
        }
        sb.append(extension);
        File f = new File(dir, sb.toString());
        return f;
    }

    private static File getOverwriteBackupFile(File f) {
        File dir = f.getParentFile();
        Path path = new Path(f.toString());
        String simpleName = path.removeFileExtension().lastSegment();
        String extension = path.getFileExtension();
        extension = extension == null ? "" : "." + extension;
        String dateStamp = TempUtil.getDateTimeForFileName(new Date());
        int i = 0;
        File file;
        while ((file = TempUtil.getDateStampedFile(dir, simpleName, extension, dateStamp, i)).exists()) {
            ++i;
        }
        return file;
    }

    public static File backupBeforeOverwriting(File f) throws IOException {
        File saveTo = TempUtil.getOverwriteBackupFile(f);
        try {
            FileUtil.renameTo(f, saveTo, false);
            return saveTo;
        }
        catch (IOException e) {
            f.delete();
            throw e;
        }
    }

    private static StringBuffer appendInt2(StringBuffer sb, int i) {
        if (i < 10) {
            sb.append('0');
        }
        sb.append(i);
        return sb;
    }

    public static void setUniqueifier(String unique) {
        uniqueifier = unique;
    }

    public static String getUniqueifier() {
        return uniqueifier;
    }

    public static UniqueTempDir getUniqueTempDir(File baseDir, String dirName) {
        return TempUtil.getUniqueTempDir(baseDir, dirName, 5);
    }

    public static UniqueTempDir getUniqueTempDir(File baseDir, String dirName, int bitMask) {
        File base = baseDir != null ? baseDir : new File(System.getProperty(JAVA_IO_TMPDIR));
        boolean dontUniqueify = (bitMask & 8) != 0;
        StringBuffer sb = new StringBuffer(uniqueifier != null ? uniqueifier.length() + 20 : 20);
        if (!dontUniqueify) {
            boolean useUniqueifier = (bitMask & 1) != 0;
            boolean useTime = (bitMask & 2) != 0;
            boolean useIfUniquefierNull = (bitMask & 4) != 0;
            String time = null;
            if (useUniqueifier) {
                if (uniqueifier == null) {
                    if (useIfUniquefierNull) {
                        time = String.valueOf(System.currentTimeMillis());
                        sb.append(time);
                    }
                } else {
                    sb.append(uniqueifier);
                }
            }
            if (useTime && time == null) {
                time = String.valueOf(System.currentTimeMillis());
                sb.append(time);
            }
        }
        String u = sb.toString();
        String user = System.getProperty("user.name");
        String dirNameUsed = dirName;
        if (user != null && user.length() > 0) {
            dirNameUsed = String.valueOf(dirNameUsed) + "_" + user;
        }
        if (u.length() > 0) {
            return new UniqueTempDir(base, String.valueOf(dirNameUsed) + '/' + u);
        }
        return new UniqueTempDir(base, dirNameUsed);
    }

    public static UniqueTempDir getTempDirRelatedToExistingDir(File dir, String prefixPath, List attempts) {
        StringBuffer name = new StringBuffer(prefixPath);
        int simpleLen = name.length();
        UniqueTempDir utd = TempUtil.mkRelatedTempDir(dir, name.toString(), attempts);
        if (utd != null) {
            return utd;
        }
        char c = 'a';
        while (c != '{') {
            name.setLength(simpleLen);
            name.append('_');
            name.append(c);
            utd = TempUtil.mkRelatedTempDir(dir, name.toString(), attempts);
            if (utd != null) {
                return utd;
            }
            c = (char)(c + '\u0001');
        }
        return null;
    }

    private static UniqueTempDir mkRelatedTempDir(File dir, String name, List attempts) {
        UniqueTempDir utd;
        block5: {
            utd = new UniqueTempDir(dir, name);
            try {
                if (!utd.getUniqueTempDir().exists()) break block5;
                if (attempts != null) {
                    attempts.add(utd.getUniqueTempDir());
                }
                return null;
            }
            catch (CoreException coreException) {
                if (attempts != null) {
                    attempts.add(utd.getUniqueTempDir());
                }
                return null;
            }
        }
        utd.create();
        return utd;
    }

    private static class CreateDirHelper {
        private final File base;
        private final File dir;
        private int releaseCalledCount = 0;

        CreateDirHelper(File base) {
            this(base, "");
        }

        CreateDirHelper(File base, String path) {
            this.base = FileUtil.getCanonicalFile(base);
            this.dir = path.isEmpty() ? this.base : new File(this.base, path);
            this.mkdirs(this.dir);
        }

        private boolean mkdirs(File d) {
            if (d.exists()) {
                folderTracker.useFolder(d, false);
                this.markUsageContainers(d);
                return true;
            }
            boolean created = d.mkdir();
            if (created) {
                folderTracker.useFolder(d, created);
                this.markUsageContainers(d);
                return true;
            }
            File p = d.getParentFile();
            if (p == null) {
                return false;
            }
            this.mkdirs(p);
            if (p.exists()) {
                created = d.mkdir();
                if (created) {
                    folderTracker.useFolder(d, created);
                }
                return created;
            }
            return false;
        }

        private void markUsageContainers(File d) {
            File f = d;
            while (!f.equals(this.base)) {
                if ((f = f.getParentFile()) == null) {
                    return;
                }
                folderTracker.useFolder(f, false);
            }
        }

        boolean cleanEmptyDirs() throws IOException {
            File f = this.dir;
            boolean success = true;
            while (f != null && !f.equals(this.base)) {
                success &= folderTracker.releaseFolder(f, this.releaseCalledCount);
                f = f.getParentFile();
            }
            ++this.releaseCalledCount;
            return success &= folderTracker.releaseFolder(this.base, this.releaseCalledCount);
        }

        public String toString() {
            return this.dir.toString();
        }
    }

    private static class FolderTracker {
        private Map<File, RefCount> usingDirs = new LinkedHashMap<File, RefCount>();
        private Set<File> createdDirs = new LinkedHashSet<File>();

        private FolderTracker() {
        }

        synchronized void useFolder(File dir, boolean created) {
            assert (dir.isDirectory());
            RefCount rc = this.usingDirs.get(dir);
            if (rc == null) {
                rc = new RefCount(dir);
                this.usingDirs.put(dir, rc);
            } else {
                rc.incrRefCount();
            }
            if (created) {
                this.createdDirs.add(dir);
                log.debug("created {0}", rc);
            } else {
                log.debug("using {0}", rc);
            }
        }

        @Deprecated
        synchronized void reset() {
            this.usingDirs = new LinkedHashMap<File, RefCount>();
            this.createdDirs = new LinkedHashSet<File>();
        }

        synchronized boolean releaseFolder(File dir, int releaseCallCount) throws IOException {
            if (!dir.exists()) {
                log.debug("Dir {0} does not exists when released", dir);
            } else if (!dir.isDirectory()) {
                log.debug("{0} is not a directory when released", dir);
            }
            RefCount rc = this.usingDirs.get(dir);
            if (rc == null) {
                log.debug("Released folder {0} not known", dir);
                return true;
            }
            boolean success = true;
            if (releaseCallCount > 0) {
                success = true;
                if (rc.isZeroRefCount()) {
                    success = this.deleteFolderForgetRefCount(dir, rc);
                }
            } else {
                rc.decrRefCount();
                if (rc.isZeroRefCount()) {
                    success = this.deleteFolderForgetRefCount(dir, rc);
                } else {
                    log.debug("Descreased ref count: {0}", rc);
                    success = true;
                }
            }
            return success;
        }

        private boolean deleteFolderForgetRefCount(File dir, RefCount rc) throws IOException {
            boolean success = this.deleteFolder(dir, rc);
            if (!this.createdDirs.contains(dir)) {
                RefCount rcRemoved = this.usingDirs.remove(dir);
                log.debug("Removed ref count: {0} ", rcRemoved);
            }
            return success;
        }

        private boolean deleteFolder(File dir, RefCount rc) throws IOException {
            boolean success = true;
            boolean createdHere = this.createdDirs.contains(dir);
            if (createdHere) {
                log.debug("Removing {0}", rc);
                FileUtil.deleteEmptyDirs(dir);
                if (!dir.exists()) {
                    this.createdDirs.remove(dir);
                } else {
                    log.debug("Remember as created here: {0} does still exists after attempt to deleteEmptyDirs()", rc);
                    success = false;
                }
            } else {
                log.debug("Not created here: leaving {0} alone", rc);
            }
            return success;
        }
    }

    private static class JavaTempDir {
        private final File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        private final CreateDirHelper ccd = new CreateDirHelper(this.tmpDir);

        JavaTempDir() throws CoreException {
            ICicStatus status = FileUtil.checkDirectoryExistsAndWritable(this.tmpDir);
            if (!status.isOK()) {
                try {
                    this.ccd.cleanEmptyDirs();
                }
                catch (IOException e) {
                    log.error(e);
                }
                throw new CoreException((IStatus)status);
            }
        }

        File getTmpDir() {
            return this.tmpDir;
        }

        void cleanEmptyDirs() throws IOException {
            this.ccd.cleanEmptyDirs();
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("tmpDir=");
            sb.append(this.tmpDir.toString());
            sb.append(" created=");
            sb.append(this.ccd == null);
            return sb.toString();
        }
    }

    public static class UniqueTempDir {
        private final File baseDir;
        private final String path;
        private final File uniqueTempDir;
        private CreateDirHelper ccd;

        protected UniqueTempDir(File baseDir, String path) {
            this.baseDir = baseDir;
            this.path = path;
            this.uniqueTempDir = new File(baseDir, path);
            this.ccd = null;
        }

        public File getBaseDir() {
            return this.baseDir;
        }

        public String getPath() {
            return this.path;
        }

        public File getUniqueTempDir() {
            return this.uniqueTempDir;
        }

        public void create() throws CoreException {
            this.ccd = new CreateDirHelper(this.baseDir, this.path);
            ICicStatus status = FileUtil.checkDirectoryExistsAndWritable(this.uniqueTempDir);
            if (!status.isOK()) {
                try {
                    this.ccd.cleanEmptyDirs();
                }
                catch (IOException e) {
                    log.error(e);
                }
                throw new CoreException((IStatus)status);
            }
        }

        public void ensureCreated() throws CoreException {
            if (this.ccd != null) {
                return;
            }
            this.create();
        }

        public void cleanEmptyDirs() throws IOException {
            if (this.ccd == null) {
                return;
            }
            if (this.ccd.cleanEmptyDirs()) {
                this.ccd = null;
            }
        }

        public void cleanEmptyDirsLogIOE() {
            try {
                this.cleanEmptyDirs();
            }
            catch (IOException e) {
                ExceptionUtil.log.warning(e);
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("baseDir=");
            sb.append(this.baseDir.toString());
            sb.append(" path=");
            sb.append(this.path);
            sb.append(" created=");
            sb.append(this.ccd == null);
            return sb.toString();
        }
    }
}

