/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.utils;

import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.core.utils.Messages;
import com.ibm.cic.common.core.utils.Statuses;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;

public class StatusUtil {
    private static final Pattern XMLAnchorPattern = Pattern.compile("<a\\b[^>]*\\bhref=['\"](.*?)['\"][^>]*>(.*?)</a\\s*>");
    private static final Pattern anchorPattern = Pattern.compile("<a[^>]*?>(.*?)</a>", 32);

    public static boolean isErrorOrCancel(IStatus status) {
        return StatusUtil.isError(status) || StatusUtil.isCancel(status);
    }

    public static boolean isErrorOrWarning(IStatus status) {
        return StatusUtil.isError(status) || StatusUtil.isWarning(status);
    }

    public static void throwIfError(IStatus status) throws CoreException {
        if (StatusUtil.isErrorOrCancel(status)) {
            throw new CoreException(status);
        }
    }

    public static boolean isCancel(IStatus status) {
        return status.matches(8);
    }

    public static boolean isError(IStatus status) {
        return status.matches(4);
    }

    public static boolean isWarning(IStatus status) {
        return status.matches(2);
    }

    public static String getUid(IStatus status) {
        return status instanceof ICicStatus ? ((ICicStatus)status).getUid() : null;
    }

    public static String getExplanation(IStatus status) {
        return status instanceof ICicStatus ? ((ICicStatus)status).getExplanation() : null;
    }

    public static String getUserAction(IStatus status) {
        return status instanceof ICicStatus ? ((ICicStatus)status).getUserAction() : null;
    }

    public static IStatus newStatusKeepOldChildren(IStatus oldStatus, IStatus newStatus) {
        IStatus[] priorChildren = oldStatus.getChildren();
        IStatus[] children = null;
        if (priorChildren.length == 0) {
            return newStatus;
        }
        IStatus[] newChildren = newStatus.getChildren();
        if (newChildren.length == 0) {
            children = priorChildren;
        } else {
            ArrayList<IStatus> all = new ArrayList<IStatus>(priorChildren.length + newChildren.length);
            all.addAll(Arrays.asList(priorChildren));
            all.addAll(Arrays.asList(newChildren));
            children = all.toArray(new IStatus[all.size()]);
        }
        CicMultiStatus ms = Statuses.ST.createMultiStatus(newStatus.getPlugin(), 0, newStatus.getCode(), children, newStatus.getException(), newStatus.getMessage());
        return ms;
    }

    @Deprecated
    public static IStatus getError(String msg) {
        return Statuses.ERROR.get(msg, new Object[0]);
    }

    public static IStatus toSingleStatus(IStatus status) {
        IStatus[] children;
        if (status.isMultiStatus() && (children = status.getChildren()).length == 1) {
            return children[0];
        }
        return status;
    }

    public static IStatus fixMultiStatusNoMsgProblem(IStatus status) {
        String message = status.getMessage();
        if (status.isMultiStatus() && (message == null || message.length() == 0)) {
            IStatus[] children = status.getChildren();
            if (children.length == 1) {
                return children[0];
            }
            if (children.length > 1 && status instanceof CicMultiStatus) {
                CicMultiStatus return_status = (CicMultiStatus)status;
                if (StatusUtil.isErrorOrCancel(status)) {
                    return_status.setMessage(Messages.MultipleErrors);
                } else if (status.matches(2)) {
                    return_status.setMessage(Messages.MultipleWarnings);
                } else if (status.matches(1)) {
                    return_status.setMessage(Messages.MultipleInformations);
                }
                return return_status;
            }
        }
        return status;
    }

    public static ICicStatus convertToCicStatus(IStatus status) {
        if (status instanceof ICicStatus) {
            return (ICicStatus)status;
        }
        if (status.isMultiStatus()) {
            return Statuses.ST.createMultiStatusFromStatus(status);
        }
        return Statuses.ST.createStatus(status, status.getMessage(), new Object[0]);
    }

    public static String severityToString(int severity) {
        switch (severity) {
            case 0: {
                return "OK";
            }
            case 1: {
                return "INFO";
            }
            case 2: {
                return "WARNING";
            }
            case 4: {
                return "ERROR";
            }
            case 8: {
                return "CANCEL";
            }
        }
        return "severity=" + severity;
    }

    public static String toString(IStatus status) {
        StringBuilder sb = new StringBuilder(256);
        StatusUtil.toString(sb, 0, status);
        return sb.toString();
    }

    private static void toString(StringBuilder sb, int indent, IStatus status) {
        int code;
        if (sb.length() > 0) {
            StatusUtil.appendNewline(sb, indent);
        }
        ++indent;
        sb.append(StatusUtil.severityToString(status.getSeverity())).append(':');
        String uid = null;
        String explanation = null;
        String userAction = null;
        if (status instanceof ICicStatus) {
            ICicStatus cicStatus = (ICicStatus)status;
            uid = cicStatus.getUid();
            explanation = cicStatus.getExplanation();
            userAction = cicStatus.getUserAction();
            if (uid != null) {
                sb.append(' ').append(uid);
            }
        }
        if ((code = status.getCode()) != 0 && code != 1 && code != -1) {
            sb.append(" code=").append(code);
        }
        StatusUtil.appendMultiline(sb, indent, null, status.getMessage());
        StatusUtil.appendMultiline(sb, indent, "exception", status.getException());
        StatusUtil.appendMultiline(sb, indent, "explanation", explanation);
        StatusUtil.appendMultiline(sb, indent, "userAction", userAction);
        IStatus[] iStatusArray = status.getChildren();
        int n = iStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus child = iStatusArray[n2];
            StatusUtil.toString(sb, indent, child);
            ++n2;
        }
    }

    private static StringBuilder appendMultiline(StringBuilder sb, int indent, String label, Object object) {
        if (object != null) {
            String text;
            if (label != null) {
                StatusUtil.appendNewline(sb, indent).append(label).append(':');
            }
            if ((text = object.toString()).indexOf(10) < 0) {
                sb.append(' ').append(text);
            } else {
                String[] stringArray = text.split("\\r*\\n");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String line = stringArray[n2];
                    StatusUtil.appendNewline(sb, indent + 1).append(line);
                    ++n2;
                }
            }
        }
        return sb;
    }

    private static StringBuilder appendNewline(StringBuilder sb, int indent) {
        sb.append('\n');
        int i = 0;
        while (i < indent) {
            sb.append("  ");
            ++i;
        }
        return sb;
    }

    public static String combineAnchors(String label) {
        if (label == null || !StatusUtil.hasAnchor(label)) {
            return label;
        }
        Matcher regexMatcher = XMLAnchorPattern.matcher(label);
        return regexMatcher.replaceAll("$2 ($1)");
    }

    public static String stripAnchors(String messageString) {
        if (messageString == null || !StatusUtil.hasAnchor(messageString)) {
            return messageString;
        }
        StringBuffer resultBuffer = new StringBuffer(messageString.length());
        int lastPos = 0;
        Matcher regexMatcher = anchorPattern.matcher(messageString);
        while (regexMatcher.find()) {
            resultBuffer.append(messageString.substring(lastPos, regexMatcher.start()));
            resultBuffer.append(regexMatcher.group(1));
            lastPos = regexMatcher.end();
        }
        resultBuffer.append(messageString.substring(lastPos));
        return resultBuffer.toString();
    }

    public static boolean hasAnchor(String messageString) {
        return messageString != null && messageString.indexOf("<a ") >= 0;
    }

    public static boolean hasAnchor(IStatus status) {
        if (status.isMultiStatus()) {
            IStatus[] iStatusArray = status.getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus child = iStatusArray[n2];
                if (StatusUtil.hasAnchor(child)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        return StatusUtil.hasAnchor(status.getMessage());
    }
}

