/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.utils;

import com.ibm.cic.common.core.utils.PathUtil;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public class FileURLUtil {
    private static final String FILE_STR = "file";

    public static String toFileString(String urlString) throws MalformedURLException {
        String path;
        try {
            URI uri = new URI(urlString);
            path = FILE_STR.equalsIgnoreCase(uri.getAuthority()) ? uri.getPath() : (FILE_STR.equalsIgnoreCase(uri.getScheme()) ? uri.getSchemeSpecificPart() : uri.toString());
        }
        catch (URISyntaxException uRISyntaxException) {
            URL url;
            try {
                url = new URL(urlString);
            }
            catch (MalformedURLException malformedURLException) {
                File file = new File(urlString);
                url = file.toURI().toURL();
            }
            path = url.getFile();
        }
        String mpath = PathUtil.massagePath(path, true, 3, true);
        return mpath;
    }

    public static File toFile(String urlString) throws MalformedURLException {
        String fileStr = FileURLUtil.toFileString(urlString);
        return new File(fileStr);
    }

    public static File locationToFile(String location) throws MalformedURLException {
        String urlString = FileURLUtil.toFileURLString(location);
        String fileStr = FileURLUtil.toFileString(urlString);
        return new File(fileStr);
    }

    public static boolean isFile(URL url) {
        String scheme = url.getProtocol();
        return FileURLUtil.isFileScheme(scheme);
    }

    public static boolean isURLString(String string, boolean fileSchemeIsURL) {
        URL url;
        try {
            url = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
        String scheme = url.getProtocol();
        if (scheme != null && scheme.length() != 0) {
            if (fileSchemeIsURL) {
                return true;
            }
            return !FileURLUtil.isFileScheme(scheme);
        }
        return false;
    }

    public static File toFile(URL url) {
        if (!FileURLUtil.isFile(url)) {
            return null;
        }
        try {
            return FileURLUtil.toFile(url.toString());
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static URL toUnescapedFileURL(File f) throws MalformedURLException {
        return f.toURL();
    }

    public static URL toFileURL(String location) throws MalformedURLException {
        URL url;
        try {
            url = new URL(location);
        }
        catch (MalformedURLException malformedURLException) {
            File file = new File(location);
            url = file.toURI().toURL();
        }
        return url;
    }

    public static String toFileURLString(String location) throws MalformedURLException {
        URL url = FileURLUtil.toFileURL(location);
        return url.toString();
    }

    public static boolean isFileLocation(String urlString) {
        String scheme;
        try {
            URI uri = new URI(urlString);
            scheme = uri.getAuthority();
            if (scheme == null || scheme.length() == 0) {
                scheme = uri.getScheme();
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            URL url;
            try {
                url = new URL(urlString);
            }
            catch (MalformedURLException malformedURLException) {
                return true;
            }
            scheme = url.getProtocol();
        }
        return FileURLUtil.isFileScheme(scheme);
    }

    public static boolean isFileScheme(String scheme) {
        File[] roots;
        if (scheme == null || scheme.length() == 0) {
            return true;
        }
        if (FILE_STR.equalsIgnoreCase(scheme)) {
            return true;
        }
        File[] fileArray = roots = File.listRoots();
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            String drive;
            File root = fileArray[n2];
            String path = root.toString();
            int ic = path.indexOf(58);
            if (ic != -1 && ic != 0 && path.length() == ic + 2 && PathUtil.isSeparator(path.charAt(ic + 1)) && (drive = path.substring(0, ic)).equalsIgnoreCase(scheme)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

