/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Arrays;

public enum Encodings {
    DEFAULT(Charset.defaultCharset()),
    UTF8("UTF-8"),
    LATIN1("ISO-8859-1"),
    ASCII("US-ASCII");

    private final Charset charset;

    private Encodings(String charsetName) {
        this(Charset.forName(charsetName));
    }

    private Encodings(Charset charset) {
        this.charset = charset;
    }

    public String getName() {
        return this.charset.name();
    }

    public Charset getCharset() {
        return this.charset;
    }

    public byte[] toBytes(String s) {
        return s.getBytes(this.charset);
    }

    public byte[] toBytes(char[] chars) {
        CharBuffer charBuffer = CharBuffer.wrap(chars);
        ByteBuffer byteBuffer = this.charset.encode(charBuffer);
        byte[] bytes = Arrays.copyOfRange(byteBuffer.array(), byteBuffer.position(), byteBuffer.limit());
        Arrays.fill(byteBuffer.array(), (byte)0);
        return bytes;
    }

    public String toString(byte[] b) {
        return new String(b, this.charset);
    }

    public char[] toChars(byte[] b) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(b);
        CharBuffer charBuffer = this.charset.decode(byteBuffer);
        char[] chars = Arrays.copyOfRange(charBuffer.array(), charBuffer.position(), charBuffer.limit());
        Arrays.fill(charBuffer.array(), '\u0000');
        return chars;
    }

    public String toString(ByteArrayOutputStream b) {
        try {
            return b.toString(this.charset.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new UnsupportedCharsetException(this.charset.name());
        }
    }

    public InputStream toInputStream(String s) {
        return new ByteArrayInputStream(this.toBytes(s));
    }

    public String read(File file) throws IOException {
        return this.read(new FileInputStream(file));
    }

    public String read(InputStream in) throws IOException {
        StringBuilder sb = new StringBuilder();
        char[] buffer = new char[8192];
        try (Reader reader = this.reader(in);){
            int nchars;
            while ((nchars = reader.read(buffer)) > 0) {
                sb.append(buffer, 0, nchars);
            }
        }
        return sb.toString();
    }

    public Reader reader(InputStream is) {
        return new InputStreamReader(is, this.charset);
    }

    public Reader reader(File file) throws FileNotFoundException {
        return new InputStreamReader((InputStream)new FileInputStream(file), this.charset);
    }

    public void write(File file, String contents) throws IOException {
        this.write(new FileOutputStream(file), contents);
    }

    public void write(File file, String contents, boolean append) throws IOException {
        this.write(new FileOutputStream(file, append), contents);
    }

    public void write(OutputStream os, String contents) throws IOException {
        try (Writer writer = this.writer(os);){
            writer.write(contents, 0, contents.length());
        }
    }

    public Writer writer(OutputStream os) {
        return new OutputStreamWriter(os, this.charset);
    }

    public Writer writer(File file) throws FileNotFoundException {
        return new OutputStreamWriter((OutputStream)new FileOutputStream(file), this.charset);
    }

    public PrintStream toPrintStream(OutputStream os) {
        try {
            return new PrintStream(os, false, this.charset.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new UnsupportedCharsetException(this.charset.name());
        }
    }
}

