/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.utils;

import com.ibm.cic.common.core.utils.SystemCharSets;
import com.ibm.cic.common.logging.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public class ConvertUtil {
    public static final String ASCII_codeset = "ASCII";
    public static final String EBCDIC_codeset = "Cp1047";

    private static void convertAndReplace(File sourceFile, String fromCodeSet, String toCodeSet) throws IOException {
        Logger.getGlobalLogger().debug("convertAndReplace: Converting: " + sourceFile.getAbsolutePath() + " FROM: " + fromCodeSet + " TO: " + toCodeSet);
        File tempFile = ConvertUtil.convertFile(sourceFile, fromCodeSet, toCodeSet);
        String filepath = sourceFile.getAbsolutePath();
        sourceFile.delete();
        ConvertUtil.copyFile(tempFile, new File(filepath), toCodeSet);
        tempFile.delete();
    }

    private static void copyFile(File source, File dest, String codeSet) throws IOException {
        int c;
        InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(source), codeSet);
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(dest), codeSet);
        while ((c = ((Reader)in).read()) != -1) {
            ((Writer)out).write(c);
        }
        ((Reader)in).close();
        ((Writer)out).close();
    }

    private static File convertFile(File sourceFile, String fromCodeSet, String toCodeSet) throws IOException {
        int c;
        if (!sourceFile.exists()) {
            throw new FileNotFoundException(sourceFile.getAbsolutePath());
        }
        File tempFile = File.createTempFile("IMCovertFrom" + fromCodeSet + "TO" + toCodeSet + "--", null);
        InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(sourceFile), fromCodeSet);
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(tempFile), toCodeSet);
        while ((c = ((Reader)in).read()) != -1) {
            ((Writer)out).write(c);
        }
        ((Reader)in).close();
        ((Writer)out).close();
        return tempFile;
    }

    public static File convertFileA2E(File sourceFile) throws IOException {
        SystemCharSets scs = new SystemCharSets();
        return ConvertUtil.convertFile(sourceFile, scs.getSystemASCII(), scs.getSystemEBCDIC());
    }

    public static File convertFileE2A(File sourceFile) throws IOException {
        SystemCharSets scs = new SystemCharSets();
        return ConvertUtil.convertFile(sourceFile, scs.getSystemEBCDIC(), scs.getSystemASCII());
    }

    public static void convertAndReplaceFileA2E(File sourceFile) throws IOException {
        SystemCharSets scs = new SystemCharSets();
        ConvertUtil.convertAndReplace(sourceFile, scs.getSystemASCII(), scs.getSystemEBCDIC());
    }

    public static void convertAndReplaceFileE2A(File sourceFile) throws IOException {
        SystemCharSets scs = new SystemCharSets();
        ConvertUtil.convertAndReplace(sourceFile, scs.getSystemEBCDIC(), scs.getSystemASCII());
    }

    private static String convertString(String str, String fromCharSet, String toCharSet) throws UnsupportedEncodingException {
        return new String(str.getBytes(fromCharSet), toCharSet);
    }

    public static String convertStringE2A(String str) {
        SystemCharSets scs = new SystemCharSets();
        try {
            return ConvertUtil.convertString(str, scs.getSystemEBCDIC(), scs.getSystemASCII());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Logger.getGlobalLogger().error("Invalid Codeset when trying to convert String. ");
            return null;
        }
    }

    public static String convertStringA2E(String str) {
        SystemCharSets scs = new SystemCharSets();
        try {
            return ConvertUtil.convertString(str, scs.getSystemASCII(), scs.getSystemEBCDIC());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Logger.getGlobalLogger().error("Invalid Codeset when trying to convert String. ");
            return null;
        }
    }
}

