/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.utils;

import com.ibm.cic.common.logging.Logger;
import java.io.PrintStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public class ConsoleProgressMonitor
implements IProgressMonitor {
    ExtSignalHandler externalSignalHandler;
    public static final int DEFAULT_PROGRESS_BAR_SIZE = 76;
    public static final char DEFAULT_PROGRESS_BAR_CHAR = '.';
    public static final char DEFAULT_ALTERNATE_PROGRESS_BAR_CHAR = ':';
    public static final int DEFAULT_MIN_TIME_PER_PROGRESS_BAR_CHAR = 2000;
    public static final char DEFAULT_RULER_CHAR = '-';
    public static final char DEFAULT_RULER_TICK_MARK_CHAR = '|';
    public static final int START_STATE = 0;
    public static final int BEGUN_STATE = 1;
    public static final int DONE_STATE = 2;
    private final IProgressMonitor progressWriter;
    private boolean canceled = false;
    private int state = 0;

    public static IProgressMonitor createMonitor(PrintStream out, int size) {
        ProgressBarWriter progressWriter = new ProgressBarWriter(out, size);
        ConsoleProgressMonitor monitor = new ConsoleProgressMonitor(progressWriter);
        progressWriter.setMonitor(monitor);
        return monitor;
    }

    public static IProgressMonitor createMonitor() {
        return ConsoleProgressMonitor.createMonitor(System.out, 76);
    }

    public static IProgressMonitor createMonitorWithUnknownWork(PrintStream out) {
        IProgressMonitor progressWriter = ConsoleProgressMonitor.createMonitor(out, 76);
        ProgressMonitorWrapper monitor = new ProgressMonitorWrapper(progressWriter){

            public void beginTask(String name, int totalWork) {
                super.beginTask(name, -1);
            }
        };
        return monitor;
    }

    public static IProgressMonitor createMonitorWithUnknownWork() {
        return ConsoleProgressMonitor.createMonitorWithUnknownWork(System.out);
    }

    public static IProgressMonitor createVerboseMonitor(PrintStream out) {
        VerboseProgressWriter verboseProgressWriter = new VerboseProgressWriter(out);
        ConsoleProgressMonitor monitor = new ConsoleProgressMonitor(verboseProgressWriter);
        verboseProgressWriter.setMonitor(monitor);
        return monitor;
    }

    public static IProgressMonitor createVerboseMonitor() {
        return ConsoleProgressMonitor.createVerboseMonitor(System.out);
    }

    public ConsoleProgressMonitor(IProgressMonitor progressWriter) {
        this.progressWriter = progressWriter;
        this.externalSignalHandler = new ExtSignalHandler();
    }

    public void beginTask(String name, int maxWork) {
        if (this.state != 0) {
            throw new IllegalStateException();
        }
        this.state = 1;
        this.progressWriter.beginTask(name, maxWork);
    }

    public void done() {
        if (this.state == 2) {
            return;
        }
        this.progressWriter.done();
        this.externalSignalHandler.done();
        this.state = 2;
    }

    public void internalWorked(double work) {
        if (work < 0.0) {
            throw new IllegalArgumentException();
        }
        this.checkBegunState();
        this.progressWriter.internalWorked(work);
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void setCanceled(boolean value) {
        this.canceled = value;
    }

    public void setTaskName(String name) {
        this.checkBegunState();
        this.progressWriter.setTaskName(name);
    }

    public void subTask(String name) {
        this.checkBegunState();
        this.progressWriter.subTask(name);
    }

    public void worked(int work) {
        this.internalWorked(work);
    }

    public int getState() {
        return this.state;
    }

    public void setConsoleActive(boolean isConsoleActive) {
        ((ProgressBarWriter)this.progressWriter).setConsoleActive(isConsoleActive);
    }

    private void checkBegunState() {
        if (this.state != 1) {
            throw new IllegalStateException();
        }
    }

    class ExtSignalHandler
    implements SignalHandler {
        private SignalHandler oldHandler;
        private final Signal extSignal = new Signal("INT");

        public ExtSignalHandler() {
            try {
                this.oldHandler = Signal.handle(this.extSignal, this);
            }
            catch (IllegalArgumentException e) {
                Logger.getLogger().error(e);
            }
        }

        @Override
        public void handle(Signal sig) {
            ConsoleProgressMonitor.this.canceled = true;
        }

        public void done() {
            if (this.oldHandler != null) {
                try {
                    Signal.handle(this.extSignal, this.oldHandler);
                }
                catch (IllegalArgumentException e) {
                    Logger.getLogger().error(e);
                }
                this.oldHandler = null;
            }
        }
    }

    public static class ProgressBarWriter
    implements IProgressMonitor {
        private static final int MIN_SIZE = 48;
        private ConsoleProgressMonitor monitor;
        PrintStream out;
        private final int size;
        String task = "";
        private double totalWork = -1.0;
        private double workPerChar = -1.0;
        private double curWork = 0.0;
        private int curChars = 0;
        long lastTime = 0L;
        private char lastProgressChar = '\u0000';
        private boolean isConsoleActive = System.console() != null;

        public ProgressBarWriter(PrintStream out, int size) {
            this.out = out;
            this.size = ProgressBarWriter.adjustSize(size);
        }

        public void beginTask(String name, int maxWork) {
            this.internalBeginTask(name, maxWork, false);
        }

        void internalBeginTask(String name, int maxWork, boolean silent) {
            this.setTaskName(name);
            this.totalWork = maxWork;
            double d = this.workPerChar = this.isTotalWorkKnown() ? this.totalWork / (double)this.size : -1.0;
            if (this.task.length() != 0 && !silent) {
                this.out.println(this.task);
            }
            if (this.isTotalWorkKnown()) {
                this.out.println(this.getRulerLabels());
                this.out.println(this.getRuler());
            }
            this.lastTime = System.currentTimeMillis();
        }

        public void done() {
            if (this.monitor.getState() == 1) {
                if (this.isTotalWorkKnown()) {
                    this.workWithKnownTotal(this.totalWork);
                }
                this.ensureNewLine();
            }
        }

        public void internalWorked(double work) {
            if (this.isTotalWorkKnown()) {
                this.workWithKnownTotal(work);
            } else {
                this.workWithUnknownTotal(work);
            }
        }

        public boolean isCanceled() {
            return false;
        }

        public void setCanceled(boolean value) {
        }

        public void setTaskName(String name) {
            this.task = name == null ? "" : name.trim();
        }

        public void subTask(String name) {
        }

        public void worked(int work) {
            this.internalWorked(work);
        }

        public void setMonitor(ConsoleProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public int getSize() {
            return this.size;
        }

        protected char getProgressChar() {
            return '.';
        }

        protected char getAlternateProgressChar() {
            return ':';
        }

        protected char getMinTimePerProgressChar() {
            return '\u07d0';
        }

        protected char getRulerChar() {
            return '-';
        }

        protected char getRulerTickMarkChar() {
            return '|';
        }

        private boolean isConsoleActive() {
            return this.isConsoleActive;
        }

        private void setConsoleActive(boolean isConsoleActive) {
            this.isConsoleActive = isConsoleActive;
        }

        private static int adjustSize(int size) {
            int adjustedSize = size < 48 ? 48 : size;
            adjustedSize = adjustedSize + 3 & 0xFFFFFFFC;
            return adjustedSize;
        }

        private boolean isTotalWorkKnown() {
            return this.totalWork >= 0.0;
        }

        private boolean isTotalWorkZero() {
            return this.totalWork == 0.0;
        }

        private void workWithKnownTotal(double work) {
            long currentTime;
            long delta;
            int newCurChars;
            this.curWork += work;
            if (this.curWork > this.totalWork) {
                this.curWork = this.totalWork;
            }
            if ((newCurChars = this.isTotalWorkZero() ? this.size : (int)(this.curWork / this.workPerChar)) > this.curChars) {
                int delta2 = newCurChars - this.curChars;
                if (this.lastProgressChar == this.getAlternateProgressChar()) {
                    this.out.print('\b');
                    ++delta2;
                }
                char progressChar = this.getProgressChar();
                int i = 0;
                while (i < delta2) {
                    this.out.print(progressChar);
                    ++i;
                }
                this.lastProgressChar = progressChar;
                this.curChars = newCurChars;
                this.lastTime = System.currentTimeMillis();
            } else if (this.lastProgressChar != '\u0000' && this.isConsoleActive() && (delta = (currentTime = System.currentTimeMillis()) - this.lastTime) > (long)this.getMinTimePerProgressChar()) {
                char progressChar = this.getProgressChar();
                char alternateProgressChar = this.getAlternateProgressChar();
                char curProgressChar = this.lastProgressChar == progressChar ? alternateProgressChar : progressChar;
                this.out.print('\b');
                this.out.print(curProgressChar);
                this.lastProgressChar = curProgressChar;
                this.lastTime = currentTime;
            }
        }

        private void workWithUnknownTotal(double work) {
            long currentTime = System.currentTimeMillis();
            long delta = currentTime - this.lastTime;
            if (delta > (long)this.getMinTimePerProgressChar()) {
                char progressChar = this.getProgressChar();
                this.out.print(progressChar);
                this.lastProgressChar = progressChar;
                this.lastTime = currentTime;
            }
        }

        protected String getRulerLabels() {
            int charsPerQuarter = this.size / 4;
            StringBuffer sb = new StringBuffer(this.size + 2);
            int i = 1;
            while (i <= 4) {
                int tab = i * charsPerQuarter - 2;
                while (sb.length() != tab) {
                    sb.append(' ');
                }
                sb.append(i * 25);
                sb.append('%');
                ++i;
            }
            return sb.toString();
        }

        protected String getRuler() {
            int charsPerQuarter = this.size / 4;
            int rulerCharsPerQuarter = charsPerQuarter - 1;
            StringBuffer sb = new StringBuffer(this.size);
            char rulerChar = this.getRulerChar();
            char rulerTickMarkChar = this.getRulerTickMarkChar();
            int i = 0;
            while (i < 4) {
                int j = 0;
                while (j < rulerCharsPerQuarter) {
                    sb.append(rulerChar);
                    ++j;
                }
                sb.append(rulerTickMarkChar);
                ++i;
            }
            return sb.toString();
        }

        protected void ensureNewLine() {
            if (this.lastProgressChar != '\u0000') {
                this.out.println();
                this.lastProgressChar = '\u0000';
            }
        }
    }

    public static class VerboseProgressWriter
    extends ProgressBarWriter {
        private String subTask = "";

        protected VerboseProgressWriter(PrintStream out) {
            super(out, 76);
        }

        @Override
        public void beginTask(String name, int maxWork) {
            this.internalBeginTask(name, -1, true);
        }

        @Override
        public void setTaskName(String name) {
            String newTask;
            String string = newTask = name == null ? "" : name.trim();
            if (newTask.length() != 0 && !newTask.equals(this.task)) {
                this.println(newTask);
                this.task = newTask;
            }
        }

        @Override
        public void subTask(String name) {
            String newSubTask;
            String string = newSubTask = name == null ? "" : name.trim();
            if (newSubTask.length() != 0 && !newSubTask.equals(this.subTask)) {
                this.println(newSubTask);
                this.subTask = newSubTask;
            }
        }

        private void println(String s) {
            this.ensureNewLine();
            this.out.println(s);
            this.lastTime = System.currentTimeMillis();
        }
    }
}

