/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.utils;

public class CallStack {
    private static final String THIS_CLASS_NAME = CallStack.class.getName();

    public static String getCallingClass() {
        return CallStack.getCaller().getClassName();
    }

    public static String getCallingMethod() {
        return CallStack.getCaller().getMethodName();
    }

    public static String getFullCallingMethod() {
        StackTraceElement element = CallStack.getCaller();
        return String.valueOf(element.getClassName()) + '.' + element.getMethodName();
    }

    public static StackTraceElement getCaller() {
        return CallStack.getCaller(new CountingFilter(1));
    }

    public static StackTraceElement getCaller(Filter filter) {
        return CallStack.getCaller(filter, new Throwable().getStackTrace());
    }

    public static StackTraceElement getCaller(Filter filter, StackTraceElement[] stack) {
        StackTraceElement[] stackTraceElementArray = stack;
        int n = stack.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement elem = stackTraceElementArray[n2];
            if (!elem.getClassName().equals(THIS_CLASS_NAME) && filter.include(elem)) {
                return elem;
            }
            ++n2;
        }
        return null;
    }

    public static class CountingFilter
    extends Filter {
        private int count;

        public CountingFilter(int count) {
            this.count = count;
        }

        @Override
        protected boolean include(StackTraceElement elem) {
            return this.count-- == 0;
        }
    }

    public static class ExcludeClassFilter
    extends Filter {
        private final String className;

        public ExcludeClassFilter(Class clazz) {
            this.className = clazz.getName();
        }

        @Override
        protected boolean include(StackTraceElement elem) {
            return !elem.getClassName().equals(this.className);
        }
    }

    public static abstract class Filter {
        protected abstract boolean include(StackTraceElement var1);

        public Filter or(final Filter that) {
            return new Filter(){

                @Override
                protected boolean include(StackTraceElement elem) {
                    return Filter.this.include(elem) || that.include(elem);
                }
            };
        }
    }
}

