/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.utils;

import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.Messages;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.PathUtil;
import com.ibm.cic.common.logging.Logger;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public class BackupDirectoryFilesKeepStructure {
    private static final String BACKUP_DIR_NAME = "backup";
    private static final String BACKUP_DOT_DIR_NAME = "backup.";
    protected Logger log;
    protected File backedUpDir;
    protected File backupParentDir;
    protected File backupDir;
    protected boolean initedBackupDir;

    public BackupDirectoryFilesKeepStructure(Logger log, File backedUpDir, File backupParentDir) {
        this.log = log;
        this.backedUpDir = backedUpDir;
        this.backupParentDir = backupParentDir;
        this.initedBackupDir = false;
    }

    protected void logFailedToCreateBackupDir() {
        this.log.error(Messages.BackupDirectory_failed_to_create_new_backup_dir, this.backupParentDir);
    }

    protected void logBackupFile(File file, File backupFile) {
        this.log.info(Messages.BackupDirectory_backed_up_file, file, backupFile);
    }

    protected void logInternalErrorMakingBackup(File file) {
        this.log.error(Messages.BackupDirectory_internal_error_for_file, file);
    }

    protected void logBackupDirectory(File srcDir, File _backupDir) {
        this.log.info(Messages.BackupDirectory_backed_up_directory, srcDir, _backupDir);
    }

    private File getBackupDir() {
        if (!this.initedBackupDir) {
            File candidateDir = new File(this.backupParentDir, BACKUP_DIR_NAME);
            int i = 1;
            while (candidateDir.exists()) {
                candidateDir = new File(this.backupParentDir, BACKUP_DOT_DIR_NAME + PathUtil.formatZeroPaddedCount(3, i++));
                if (i != 101) continue;
                this.backupDir = null;
                this.initedBackupDir = true;
                this.logFailedToCreateBackupDir();
                return null;
            }
            this.backupDir = candidateDir;
            this.initedBackupDir = true;
        }
        return this.backupDir;
    }

    public File getBackedUpDir() {
        return this.backedUpDir;
    }

    public IPath makeRelative(File file) {
        IPath path = this.makePath(file);
        IPath root = this.makePath(this.backedUpDir);
        IPath relPath = PathUtil.makeRelative(root, path);
        if (relPath == path) {
            this.logInternalErrorMakingBackup(file);
            return null;
        }
        return relPath;
    }

    private IPath makePath(File file) {
        String s = file.getAbsolutePath();
        if (file.isDirectory()) {
            s = String.valueOf(s) + '/';
        }
        return new Path(s);
    }

    public File backupFile(File file, IProgressMonitor monitor) {
        IPath relPath = this.makeRelative(file);
        if (relPath == null) {
            return null;
        }
        return this.backupRelative(file, relPath, monitor);
    }

    private File backupRelative(File file, IPath relPath, IProgressMonitor monitor) {
        File backupFile = this.getBackupFile(relPath);
        if (!file.exists()) {
            return backupFile;
        }
        FileUtil.ensureDestinationDirectory(backupFile);
        try {
            FileUtil.copyFile(file, backupFile, monitor);
        }
        catch (IOException e) {
            this.log.error(Messages.BackupDirectory_failed_file_backup, file, backupFile, e);
            return null;
        }
        backupFile.setLastModified(file.lastModified());
        this.logBackupFile(file, backupFile);
        return backupFile;
    }

    private File getBackupFile(IPath relPath) {
        File _backupDir = this.getBackupDir();
        if (_backupDir == null) {
            return null;
        }
        File backupFile = new File(_backupDir, relPath.toString());
        return backupFile;
    }

    public boolean backupDir(File srcDir, IProgressMonitor monitor) {
        IPath relativePath = this.makeRelative(srcDir);
        if (relativePath == null) {
            return false;
        }
        File _backupDir = this.getBackupFile(relativePath);
        if (_backupDir == null) {
            return false;
        }
        FileUtil.ensureDirectory(_backupDir);
        try {
            FileUtil.copyDir(srcDir, _backupDir, false, false, false, true, true, NLS.bind(Messages.BackupDirectory_task_backing_up, (Object)srcDir), monitor);
            this.logBackupDirectory(srcDir, _backupDir);
            return true;
        }
        catch (IOException e) {
            this.log.error(Messages.BackupDirectory_failed_directory_backup, srcDir, _backupDir, e);
            return false;
        }
    }
}

